/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.certficate;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import oracle.cloud.paas.client.cli.command.common.CommonBaseExecutor;
import oracle.cloud.paas.client.cli.command.common.certficate.CertificateServiceExtension;
import oracle.cloud.paas.client.cli.command.common.certficate.CommonGetCertificates;
import oracle.cloudlogic.javaservice.common.api.ServiceManager;
import oracle.cloudlogic.javaservice.common.api.exception.UnknownResourceException;
import oracle.cloudlogic.javaservice.common.api.service.Service;
import oracle.cloudlogic.javaservice.common.api.service.resource.CertificateService;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class CommonAddCertificates
extends CommonBaseExecutor {
    private List<String> aliases;
    private String path;
    private String storePwd = null;
    private CommonGetCertificates.CERT_TYPE cert_type = null;

    @Override
    public void validate() throws CliException {
        super.validate();
        String alias = this.command.getArgValue("alias");
        if (alias != null) {
            alias = CloudUtil.parseAndRemoveDuplicates(alias, ",");
            this.aliases = CloudUtil.parseString(alias, ",", true);
        }
        this.path = this.command.getArgValue("path");
        this.storePwd = this.command.getArgValue("storepassword");
        FileInputStream fis = null;
        try {
            this.path = CloudUtil.validateInputFile(this.path, "path").getAbsolutePath();
            fis = new FileInputStream(this.path);
        }
        catch (Exception e) {
            throw new CliException("Validation failed.", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception io) {}
            }
        }
        String type = this.command.getArgValue("certfiletype");
        if (type == null) {
            type = CloudUtil.getFileExtension(this.path);
        }
        if (type == null) {
            type = this.aliases != null && this.aliases.size() == 1 ? "cer" : "jks";
            Logger.getDEFAULT().printlnWarning("Assuming input file type:" + type + ". If this is not correct, please use -" + "certfiletype");
        }
        try {
            try {
                this.cert_type = CommonGetCertificates.CERT_TYPE.valueOf(type.toUpperCase());
            }
            catch (Exception e) {
                throw new Exception(NLSUtil.localizeMessage("NLS_OPTION_VALUE_INVALID_FOR_POSSIBLE_VALUES", new Object[]{"certfiletype", type, CloudUtil.getCommaSeparatedListOfString(CloudUtil.getEnumValuesAsList(CommonGetCertificates.CERT_TYPE.class))}));
            }
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
        if (this.cert_type == CommonGetCertificates.CERT_TYPE.CER) {
            if (this.aliases == null || this.aliases.isEmpty()) {
                if (this.aliases == null) {
                    this.aliases = new ArrayList<String>();
                }
                this.aliases.add(CloudUtil.getFileBaseName(new File(this.path).getName()));
            }
            if (this.aliases.size() > 1) {
                Logger.getDEFAULT().printlnWarning("Using the first alias:" + this.aliases.get(0) + " and ignoring the rest.");
            }
        }
    }

    @Override
    public void invoke(ServiceManager client) throws Exception {
        throw new RuntimeException("Not to be called ...");
    }

    public void invoke(CertificateService c) throws Exception {
        FileInputStream fis = null;
        int count = 0;
        try {
            fis = new FileInputStream(this.path);
            if (this.cert_type == CommonGetCertificates.CERT_TYPE.CER) {
                try {
                    c.describeCertificate(this.aliases.get(0));
                    Logger.getDEFAULT().printlnWarning("Alias " + this.aliases.get(0) + " already exists.");
                }
                catch (UnknownResourceException un) {
                    c.addCertificate((InputStream)fis, this.aliases.get(0));
                    count = 1;
                }
            } else {
                if (this.aliases != null && this.aliases.isEmpty()) {
                    this.aliases = null;
                }
                CertificateServiceExtension ext = CertificateServiceExtension.getExtensionFor(c);
                if (this.cert_type == CommonGetCertificates.CERT_TYPE.PEM) {
                    InputStreamReader reader = new InputStreamReader(fis);
                    count = ext.addCertificates(reader, this.aliases);
                    if (count == 0) {
                        Logger.getDEFAULT().printlnTip("Certificate file in PEM format must define a header called alias. E.g)\n\n-----BEGIN CERTIFICATE-----\nalias: myalias\n\nMIICGDCCAcKgAwIBAgIQI0tVWdH6Dz/1yCvf7QMqhzANBgkqhkiG9w0BAQQFADB5\n.....\n-----END CERTIFICATE-----\n");
                    }
                } else {
                    KeyStore keyStore;
                    block22: {
                        keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                        try {
                            keyStore.load(fis, this.storePwd == null ? null : this.storePwd.toCharArray());
                        }
                        catch (Exception e) {
                            Logger.getDEFAULT().printlnInfo("Keystore could not be opened.");
                            if (this.storePwd != null) break block22;
                            this.command.getArgs().get("storepassword").prompt();
                            this.storePwd = this.command.getArgValue("storepassword");
                            if (this.storePwd == null) {
                                throw e;
                            }
                            keyStore.load(fis, this.storePwd.toCharArray());
                        }
                    }
                    count = ext.addCertificates(keyStore, this.aliases);
                }
            }
            if (count == 0) {
                throw new Exception("No certificates added.");
            }
            Logger.getDEFAULT().printlnInfo(count + " certificate(s) added.");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception io) {}
            }
        }
    }

    public Class<? extends Service> getServiceClass() {
        throw new RuntimeException("Not to be called ...");
    }
}

