/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common;

import oracle.cloud.paas.client.cli.command.common.CommonBaseExecutor;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public abstract class ListingCommonBaseExecutor
extends CommonBaseExecutor {
    protected boolean grid = false;
    protected int gridWidth = 180;
    protected boolean descending = false;
    protected String sorton = null;
    protected boolean verbose = false;

    @Override
    public void validate() throws CliException {
        block6: {
            super.validate();
            try {
                String gw;
                this.grid = this.command.getValueAsBoolean("grid");
                this.verbose = this.command.getValueAsBoolean("verbose");
                this.descending = this.command.getValueAsBoolean("descending");
                this.sorton = this.command.getArgValue("sorton");
                if ((this.sorton == null || this.sorton.trim().equals("")) && this.descending) {
                    Logger.getDEFAULT().printlnWarning("descending is not applicable when sorton is not specified.");
                }
                if ((gw = this.command.getArgValue("gridwidth")) == null) break block6;
                try {
                    this.gridWidth = Integer.parseInt(gw);
                    if (this.gridWidth < 0) {
                        throw new NumberFormatException("gridwidth must be a positive integer");
                    }
                }
                catch (NumberFormatException e) {
                    throw new CliException("Please enter valid value for gridwidth", e);
                }
            }
            catch (Exception e) {
                throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
            }
        }
    }
}

