/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common;

import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;
import oracle.cloud.paas.client.ClientConstants;
import oracle.cloud.paas.client.cli.command.BaseExecutor;
import oracle.cloudlogic.javaservice.common.api.ServiceManager;
import oracle.cloudlogic.javaservice.common.api.ServiceManagerFactory;
import oracle.cloudlogic.javaservice.common.api.exception.AuthenticationException;
import oracle.cloudlogic.javaservice.common.api.exception.DuplicateResourceException;
import oracle.cloudlogic.javaservice.common.api.exception.MissingPropertyException;
import oracle.cloudlogic.javaservice.common.api.exception.NotAServiceUrlException;
import oracle.cloudlogic.javaservice.common.api.exception.ResourceBusyException;
import oracle.cloudlogic.javaservice.common.api.exception.ResourcePermissionException;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceNotAvailableException;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceResourceException;
import oracle.cloudlogic.javaservice.common.api.exception.UnknownResourceException;
import oracle.cloudlogic.javaservice.common.api.service.Service;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.executor.ManagableExecutor;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public abstract class CommonBaseExecutor
extends BaseExecutor
implements ManagableExecutor,
ClientConstants {
    private Map<String, Object> providerProperties = new HashMap<String, Object>();
    public static final Map<String, ServiceManager> APP_MANAGER_CACHE_FOR_LOCAL = new HashMap<String, ServiceManager>(1);
    ServiceManager serviceManager = null;
    protected String serviceID = null;
    private boolean onUi = false;
    private String providerprops = null;

    public String getServiceID() {
        return this.serviceID;
    }

    public abstract void invoke(ServiceManager var1) throws Exception;

    public abstract <T extends Service> Class<T> getServiceClass();

    @Override
    public void invoke() throws Exception {
        throw new Exception("Not allowed.");
    }

    @Override
    public void execute() throws Exception {
        if (this.command.toEnableDebug()) {
            Logger.getDEFAULT().addAllowed(Logger.LOG_MESSAGE_TYPES.DEBUG);
        }
        ClassLoader old = null;
        try {
            if (this.additionalClassPath != null) {
                Logger.getDEFAULT().printlnDebug("Setting up new classpath with : " + this.additionalClassPath);
                old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(CloudUtil.createURLClassLoader(this.additionalClassPath));
            }
            this.validateAdditional();
            this.invoke(this.serviceManager);
        }
        catch (Exception e) {
            if (CloudUtil.isCausedBy(e, SSLException.class)) {
                throw new RuntimeException(NLSUtil.localizeMessage("NLS_EXCEPTION_SSL", new Object[]{"trustservercert"}), e);
            }
            ServiceException me = CloudUtil.getCause(e, ServiceException.class);
            if (me == null) {
                throw e;
            }
            Logger.getDEFAULT().printlnThrowable(e);
            me.translateMessagesIntoCause();
            if (e.getMessage() == null || e.getMessage().trim().equals("")) {
                ServiceResourceException sr = null;
                if (ServiceResourceException.class.isAssignableFrom(e.getClass())) {
                    sr = (ServiceResourceException)e;
                }
                if (sr != null) {
                    if (DuplicateResourceException.class.isAssignableFrom(me.getClass())) {
                        throw new DuplicateResourceException(sr, NLSUtil.localizeMessage("NLS_RESOURCE_DUPLICATE", sr.getResourceType(), sr.getResourceName()));
                    }
                    if (ResourceBusyException.class.isAssignableFrom(me.getClass())) {
                        throw new ResourceBusyException((ResourceBusyException)sr, NLSUtil.localizeMessage("NLS_RESOURCE_BUSY", sr.getResourceType(), sr.getResourceName()));
                    }
                    if (UnknownResourceException.class.isAssignableFrom(me.getClass())) {
                        throw new UnknownResourceException(sr, NLSUtil.localizeMessage("NLS_RESOURCE_NOT_FOUND", sr.getResourceType(), sr.getResourceName()));
                    }
                    if (ResourcePermissionException.class.isAssignableFrom(me.getClass())) {
                        throw new ResourcePermissionException(sr, NLSUtil.localizeMessage("NLS_RESOURCE_NO_PERMISSION", sr.getResourceType(), sr.getResourceName()));
                    }
                }
                if (AuthenticationException.class.isAssignableFrom(me.getClass())) {
                    super.handleAuthenticationException();
                    throw new AuthenticationException(NLSUtil.localizeMessage("NLS_RESOURCE_AUTH_FAILED"));
                }
                if (MissingPropertyException.class.isAssignableFrom(me.getClass())) {
                    throw new MissingPropertyException(((MissingPropertyException)me).getPropertyName(), NLSUtil.localizeMessage("NLS_SERVICE_MISSING_PROPERTY", ((MissingPropertyException)me).getPropertyName()));
                }
                if (NotAServiceUrlException.class.isAssignableFrom(me.getClass())) {
                    throw new NotAServiceUrlException(NLSUtil.localizeMessage("NLS_RESOURCE_NOT_A_SERVICE_URL", this.adminUrl));
                }
                if (ServiceNotAvailableException.class.isAssignableFrom(me.getClass())) {
                    throw new ServiceNotAvailableException(NLSUtil.localizeMessage("NLS_SERVICE_NOT_AVAILABLE"));
                }
            }
            throw e;
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
            Logger.getDEFAULT().flush();
        }
    }

    @Override
    public void validate() throws CliException {
        super.validate();
        this.serviceID = this.command.getArgValue("serviceinstance");
        this.providerprops = this.command.getArgValue("providerproperties");
        if (this.providerprops != null) {
            OrderedMap<String, String> commandlineProperties = CloudUtil.parseCommandlineProperties(this.providerprops, null);
            for (NameValuePair<String, String> pair : commandlineProperties.getList()) {
                if (pair.getName() == null || "".equals(pair.getName().trim())) continue;
                this.providerProperties.put(pair.getName(), pair.getValue());
            }
        }
    }

    private void validateAdditional() throws Exception {
        this.serviceManager = APP_MANAGER_CACHE_FOR_LOCAL.get(this.adminUrl + this.userName);
        if (this.serviceManager == null) {
            this.providerProperties.put("identitydomain", this.tenantID);
            this.providerProperties.put("serviceinstance", this.serviceID);
            Logger.getDEFAULT().printlnDebug("Creating Service manager");
            this.serviceManager = ServiceManagerFactory.createServiceManager(null, (String)this.adminUrl, (String)this.userName, (byte[])(this.pwd == null ? null : this.pwd.getBytes("UTF-8")), this.providerProperties);
            if (this.serviceManager != null) {
                APP_MANAGER_CACHE_FOR_LOCAL.put(this.adminUrl + this.userName, this.serviceManager);
                Logger.getDEFAULT().printlnDebug("Service Manager: " + this.serviceManager);
            }
        } else {
            Logger.getDEFAULT().printlnDebug("Re-using application manager");
        }
    }

    @Override
    public void prepareToBeManaged() {
        this.onUi = true;
    }

    @Override
    public boolean isOnUi() {
        return this.onUi;
    }
}

