/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.util.Date;
import java.util.List;
import oracle.cloud.paas.api.LibraryManager;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.client.cli.command.LibraryJobBaseExecutor;
import oracle.cloud.paas.model.Library;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class UninstallLibrary
extends LibraryJobBaseExecutor {
    String serviceID = null;
    String libraryName = null;
    private String libraryDeployType = null;
    private String librarySpecVersion = null;
    private String libraryImplVersion = null;
    private String libraryType = null;
    private String DomainName = null;
    private String InstanceName = null;
    private boolean ForceOption;
    private Library library = null;

    @Override
    public void validate() throws CliException {
        try {
            super.validate();
            this.libraryName = this.command.getArgValue("library");
            if (this.libraryName == null || this.libraryName.trim().equals("")) {
                throw new CliException(NLSUtil.localizeMessage("OPTION_VALUE_REQUIRED", "library"));
            }
            this.librarySpecVersion = this.command.getArgValue("specversion");
            if (this.librarySpecVersion == null || this.librarySpecVersion.trim().equals("")) {
                throw new CliException(NLSUtil.localizeMessage("OPTION_VALUE_REQUIRED", "specversion"));
            }
            this.libraryImplVersion = this.command.getArgValue("implversion");
            if (this.libraryImplVersion == null || this.libraryImplVersion.trim().equals("")) {
                throw new CliException(NLSUtil.localizeMessage("OPTION_VALUE_REQUIRED", "implversion"));
            }
            this.DomainName = this.command.getArgValue("identitydomain");
            if (this.DomainName == null || this.DomainName.trim().equals("")) {
                throw new CliException(NLSUtil.localizeMessage("OPTION_VALUE_REQUIRED", "identitydomain"));
            }
            this.InstanceName = this.command.getArgValue("serviceinstance");
            if (this.InstanceName == null || this.InstanceName.trim().equals("")) {
                throw new CliException(NLSUtil.localizeMessage("OPTION_VALUE_REQUIRED", "serviceinstance"));
            }
            this.ForceOption = this.command.getValueAsBoolean("force");
            this.library = new Library();
            this.library.setDomainName(this.DomainName);
            this.library.setInstanceName(this.InstanceName);
            this.library.setName(this.libraryName);
            this.library.setSpecVersion(this.librarySpecVersion);
            this.library.setImplVersion(this.libraryImplVersion);
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    @Override
    public void createJob(LibraryManager client) throws Exception {
        List check;
        if (!this.ForceOption && !(check = client.getReferencingApplicationNames(this.library)).isEmpty()) {
            throw new Exception("The shared library could not be un-installed as it is being referenced by other applications. Use -force option to un-install forcefully.");
        }
        this.job = client.undeployLibrary(this.library);
        if (this.job == null) {
            throw new Exception("The shared library could not be un-installed");
        }
        this.createdJob = this.job;
        Logger.getDEFAULT().printlnInfoI18n("NLS_INFO_LIB_REMOVE");
        BeanUtils.print(this.job, 1, false, false, new Date(), null);
    }
}

