/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.util.Collections;
import java.util.List;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.client.cli.bean.MetricComparator;
import oracle.cloud.paas.client.cli.command.ServiceBaseGridGroupByExecutor;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;

public class ListServiceMetrics
extends ServiceBaseGridGroupByExecutor {
    protected String applicationID = null;
    protected boolean tree = false;

    @Override
    public void validate() throws CliException {
        super.validate();
        try {
            this.applicationID = this.command.getArgValue("application");
            this.tree = this.command.getValueAsBoolean("gridtree");
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    @Override
    public void invoke(ApplicationManager client) throws Exception {
        List list = null;
        String caption = "identity domain=" + this.tenantID + " , service instance=" + this.serviceID;
        if (this.applicationID != null && !this.applicationID.trim().equals("")) {
            caption = caption + ", application name=" + this.applicationID;
            list = this.metricName == null ? client.queryApplicationMetricsWithMetadata(this.tenantID, this.serviceID, this.applicationID, this.groupby == null ? null : this.groupby.toString()) : client.queryApplicationMetricsWithMetadata(this.tenantID, this.serviceID, this.applicationID, this.metricName, this.groupby == null ? null : this.groupby.toString());
        } else {
            list = this.metricName == null ? client.queryServiceInstanceMetricsWithMetadata(this.tenantID, this.serviceID, this.groupby == null ? null : this.groupby.toString()) : client.queryServiceInstanceMetricsWithMetadata(this.tenantID, this.serviceID, this.metricName, this.groupby == null ? null : this.groupby.toString());
        }
        if (this.sortField != null) {
            Collections.sort(list, new MetricComparator(this.sortField, this.descending));
        }
        BeanUtils.printMetrics(caption, list, this.gridWidth, this.full, this.tree);
    }
}

