/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.util.List;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.client.cli.command.ApplicationBaseExecutor;
import oracle.cloud.paas.model.ServiceInstance;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;

public class ListServiceInstances
extends ApplicationBaseExecutor {
    private boolean grid = false;
    private int gridWidth = 180;
    private boolean full = false;
    List<ServiceInstance> list = null;

    public List<ServiceInstance> getList() {
        return this.list;
    }

    @Override
    public void validate() throws CliException {
        block5: {
            super.validate();
            try {
                this.full = this.command.getValueAsBoolean("verbose");
                this.grid = this.command.getValueAsBoolean("grid");
                String gw = this.command.getArgValue("gridwidth");
                if (gw == null) break block5;
                try {
                    this.gridWidth = Integer.parseInt(gw);
                    if (this.gridWidth < 0) {
                        throw new NumberFormatException("gridwidth must be a positive integer");
                    }
                }
                catch (NumberFormatException e) {
                    throw new CliException("Please enter valid value for gridwidth", e);
                }
            }
            catch (Exception e) {
                throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
            }
        }
    }

    @Override
    public void invoke(ApplicationManager client) throws Exception {
        this.list = client.listServiceInstances(this.tenantID);
        BeanUtils.printServiceInstances(this.tenantID, this.list, this.grid, this.gridWidth, this.full, true, 0);
        if (this.list.isEmpty()) {
            throw new Exception("No service instances found");
        }
    }
}

