/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.api.JobManager;
import oracle.cloud.paas.api.JobQuery;
import oracle.cloud.paas.api.JobQueryBuilder;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.client.cli.bean.JobComparator;
import oracle.cloud.paas.client.cli.command.ServiceBaseGridVerboseExecutor;
import oracle.cloud.paas.exception.ManagerException;
import oracle.cloud.paas.model.Job;
import oracle.cloud.paas.model.JobStatus;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class ListJobs
extends ServiceBaseGridVerboseExecutor {
    List<String> applicationIDs = null;
    List<JobStatus> status = new ArrayList<JobStatus>();
    JobComparator.FIELD sortField = null;
    JobQueryBuilder builder = null;
    int limit = -1;

    @Override
    public void validate() throws CliException {
        block13: {
            super.validate();
            try {
                String applicationIDList;
                String allStatus;
                String lim = this.command.getArgValue("limit");
                if (lim != null && !lim.trim().equals("")) {
                    try {
                        this.limit = Integer.parseInt(lim);
                    }
                    catch (NumberFormatException e) {
                        throw new CliException("Please enter valid value for limit", e);
                    }
                }
                if ((allStatus = this.command.getArgValue("status")) != null && !allStatus.trim().equals("")) {
                    List<String> st = null;
                    st = CloudUtil.parseString(allStatus, ",");
                    if (st != null) {
                        for (String s : st) {
                            if (s == null || s.trim().equals("")) continue;
                            try {
                                JobStatus sv = JobStatus.valueOf((String)s.toUpperCase());
                                if (this.status.contains(sv)) continue;
                                this.status.add(sv);
                            }
                            catch (Exception e) {
                                throw new Exception(NLSUtil.localizeMessage("NLS_OPTION_VALUE_INVALID_FOR_POSSIBLE_VALUES", new Object[]{"status", s, CloudUtil.getCommaSeparatedListOfString(this.command.getArgs().get("status").getPossibleEnumValues())}));
                            }
                        }
                    }
                }
                if ((applicationIDList = this.command.getArgValue("application")) != null) {
                    this.applicationIDs = CloudUtil.parseString(applicationIDList, ",");
                }
                if (this.sorton == null || this.sorton.trim().equals("")) break block13;
                try {
                    this.sortField = JobComparator.FIELD.valueOf(this.sorton.toUpperCase());
                }
                catch (Exception e) {
                    throw new Exception(NLSUtil.localizeMessage("NLS_OPTION_VALUE_INVALID_FOR_POSSIBLE_VALUES", new Object[]{"sorton", this.sorton, CloudUtil.getCommaSeparatedListOfString(CloudUtil.getEnumValuesAsList(JobComparator.FIELD.class))}));
                }
            }
            catch (Exception e) {
                throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
            }
        }
    }

    @Override
    public void invoke(ApplicationManager client) {
        if (this.isLocal() && !this.isOnUi()) {
            throw new ManagerException("Un-supported operation from CLI against local domain");
        }
        this.builder = JobQueryBuilder.createBuilder();
        if (this.limit > 0) {
            this.builder.limit(this.limit);
        }
        this.builder.identityDomain(this.tenantID);
        String title = "identity domain=" + this.tenantID;
        boolean includeInstance = true;
        boolean includeApplication = true;
        boolean includestatus = true;
        if ("".equals(this.serviceID)) {
            this.serviceID = null;
        }
        if (this.serviceID != null) {
            this.builder.service(this.serviceID);
        }
        if (this.applicationIDs != null && this.applicationIDs.isEmpty()) {
            this.applicationIDs = null;
        }
        for (JobStatus st : this.status) {
            this.builder.status(st);
        }
        List list = null;
        if (this.serviceID == null) {
            if (this.applicationIDs != null) {
                Logger.getDEFAULT().printlnWarning("Argument \"application\" ignored as  serviceinstance,  is not specified.");
            }
            title = title + ", all service instances, all applications";
        } else {
            title = title + ", service instance=" + this.serviceID;
            includeInstance = false;
            if (this.applicationIDs != null) {
                if (this.applicationIDs.size() == 1) {
                    title = title + ", application=" + this.applicationIDs.get(0);
                    includeApplication = false;
                }
                for (String app : this.applicationIDs) {
                    this.builder.application(app);
                }
            } else {
                title = title + ", all applications";
            }
        }
        if (this.status.size() == 1) {
            title = title + ", status=" + this.status.get(0).toString();
            includestatus = false;
        }
        JobQuery query = this.builder.build();
        Logger.getDEFAULT().printlnDebug("JobQuery:" + query.getFilter());
        list = client.listJobs(query);
        boolean allfailed = true;
        for (Job j : list) {
            if (j.getStatus() == JobStatus.FAILED) continue;
            allfailed = false;
            break;
        }
        if (this.sortField != null) {
            Collections.sort(list, new JobComparator(this.sortField, this.descending));
        }
        BeanUtils.printJobs(includeInstance, includeApplication, includestatus, title, list, this.isLocal() && !this.isOnUi(), this.grid, this.gridWidth, this.full, new Date(), (JobManager)(allfailed ? client : null));
    }
}

