/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.client.cli.bean.JobLogComparator;
import oracle.cloud.paas.client.cli.command.ApplicationBaseExecutor;
import oracle.cloud.paas.exception.ManagerException;
import oracle.cloud.paas.model.Log;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;

public class ListJobLogs
extends ApplicationBaseExecutor {
    String jobId;
    protected boolean grid = false;
    protected int gridWidth = 180;
    protected boolean full = false;
    JobLogComparator.FIELD sortField = null;
    protected boolean descending = false;
    protected String sorton = null;
    protected boolean autodownloadlogs = false;
    List<Log> list = null;

    @Override
    public void validate() throws CliException {
        block8: {
            try {
                String gw;
                super.validate();
                this.jobId = this.command.getArgValue("jobid");
                this.grid = this.command.getValueAsBoolean("grid");
                this.descending = this.command.getValueAsBoolean("descending");
                this.sorton = this.command.getArgValue("sorton");
                this.full = this.command.getValueAsBoolean("verbose");
                this.autodownloadlogs = this.command.getValueAsBoolean("viewlogs");
                if (this.sorton != null && !this.sorton.trim().equals("")) {
                    try {
                        this.sortField = JobLogComparator.FIELD.valueOf(this.sorton.toUpperCase());
                    }
                    catch (Exception e) {
                        throw new Exception(NLSUtil.localizeMessage("NLS_OPTION_VALUE_INVALID_FOR_POSSIBLE_VALUES", new Object[]{"sorton", this.sorton, CloudUtil.getCommaSeparatedListOfString(CloudUtil.getEnumValuesAsList(JobLogComparator.FIELD.class))}));
                    }
                }
                if ((gw = this.command.getArgValue("gridwidth")) == null) break block8;
                try {
                    this.gridWidth = Integer.parseInt(gw);
                    if (this.gridWidth < 0) {
                        throw new NumberFormatException("gridwidth must be a positive integer");
                    }
                }
                catch (NumberFormatException e) {
                    throw new CliException("Please enter valid value for gridwidth", e);
                }
            }
            catch (Exception e) {
                throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
            }
        }
    }

    @Override
    public void invoke(ApplicationManager client) throws Exception {
        if (this.isLocal() && !this.isOnUi()) {
            throw new ManagerException("Un-supported operation from CLI against local domain");
        }
        this.list = client.listJobLogs(this.jobId);
        if (this.sortField != null) {
            Collections.sort(this.list, new JobLogComparator(this.sortField, this.descending));
        }
        BeanUtils.printLogs(this.list, this.grid, this.gridWidth, true, 0, "job(id=" + this.jobId + ")", this.full, new Date(), client, this.jobId, this.autodownloadlogs);
    }

    public List<Log> getList() {
        return this.list;
    }
}

