/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.util.Collections;
import java.util.List;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.client.cli.bean.ApplicationComparator;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.client.cli.command.ServiceBaseGridVerboseExecutor;
import oracle.cloud.paas.model.Application;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;

public class ListApplications
extends ServiceBaseGridVerboseExecutor {
    ApplicationComparator.FIELD sortField = null;
    List<Application> list = null;

    @Override
    public void validate() throws CliException {
        block4: {
            super.validate();
            try {
                if (this.sorton == null || this.sorton.trim().equals("")) break block4;
                try {
                    this.sortField = ApplicationComparator.FIELD.valueOf(this.sorton.toUpperCase());
                }
                catch (Exception e) {
                    throw new Exception(NLSUtil.localizeMessage("NLS_OPTION_VALUE_INVALID_FOR_POSSIBLE_VALUES", new Object[]{"sorton", this.sorton, CloudUtil.getCommaSeparatedListOfString(CloudUtil.getEnumValuesAsList(ApplicationComparator.FIELD.class))}));
                }
            }
            catch (Exception e) {
                throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
            }
        }
    }

    @Override
    public void invoke(ApplicationManager client) throws Exception {
        this.list = client.listApplications(this.tenantID, this.serviceID);
        if (this.sortField != null) {
            Collections.sort(this.list, new ApplicationComparator(this.sortField, this.descending));
        }
        BeanUtils.printApplications("identity domain=" + this.tenantID + " , service instance=" + this.serviceID, this.list, this.grid, this.gridWidth, this.full, true, 0);
    }

    public List<Application> getList() {
        return this.list;
    }
}

