/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.cloud.paas.api.LibraryManager;
import oracle.cloud.paas.api.LibraryManagerConnectionFactory;
import oracle.cloud.paas.client.cli.command.BaseExecutor;
import oracle.cloud.paas.exception.ResourceBusyException;
import oracle.cloud.paas.model.Job;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.executor.ManagableExecutor;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public abstract class LibraryBaseExecutor
extends BaseExecutor {
    LibraryManager libraryManager = null;
    protected Job job = null;
    private boolean onUi = false;
    public static final Map<String, LibraryManager> LIB_MANAGER_CACHE_FOR_LOCAL = new HashMap<String, LibraryManager>(1);
    protected String serviceID = null;
    protected boolean grid = false;
    protected int gridWidth = 180;
    protected boolean descending = false;
    protected String sorton = null;
    protected boolean full = false;
    protected Job activeJob;

    @Override
    public void validate() throws CliException {
        super.validate();
        try {
            String gw;
            this.serviceID = this.command.getArgValue("serviceinstance");
            this.grid = this.command.getValueAsBoolean("grid");
            this.descending = this.command.getValueAsBoolean("descending");
            this.sorton = this.command.getArgValue("sorton");
            if ((this.sorton == null || this.sorton.trim().equals("")) && this.descending) {
                Logger.getDEFAULT().printlnWarning("descending is not applicable when sorton is not specified.");
            }
            if ((gw = this.command.getArgValue("gridwidth")) != null) {
                try {
                    this.gridWidth = Integer.parseInt(gw);
                    if (this.gridWidth < 0) {
                        throw new NumberFormatException("gridwidth must be a positive integer");
                    }
                }
                catch (NumberFormatException e) {
                    throw new CliException("Please enter valid value for gridwidth", e);
                }
            }
            this.full = this.command.getValueAsBoolean("verbose");
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    @Override
    public void invoke() throws Exception {
        this.libraryManager = LibraryManagerConnectionFactory.createServiceEndpoint((String)"cloud", (URL)new URL(this.adminUrl), (String)this.tenantID, (String)this.userName, (String)this.pwd);
        if (this.libraryManager == null) {
            throw new Exception("System Error:Could not get Library Manager");
        }
        if (ManagableExecutor.class.isAssignableFrom(this.libraryManager.getClass()) && !this.onUi) {
            ((ManagableExecutor)this.libraryManager).prepareToBeManaged();
        }
        this.invoke(this.libraryManager);
    }

    public Job getActiveJob() {
        return this.activeJob;
    }

    public void invoke(LibraryManager client) throws Exception {
        try {
            this.createJob(client);
        }
        catch (ResourceBusyException rbe) {
            this.activeJob = rbe.getActiveJob();
            throw rbe;
        }
    }

    public void createJob(LibraryManager client) throws Exception {
    }

    public void setOnUi() {
        this.onUi = true;
    }

    @Override
    public boolean isOnUi() {
        return this.onUi;
    }

    public LibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public static enum GROUPBY {
        SERVER,
        COMPONENT,
        SERVER_COMPONENT;


        public String toString() {
            if (this == SERVER) {
                return "Server";
            }
            if (this == COMPONENT) {
                return "Component";
            }
            return "ServerAndComponent";
        }
    }
}

