/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import oracle.cloud.paas.api.LibraryManager;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.client.cli.command.UploadLibrary;
import oracle.cloud.paas.model.LibraryType;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class InstallLibrary
extends UploadLibrary {
    private LibraryType libType = null;

    @Override
    public void validate() throws CliException {
        try {
            super.validate();
            String ext = this.command.getArgValue("librarytype");
            if (ext == null || ext.trim().equals("")) {
                ext = this.getExtension();
            }
            try {
                ext = ext.toUpperCase();
                this.libType = LibraryType.valueOf((String)ext);
                this.library.setType(LibraryType.valueOf((String)ext));
            }
            catch (Exception e) {
                throw new CliException(NLSUtil.localizeMessage("NLS_ERR_SPECIFY_LIB_TYPE", new Object[]{ext, "librarytype", CloudUtil.getCommaSeparatedListOfString(CloudUtil.getEnumValuesAsList(LibraryType.class))}));
            }
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createJob(LibraryManager client) throws Exception {
        FileInputStream in = null;
        if (this.file != null) {
            in = new FileInputStream(this.file);
        }
        try {
            this.job = client.deployLibrary(this.library, (InputStream)in);
            if (this.job == null) {
                throw new Exception("Un-expected system error. Could not get a job id for the deployment");
            }
            this.createdJob = this.job;
            Logger.getDEFAULT().printlnInfoI18n("NLS_INFO_LIBRARY_INSTALL_STARTED");
            BeanUtils.print(this.job, 1, false, false, new Date(), null);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

