/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.client.cli.command.UploadApplication;
import oracle.cloud.paas.model.ApplicationState;
import oracle.cloud.paas.model.ApplicationType;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class InstallApplication
extends UploadApplication {
    private ApplicationType appType = null;

    @Override
    public void validate() throws CliException {
        try {
            super.validate();
            String ext = this.command.getArgValue("applicationtype");
            if (ext == null || ext.trim().equals("")) {
                ext = this.getExtension();
            }
            try {
                ext = ext.toUpperCase();
                this.appType = ApplicationType.valueOf((String)ext);
            }
            catch (Exception e) {
                throw new CliException(NLSUtil.localizeMessage("NLS_ERR_SPECIFY_APP_TYPE", new Object[]{ext, "applicationtype", CloudUtil.getCommaSeparatedListOfString(CloudUtil.getEnumValuesAsList(ApplicationType.class))}));
            }
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createJob(ApplicationManager client) throws Exception {
        FileInputStream in = new FileInputStream(this.file);
        Logger.getDEFAULT().printlnDebug("Application name:" + this.applicationName);
        try {
            this.createdJob = this.adminstate ? client.deployApplication(this.tenantID, this.serviceID, this.applicationName, this.appType, (InputStream)in, ApplicationState.STATE_ADMIN) : client.deployApplication(this.tenantID, this.serviceID, this.applicationName, this.appType, (InputStream)in);
            if (this.createdJob == null) {
                throw new Exception("Un-expected system error. Could not get a job id for the deployment");
            }
            if (this.isLocal() && !this.isOnUi()) {
                Logger.getDEFAULT().printlnInfo("The application installation operation is successfully completed.");
            } else {
                Logger.getDEFAULT().printlnInfoI18n("NLS_INFO_INSTALL_STARTED");
                BeanUtils.print(this.createdJob, 1, false, false, new Date(), null);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

