/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.client.cli.command.ApplicationBaseExecutor;
import oracle.cloud.paas.exception.ManagerException;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class FetchJobLog
extends ApplicationBaseExecutor {
    String jobId;
    String logName;
    String filePath = null;

    @Override
    public void validate() throws CliException {
        super.validate();
        try {
            this.jobId = this.command.getArgValue("jobid");
            this.logName = this.command.getArgValue("log");
            this.filePath = this.command.getArgValue("output", new File("./", this.logName + ".log").getAbsolutePath());
            if (new File(this.filePath).isDirectory()) {
                this.filePath = new File(this.filePath, this.logName + ".log").getAbsolutePath();
            }
            CloudUtil.validateOutputFile(this.filePath, true);
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(ApplicationManager client) throws Exception {
        if (this.isLocal() && !this.isOnUi()) {
            throw new ManagerException("Un-supported operation from CLI against local Weblogic domain");
        }
        FileOutputStream fos = null;
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            client.fetchJobLog(this.jobId, this.logName, (OutputStream)bo);
            Logger.getDEFAULT().printlnInfoI18n("NLS_INFO_WRITING_FILE_AT", new File(this.filePath).getAbsolutePath());
            fos = new FileOutputStream(this.filePath);
            fos.write(bo.toByteArray());
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }
}

