/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.api.ServiceInstanceLogCriteria;
import oracle.cloud.paas.api.ServiceInstanceLogCriteriaFactory;
import oracle.cloud.paas.client.cli.bean.ApplicationLogRecord;
import oracle.cloud.paas.client.cli.bean.ApplicationLogRecords;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.client.cli.bean.LogRecordComparator;
import oracle.cloud.paas.client.cli.command.ServiceBaseGridVerboseExecutor;
import oracle.cloud.paas.client.clix.CliExtensionUtils;
import oracle.cloud.paas.exception.ManagerException;
import oracle.cloudlogic.javaservice.common.clibase.display.Grid;
import oracle.cloudlogic.javaservice.common.clibase.display.Row;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.TimeUtils;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class FetchApplicationLogRecordsExecutor
extends ServiceBaseGridVerboseExecutor {
    public static final int RECORDS_CHUNK_SIZE = 100;
    public static final String DEF_LOG_FIILE_NAME_PATTERN = "log_identitydomain_serviceinstance.log";
    List<String> applicationIDs = null;
    List<String> contains = null;
    LogRecordComparator.FIELD sortField = null;
    List<ApplicationLogRecord.SEVERITY> severities = new ArrayList<ApplicationLogRecord.SEVERITY>();
    boolean follow = false;
    boolean xml = false;
    LAST last = null;
    int lastSize = 1;
    String format = null;
    Date starttime = null;
    Date endtime = null;
    int limit = -1;
    int followmillis = 1000;
    Logger logger = null;
    ServiceInstanceLogCriteria criteria = null;
    boolean finalCaptionReqired = false;

    @Override
    public void validate() throws CliException {
        super.validate();
        try {
            String sevlist;
            String applicationIDList;
            String la;
            String size;
            String etime;
            String lim = this.command.getArgValue("limit");
            if (lim != null && !lim.trim().equals("")) {
                try {
                    this.limit = Integer.parseInt(lim);
                }
                catch (NumberFormatException e) {
                    throw new CliException("Please enter valid value for limit", e);
                }
            }
            this.followmillis = this.command.getAsPositiveInteger("followmillis");
            this.xml = this.command.getValueAsBoolean("xml");
            this.criteria = ServiceInstanceLogCriteriaFactory.createCriteria();
            String out = this.command.getArgValue("output");
            if (out == null || out.trim().equals("")) {
                this.logger = Logger.getDEFAULT();
            } else {
                if (new File(out).isDirectory()) {
                    out = new File(out, "log_" + this.tenantID + "_" + this.serviceID + ".log").getAbsolutePath();
                }
                if (new File(out).isDirectory()) {
                    throw new Exception(out + " is a directory.");
                }
                if (!new File(out).exists()) {
                    out = CloudUtil.validateOutputFile(out, true).getAbsolutePath();
                }
                Logger.getDEFAULT().printlnInfoI18n("NLS_INFO_WRITING_FILE_AT", out);
                FileWriter fstream = new FileWriter(out, true);
                this.logger = new Logger(new PrintWriter((Writer)fstream, true), true);
            }
            this.follow = this.command.getValueAsBoolean("follow");
            this.format = this.command.getArgValue("datetimeformat", "MM/dd");
            String stime = this.command.getArgValue("starttime");
            if (stime != null) {
                this.starttime = CliExtensionUtils.parseDateWithOptionalField(this.format, stime);
            }
            if ((etime = this.command.getArgValue("endtime")) != null) {
                this.endtime = CliExtensionUtils.parseDateWithOptionalField(this.format, etime);
            }
            if (this.endtime != null && this.follow) {
                Logger.getDEFAULT().printlnWarning("follow is turned off since endtime is specified.");
                this.follow = false;
            }
            if (this.starttime != null && this.endtime == null) {
                this.endtime = new Date();
            }
            if ((size = this.command.getArgValue("unit")) != null && !size.trim().equals("")) {
                try {
                    this.lastSize = Integer.parseInt(size);
                    if (this.lastSize <= 0) {
                        throw new NumberFormatException("unit must be a positive integer");
                    }
                }
                catch (NumberFormatException e) {
                    throw new CliException("Please enter valid value for unit", e);
                }
            }
            if ((la = this.command.getArgValue("last")) != null && !la.trim().equals("")) {
                try {
                    this.last = LAST.valueOf(la.toUpperCase());
                }
                catch (Exception e) {
                    throw new Exception(NLSUtil.localizeMessage("NLS_OPTION_VALUE_INVALID_FOR_POSSIBLE_VALUES", new Object[]{"last", la, CloudUtil.getCommaSeparatedListOfString(CloudUtil.getEnumValuesAsList(LAST.class))}));
                }
            }
            if ((applicationIDList = this.command.getArgValue("application")) != null) {
                this.applicationIDs = CloudUtil.parseString(applicationIDList, ",");
            }
            String containsListList = this.command.getArgValue("contains");
            String containsSeperator = this.command.getArgValue("containsseperator", ",");
            if (containsListList != null) {
                this.contains = CloudUtil.parseString(containsListList, containsSeperator);
            }
            if ((sevlist = this.command.getArgValue("severity")) != null && !sevlist.trim().equals("")) {
                List<String> sevs = null;
                sevs = CloudUtil.parseString(sevlist, ",");
                if (sevs != null) {
                    for (String s : sevs) {
                        if (s == null || s.trim().equals("")) continue;
                        try {
                            ApplicationLogRecord.SEVERITY sv = ApplicationLogRecord.SEVERITY.valueOf(s.toUpperCase());
                            if (this.severities.contains((Object)sv)) continue;
                            this.severities.add(sv);
                        }
                        catch (Exception e) {
                            throw new Exception(NLSUtil.localizeMessage("NLS_OPTION_VALUE_INVALID_FOR_POSSIBLE_VALUES", new Object[]{"severity", s, CloudUtil.getCommaSeparatedListOfString(CloudUtil.getEnumValuesAsList(ApplicationLogRecord.SEVERITY.class))}));
                        }
                    }
                }
            }
            if (this.sorton != null && !this.sorton.trim().equals("")) {
                if (this.follow) {
                    Logger.getDEFAULT().printlnWarning("sorton is not applicable when follow is enabled");
                } else if (!this.grid) {
                    Logger.getDEFAULT().printlnWarning("sorton is not applicable when grid is not enabled");
                } else {
                    try {
                        this.sortField = LogRecordComparator.FIELD.valueOf(this.sorton.toUpperCase());
                    }
                    catch (Exception e) {
                        throw new Exception(NLSUtil.localizeMessage("NLS_OPTION_VALUE_INVALID_FOR_POSSIBLE_VALUES", new Object[]{"sorton", this.sorton, CloudUtil.getCommaSeparatedListOfString(CloudUtil.getEnumValuesAsList(LogRecordComparator.FIELD.class))}));
                    }
                }
            }
            if (this.follow && this.xml) {
                Logger.getDEFAULT().printlnWarning("xml formatting is not applicable when follow is enabled");
                this.xml = false;
            }
            if (!this.xml) {
                this.logger.println("\n-----------[Fetching at " + new Date().toString() + "]-----------");
            } else {
                Logger.getDEFAULT().println("\n-----------[Fetching at " + new Date().toString() + "]-----------");
            }
            this.finalCaptionReqired = true;
            if (this.full && !this.grid) {
                Logger.getDEFAULT().printlnWarning("verbose is not applicable when grid is not enabled");
                this.full = false;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (FetchApplicationLogRecordsExecutor.this.finalCaptionReqired) {
                        if (!FetchApplicationLogRecordsExecutor.this.xml) {
                            FetchApplicationLogRecordsExecutor.this.logger.println("-----------[Fetched at " + new Date().toString() + "]-----------");
                        } else {
                            Logger.getDEFAULT().println("-----------[Fetched at " + new Date().toString() + "]-----------");
                        }
                    }
                    FetchApplicationLogRecordsExecutor.this.logger.flush();
                    FetchApplicationLogRecordsExecutor.this.logger.commit();
                    FetchApplicationLogRecordsExecutor.this.logger.close();
                }
            });
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    @Override
    public void invoke(ApplicationManager client) throws Exception {
        if (this.isLocal() && !this.isOnUi()) {
            throw new ManagerException("Un-supported operation from CLI against local domain");
        }
        if (this.limit > 0) {
            this.criteria.limit(this.limit);
        }
        if (this.applicationIDs != null) {
            if (this.applicationIDs.isEmpty()) {
                this.criteria.systemLogs(true);
                Logger.getDEFAULT().printlnDebug("Requesting only for system logs.");
            } else {
                this.criteria.systemLogs(false);
                for (String a : this.applicationIDs) {
                    this.criteria.application(a);
                    Logger.getDEFAULT().printlnDebug("application added :" + a);
                }
            }
        }
        if (this.severities != null) {
            for (ApplicationLogRecord.SEVERITY s : this.severities) {
                this.criteria.severity(s.toString());
                Logger.getDEFAULT().printlnDebug("severity added :" + s.toString());
            }
        }
        if (this.contains != null) {
            for (String c : this.contains) {
                this.criteria.contains(c);
                Logger.getDEFAULT().printlnDebug("contains added :" + c.toString());
            }
        }
        if (this.starttime == null) {
            if (this.last == null) {
                this.last = LAST.DAY;
            }
            Calendar c = Calendar.getInstance();
            this.endtime = new Date();
            c.setTime(this.endtime);
            switch (this.last) {
                case RECORDS: {
                    this.criteria.last(this.lastSize * 100);
                    Logger.getDEFAULT().printlnDebug("searching in last  :" + this.lastSize * 100 + " records");
                    break;
                }
                case MINUTE: {
                    c.add(12, -this.lastSize);
                    this.starttime = c.getTime();
                    break;
                }
                case HOUR: {
                    c.add(10, -this.lastSize);
                    this.starttime = c.getTime();
                    break;
                }
                case DAY: {
                    c.add(5, -this.lastSize);
                    this.starttime = c.getTime();
                    break;
                }
                case MONTH: {
                    c.add(2, -this.lastSize);
                    this.starttime = c.getTime();
                    break;
                }
                case YEAR: {
                    c.add(1, -this.lastSize);
                    this.starttime = c.getTime();
                }
            }
        }
        if (this.starttime != null) {
            this.criteria.after(this.starttime);
            this.criteria.before(this.endtime);
            Logger.getDEFAULT().printlnDebug("setting start time:" + this.starttime.toString() + " endtime:" + this.endtime.toString());
        }
        if (this.xml || this.grid) {
            this.criteria.returnXML();
        }
        int ROW = 0;
        JAXBContext jaxbContext = null;
        Grid table = null;
        ApplicationLogRecords lastRecords = null;
        InputStream in = client.queryServiceInstanceLogs(this.tenantID, this.serviceID, this.criteria);
        if (!this.grid) {
            this.printAll(in);
        } else {
            table = new Grid();
            table.addColumn("S.No");
            table.addColumn("Date&Timestamp");
            if (this.full) {
                table.addColumn("Local Time");
                table.addColumn("How long Ago");
            }
            table.addColumn("Severity:Level");
            table.addColumn("Message and Trace");
            table.getColumns().get("Message and Trace").setWidth(this.gridWidth);
            if (jaxbContext == null) {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ApplicationLogRecords.class});
            }
            ApplicationLogRecords records = (ApplicationLogRecords)jaxbContext.createUnmarshaller().unmarshal(in);
            List<ApplicationLogRecord> list = records.getMsg();
            if (!this.follow && this.sortField != null) {
                Collections.sort(list, new LogRecordComparator(this.sortField, this.descending));
            }
            for (ApplicationLogRecord r : list) {
                int col = 0;
                Row row = table.createNewRow();
                row.setValueAt(String.valueOf(++ROW), col++);
                row.setValueAt(r.getTime(), col++);
                if (this.full) {
                    row.setObjectAt(r.getDateTime(), col++);
                    row.setValueAt(TimeUtils.millisToLongDHMS(new Date().getTime() - r.getDateTime().getTime()), col++);
                }
                row.setValueAt(r.getType() + ":" + r.getLevel(), col++);
                row.setValueAt(r.getText() + (r.getSuppl_detail() == null ? "" : "\n" + r.getSuppl_detail()), col++);
            }
            if (!list.isEmpty()) {
                BeanUtils.printGridRecursive(this.logger, table, (list.size() == 1 ? "log record" : "log records") + (this.follow ? " and following" : ""), this.gridWidth, true);
            }
            lastRecords = records;
        }
        if (lastRecords == null) {
            lastRecords = new ApplicationLogRecords();
        }
        if (this.follow) {
            if (jaxbContext == null) {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ApplicationLogRecords.class});
            }
            this.criteria.returnXML();
            if (lastRecords.getMsg().isEmpty()) {
                this.criteria.after(new Date());
            } else {
                ApplicationLogRecord lastrecord = lastRecords.getMsg().get(lastRecords.getMsg().size() - 1);
                this.criteria.after(lastrecord.getDateTime());
            }
            this.criteria.limit(-1);
            while (true) {
                Thread.currentThread();
                Thread.sleep(this.followmillis);
                this.criteria.before(new Date());
                in = client.queryServiceInstanceLogs(this.tenantID, this.serviceID, this.criteria);
                ApplicationLogRecords currentRecords = (ApplicationLogRecords)jaxbContext.createUnmarshaller().unmarshal(in);
                in.close();
                if (currentRecords.getMsg().isEmpty()) continue;
                ApplicationLogRecord lastrecord = currentRecords.getMsg().get(currentRecords.getMsg().size() - 1);
                this.criteria.after(lastrecord.getDateTime());
                ROW = currentRecords.writeDeltaTo(lastRecords, this.logger, table, ROW, this.gridWidth, this.full);
                lastRecords = currentRecords;
            }
        }
        this.finalCaptionReqired = false;
        if (!this.xml) {
            this.logger.println("-----------[Fetched at " + new Date().toString() + "]-----------");
        } else {
            Logger.getDEFAULT().println("-----------[Fetched at " + new Date().toString() + "]-----------");
        }
    }

    private void printAll(InputStream in) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String line = br.readLine();
        while (line != null) {
            this.logger.println(line);
            line = br.readLine();
        }
        in.close();
        this.logger.flush();
    }

    public static enum LAST {
        MINUTE,
        HOUR,
        DAY,
        MONTH,
        YEAR,
        RECORDS;

    }
}

