/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.client.cli.command.ServiceBaseGridExecutor;
import oracle.cloud.paas.model.Association;
import oracle.cloud.paas.model.ServiceInstance;
import oracle.cloud.paas.model.ServiceType;

public class DescribeServiceInstance
extends ServiceBaseGridExecutor {
    private ServiceInstance service = null;

    @Override
    public void invoke(ApplicationManager client) throws Exception {
        this.service = client.describeServiceInstance(this.tenantID, this.serviceID);
        if (this.service == null) {
            throw new Exception("Could not find a service instance with sepcified details.");
        }
        if (!this.grid) {
            BeanUtils.print(this.tenantID, this.service, 1, true, 0);
        } else {
            BeanUtils.printServiceInstances(this.tenantID, Arrays.asList(this.service), this.grid, this.gridWidth, true, false, 0);
        }
    }

    public ServiceInstance getServiceInstance() {
        return this.service;
    }

    public List<Association> getDBAssociations() {
        ArrayList<Association> list = new ArrayList<Association>();
        if (this.service != null) {
            for (Association as : this.service.getAssociations()) {
                if (as.getTargetServiceType() != ServiceType.DATABASE) continue;
                list.add(as);
            }
        }
        return list;
    }
}

