/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.util.Arrays;
import oracle.cloud.paas.api.LibraryManager;
import oracle.cloud.paas.client.cli.bean.LibraryPrintUtils;
import oracle.cloud.paas.client.cli.command.LibraryBaseExecutor;
import oracle.cloud.paas.model.Library;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;

public class DescribeLibrary
extends LibraryBaseExecutor {
    String libraryID = null;
    String specVersion = null;
    String implVersion = null;
    private Library library = null;

    @Override
    public void validate() throws CliException {
        super.validate();
        try {
            this.libraryID = this.command.getArgValue("library");
            this.specVersion = this.command.getArgValue("specversion");
            this.implVersion = this.command.getArgValue("implversion");
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    @Override
    public void invoke(LibraryManager client) throws Exception {
        this.library = client.describeLibrary(this.tenantID, this.serviceID, this.libraryID, this.specVersion, this.implVersion);
        if (this.library == null) {
            throw new Exception("Could not find a library with specified details.");
        }
        LibraryPrintUtils.printReferenceApps(client, "identity domain= " + this.tenantID + " , service instance= " + this.serviceID, Arrays.asList(this.library), this.grid, this.gridWidth, true, false, 0);
    }

    public Library getLibrary() {
        return this.library;
    }
}

