/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.util.Arrays;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.client.cli.command.ServiceBaseGridExecutor;
import oracle.cloud.paas.model.Application;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;

public class DescribeApplication
extends ServiceBaseGridExecutor {
    String applicationID = null;
    private Application application = null;

    @Override
    public void validate() throws CliException {
        super.validate();
        try {
            this.applicationID = this.command.getArgValue("application");
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    @Override
    public void invoke(ApplicationManager client) throws Exception {
        this.application = client.describeApplication(this.tenantID, this.serviceID, this.applicationID);
        if (this.application == null) {
            throw new Exception("Could not find an application with sepcified details.");
        }
        if (!this.grid) {
            BeanUtils.print(this.application, 1, true, 0);
        } else {
            BeanUtils.printApplications("identity domain=" + this.tenantID + " , service instance=" + this.serviceID, Arrays.asList(this.application), this.grid, this.gridWidth, true, false, 0);
        }
    }

    public Application getApplication() {
        return this.application;
    }
}

