/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.util.Date;
import javax.net.ssl.SSLException;
import oracle.cloud.paas.client.ClientConstants;
import oracle.cloud.paas.client.cli.Main;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.exception.AuthenticationException;
import oracle.cloud.paas.exception.DuplicateResourceException;
import oracle.cloud.paas.exception.InvalidDescriptorException;
import oracle.cloud.paas.exception.ManagerException;
import oracle.cloud.paas.exception.ResourceBusyException;
import oracle.cloud.paas.exception.UnknownResourceException;
import oracle.cloud.paas.model.Job;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.CommandLineArg;
import oracle.cloudlogic.javaservice.common.clibase.display.Grid;
import oracle.cloudlogic.javaservice.common.clibase.display.Row;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliExitCodeException;
import oracle.cloudlogic.javaservice.common.clibase.executor.CliExecutor;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.common.clibase.util.SSLUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public abstract class BaseExecutor
implements CliExecutor,
ClientConstants {
    protected CommandLine command;
    protected String adminUrl = null;
    String datacenter = null;
    protected String userName = null;
    protected String tenantID = null;
    private String sysProperties = null;
    protected String pwd = null;
    boolean local = false;
    protected String additionalClassPath = null;
    private String proxySpec = null;
    private boolean useProxy = false;
    public static final String CLOUD_PROVIDER_NAME = "cloud";
    public static final String LOCAL_CLOUD_PROVIDER_NAME = "localCloud";
    public static final int EXIT_CODE_USER_ACTIVE_JOB = 3;

    public String getUserName() {
        return this.userName;
    }

    public String getTenantID() {
        return this.tenantID;
    }

    public abstract void invoke() throws Exception;

    public abstract boolean isOnUi();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAuthenticationException() {
        Logger.getDEFAULT().printlnTipI18n("NLS_TIP_CHECK_SERVICE_GROUP", new Object[]{this.datacenter == null ? "adminurl" : "datacenter", "identitydomain", "adminurl"});
        Logger logger = Logger.getDEFAULT();
        synchronized (logger) {
            Logger.getDEFAULT().setCaption("Data Center");
            DATACENTER.getDescriptionGrid().printTo(Logger.getDEFAULT(), "Available Data Centers");
            Logger.getDEFAULT().reSetCaption();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        if (this.command.toEnableDebug()) {
            Logger.getDEFAULT().addAllowed(Logger.LOG_MESSAGE_TYPES.DEBUG);
        }
        ClassLoader old = null;
        try {
            if (this.additionalClassPath != null && this.local) {
                Logger.getDEFAULT().printlnDebug("Setting up new classpath with : " + this.additionalClassPath);
                old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(CloudUtil.createURLClassLoader(this.additionalClassPath));
            }
            this.invoke();
        }
        catch (Exception e) {
            if (CloudUtil.isCausedBy(e, SSLException.class)) {
                throw new RuntimeException(NLSUtil.localizeMessage("NLS_EXCEPTION_SSL", new Object[]{"trustservercert"}), e);
            }
            ManagerException me = CloudUtil.getCause(e, ManagerException.class);
            if (me == null) {
                throw e;
            }
            if (AuthenticationException.class.isAssignableFrom(me.getClass())) {
                AuthenticationException auth = (AuthenticationException)me;
                this.handleAuthenticationException();
                throw auth;
            }
            if (DuplicateResourceException.class.isAssignableFrom(me.getClass())) {
                DuplicateResourceException dup = (DuplicateResourceException)me;
                throw dup;
            }
            if (InvalidDescriptorException.class.isAssignableFrom(me.getClass())) {
                InvalidDescriptorException invalid = (InvalidDescriptorException)me;
                throw invalid;
            }
            if (ResourceBusyException.class.isAssignableFrom(me.getClass())) {
                ResourceBusyException rb = (ResourceBusyException)me;
                Job j = rb.getActiveJob();
                if (j != null) {
                    Logger logger = Logger.getDEFAULT();
                    synchronized (logger) {
                        Logger.getDEFAULT().setCaption("active-job");
                        Logger.getDEFAULT().tab();
                        Logger.getDEFAULT().printlnWarningI18n("NLS_INFO_RESOURCE_BUSY");
                        BeanUtils.print(j, 1, false, this.isLocal() && !this.isOnUi(), new Date(), null);
                        Logger.getDEFAULT().shiftTab();
                        Logger.getDEFAULT().reSetCaption();
                    }
                } else {
                    throw rb;
                }
                throw new CliExitCodeException(3, NLSUtil.localizeMessage("NLS_INFO_RESOURCE_BUSY"), (Exception)((Object)rb));
            }
            if (UnknownResourceException.class.isAssignableFrom(me.getClass())) {
                UnknownResourceException uk = (UnknownResourceException)me;
                throw uk;
            }
            throw e;
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
            Logger.getDEFAULT().flush();
        }
    }

    @Override
    public void setCommandLine(CommandLine command) {
        this.command = command;
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public void setProxyUser(String u, String p, boolean https) {
        if (https) {
            System.setProperty("https.proxyUser", u);
            System.setProperty("https.proxyPassword", p);
        } else {
            System.setProperty("http.proxyUser", u);
            System.setProperty("http.proxyPassword", p);
        }
    }

    public void setProxyHost(String host, String port, boolean https) {
        if (https) {
            System.setProperty("https.proxyHost", host);
            System.setProperty("https.proxyPort", port);
        } else {
            System.setProperty("http.proxyHost", host);
            System.setProperty("http.proxyPort", port);
        }
    }

    public String getProxyDetails(boolean https) {
        String ret = null;
        String u = null;
        String p = null;
        if (https) {
            ret = System.getProperty("https.proxyHost") + ":" + System.getProperty("https.proxyPort");
            u = System.getProperty("https.proxyUser");
            p = System.getProperty("https.proxyPassword");
        } else {
            ret = System.getProperty("http.proxyHost") + ":" + System.getProperty("http.proxyPort");
            u = System.getProperty("http.proxyUser");
            p = System.getProperty("http.proxyPassword");
        }
        return ret + (u == null ? "" : "@" + u + (p == null ? "" : "/***"));
    }

    public void clearProxyConfiguration(boolean https) {
        if (https) {
            System.clearProperty("https.proxyHost");
            System.clearProperty("https.proxyPort");
            System.clearProperty("https.proxyUser");
            System.clearProperty("https.proxyPassword");
        } else {
            System.clearProperty("http.proxyHost");
            System.clearProperty("http.proxyPort");
            System.clearProperty("http.proxyUser");
            System.clearProperty("http.proxyPassword");
        }
    }

    @Override
    public void validate() throws CliException {
        try {
            this.command.verifyArgs();
            this.proxySpec = this.command.getArgValue("httpproxy");
            this.tenantID = this.command.getArgValue("identitydomain");
            this.sysProperties = this.command.getArgValue("systemproperties");
            if (this.sysProperties != null) {
                OrderedMap<String, String> commandlineProperties = CloudUtil.parseCommandlineProperties(this.sysProperties, null);
                for (NameValuePair<String, String> pair : commandlineProperties.getList()) {
                    if (pair.getName() == null || "".equals(pair.getName().trim())) continue;
                    Logger.getDEFAULT().printlnDebug("Setting sys property:" + pair.getName() + "=" + pair.getValue());
                    System.setProperty(pair.getName(), pair.getValue());
                }
            }
            this.adminUrl = this.command.getArgValue("adminurl");
            if (this.adminUrl == null || this.adminUrl.trim().equals("")) {
                DATACENTER dc = this.command.getEnumValue("datacenter", DATACENTER.class, true);
                this.datacenter = dc.toString().toLowerCase();
                this.adminUrl = "https://javaservices.<datacenter>.cloud.oracle.com".replaceAll("<.*>", this.datacenter);
            }
            boolean https = this.adminUrl.toLowerCase().startsWith("https:");
            this.local = this.command.getValueAsBoolean("local");
            if (!this.local) {
                boolean bl = this.useProxy = !this.command.getValueAsBoolean("nohttpproxy");
                if (this.useProxy) {
                    if (this.proxySpec != null && !this.proxySpec.trim().equals("")) {
                        String hostport;
                        int at = this.proxySpec.indexOf("@");
                        String host = null;
                        String port = null;
                        String userpwd = null;
                        String p = null;
                        if (at >= 0) {
                            hostport = this.proxySpec.substring(0, at);
                            userpwd = this.proxySpec.substring(at + 1, this.proxySpec.length());
                        } else {
                            hostport = this.proxySpec;
                        }
                        if (hostport == null || hostport.trim().equals("")) {
                            throw new Exception("Host, Port not found. Invalid value for httpproxy");
                        }
                        int colon = hostport.indexOf(":");
                        if (colon >= 0) {
                            host = hostport.substring(0, colon);
                            port = hostport.substring(colon + 1, hostport.length());
                        } else {
                            host = hostport;
                            port = "80";
                        }
                        if (host == null || host.trim().equals("")) {
                            throw new Exception("Host not found. Invalid value for httpproxy");
                        }
                        if (port == null || port.trim().equals("")) {
                            port = "80";
                        }
                        this.setProxyHost(host, port, https);
                        if (userpwd != null) {
                            String u;
                            int slash = userpwd.indexOf("/");
                            if (slash >= 0) {
                                u = userpwd.substring(0, slash);
                                p = userpwd.substring(slash + 1, userpwd.length());
                            } else {
                                u = userpwd;
                                p = "";
                            }
                            if (u == null || u.trim().equals("")) {
                                throw new Exception("User not found. Invalid value for httpproxy");
                            }
                            this.setProxyUser(u, p, https);
                        }
                        Logger.getDEFAULT().printlnDebug("Using Proxy Details:" + this.getProxyDetails(https));
                    } else {
                        Logger.getDEFAULT().printlnDebug("No http proxy details are provided. Ignoring the option nohttpproxy");
                    }
                } else {
                    this.clearProxyConfiguration(https);
                }
            }
            this.additionalClassPath = this.command.getArgValue("classpath");
            CloudUtil.validateHttpUrl(this.adminUrl, "adminurl");
            if (CloudUtil.isHttpsUrl(this.adminUrl)) {
                Logger.getDEFAULT().printlnDebug("Setting up SSL context");
                SSLUtil.setSSLWithoutKeystore(this.command, !this.isOnUi());
            }
            this.userName = this.command.getArgValue("user");
            this.pwd = this.command.getArgValue("password");
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    public static CommandLine getBaseCommandLine() {
        CommandLineArg datacenter = Main.ARG_DATA_CENTER;
        CommandLineArg adminUrl = Main.ARG_ADMIN_URL;
        CommandLineArg user = Main.ARG_USER;
        CommandLineArg pwd = Main.ARG_PWD;
        CommandLine cmd = new CommandLine();
        cmd.addArg(datacenter);
        cmd.addArg(adminUrl);
        cmd.addArg(user);
        cmd.addArg(pwd);
        cmd.addArg(Main.ARG_SERVICE_GROUP);
        cmd.addArg(Main.ARG_HTTP_PROXY);
        cmd.addArg(Main.ARG_NO_HTTP_PROXY);
        cmd.addArg(Main.ARG_SYS_PROPERTIES);
        cmd.addArg(Main.ARG_PROVIDER_PROPERTIES);
        cmd.addDebugArgs();
        cmd.addHelp();
        cmd.addArgs(SSLUtil.getSSLArguments());
        return cmd;
    }

    public boolean isLocal() {
        return this.local;
    }

    public static enum DATACENTER {
        us1("US Commercial 1"),
        us2("US Commercial 2"),
        em1("EMEA Commercial 1"),
        em2("EMEA Commercial 2"),
        ap1("APAC Commercial 1"),
        ap2("APAC Commercial 2");

        private final String fullname;

        private DATACENTER(String fullname) {
            this.fullname = fullname;
        }

        public static Grid getDescriptionGrid() {
            Grid grid = new Grid();
            grid.addColumn("Name");
            grid.addColumn("Value");
            for (DATACENTER dc : DATACENTER.values()) {
                Row r = grid.createNewRow();
                r.setObjectAt((Object)dc, 1);
                r.setValueAt(dc.fullname, 0);
            }
            grid.pack(88, true);
            return grid;
        }
    }
}

