/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.api.ApplicationManagerConnectionFactory;
import oracle.cloud.paas.client.cli.command.BaseExecutor;
import oracle.cloudlogic.javaservice.common.clibase.executor.ManagableExecutor;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public abstract class ApplicationBaseExecutor
extends BaseExecutor
implements ManagableExecutor {
    ApplicationManager applicationManager = null;
    private boolean onUi = false;
    public static final Map<String, ApplicationManager> APP_MANAGER_CACHE_FOR_LOCAL = new HashMap<String, ApplicationManager>(1);

    public abstract void invoke(ApplicationManager var1) throws Exception;

    @Override
    public void invoke() throws Exception {
        if (this.local) {
            this.applicationManager = APP_MANAGER_CACHE_FOR_LOCAL.get(this.adminUrl + this.userName + this.pwd);
            if (this.applicationManager == null) {
                Logger.getDEFAULT().printlnDebug("Creating application manager");
                this.applicationManager = ApplicationManagerConnectionFactory.createServiceEndpoint((String)"localCloud", (URL)new URL(this.adminUrl), (String)this.tenantID, (String)this.userName, (String)this.pwd);
                if (this.applicationManager != null) {
                    APP_MANAGER_CACHE_FOR_LOCAL.put(this.adminUrl + this.userName + this.pwd, this.applicationManager);
                }
            } else {
                Logger.getDEFAULT().printlnDebug("Re-using application manager");
            }
        } else {
            this.applicationManager = ApplicationManagerConnectionFactory.createServiceEndpoint((String)"cloud", (URL)new URL(this.adminUrl), (String)this.tenantID, (String)this.userName, (String)this.pwd);
        }
        if (this.applicationManager == null) {
            if (this.local) {
                if (this.additionalClassPath == null) {
                    Logger.getDEFAULT().printlnTipI18n("NLS_TIP_USE_CP_PASS_LOCAL_CLOUD", new Object[]{"classpath", "localextension.jar"});
                    throw new Exception(NLSUtil.localizeMessage("NLS_EXCEPTION_COULD_NOT_FIND_PROVIDER", "localCloud"));
                }
                Logger.getDEFAULT().printlnTipI18n("NLS_TIP_ENSURE_CP_CONTAINS_LOCAL_CLOUD", new Object[]{"classpath", "localextension.jar"});
            }
            throw new Exception("System Error:Could not get Application Manager");
        }
        if (ManagableExecutor.class.isAssignableFrom(this.applicationManager.getClass()) && !this.onUi) {
            ((ManagableExecutor)this.applicationManager).prepareToBeManaged();
        }
        this.invoke(this.applicationManager);
    }

    @Override
    public void prepareToBeManaged() {
        this.onUi = true;
    }

    @Override
    public boolean isOnUi() {
        return this.onUi;
    }

    public ApplicationManager getApplicationManager() {
        return this.applicationManager;
    }
}

