/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.bean;

import java.util.Comparator;
import oracle.cloud.paas.client.cli.bean.ComparatorBase;
import oracle.cloud.paas.model.Job;

public class JobComparator
extends ComparatorBase
implements Comparator<Job> {
    private FIELD field;

    public JobComparator(FIELD f, boolean desc) {
        super(desc);
        this.field = f;
    }

    @Override
    public int compare(Job one, Job two) {
        Object first = null;
        Object second = null;
        switch (this.field) {
            case ID: {
                first = one.getJobId();
                second = two.getJobId();
                break;
            }
            case STATUS: {
                first = one.getStatus();
                second = two.getStatus();
                break;
            }
            case DURATION: {
                if (one.getStartedOn() != null && one.getEndedOn() != null) {
                    first = new Long(one.getEndedOn().getTime() - one.getStartedOn().getTime());
                }
                if (two.getStartedOn() == null || two.getEndedOn() == null) break;
                second = new Long(two.getEndedOn().getTime() - two.getStartedOn().getTime());
                break;
            }
            case STARTTIME: {
                first = one.getStartedOn();
                second = two.getStartedOn();
                break;
            }
            case ENDTIME: {
                first = one.getEndedOn();
                second = two.getEndedOn();
                break;
            }
            case UPDATETIME: {
                first = one.getUpdatedOn();
                second = two.getUpdatedOn();
                break;
            }
            case APPLICATION: {
                first = one.getApplicationName();
                second = two.getApplicationName();
                break;
            }
            case OPERATION: {
                first = one.getOperation();
                second = two.getOperation();
            }
        }
        return super.compare((Comparable)first, (Comparable)second);
    }

    public static enum FIELD {
        ID,
        STATUS,
        DURATION,
        STARTTIME,
        ENDTIME,
        UPDATETIME,
        APPLICATION,
        OPERATION;

    }
}

