/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.bean;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.api.JobManager;
import oracle.cloud.paas.client.ClientConstants;
import oracle.cloud.paas.model.Application;
import oracle.cloud.paas.model.Association;
import oracle.cloud.paas.model.Job;
import oracle.cloud.paas.model.Log;
import oracle.cloud.paas.model.Metric;
import oracle.cloud.paas.model.ServiceInstance;
import oracle.cloudlogic.javaservice.common.clibase.display.Cell;
import oracle.cloudlogic.javaservice.common.clibase.display.Grid;
import oracle.cloudlogic.javaservice.common.clibase.display.HeaderCell;
import oracle.cloudlogic.javaservice.common.clibase.display.Row;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.common.clibase.util.TimeUtils;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class BeanUtils
implements ClientConstants {
    public static void printGridRecursive(Grid grid, String titlename, int width, boolean list) {
        BeanUtils.printGridRecursive(Logger.getDEFAULT(), grid, titlename, width, list, false);
    }

    public static void printGridRecursive(Grid grid, String titlename, int width, boolean list, boolean rmemptycolums) {
        BeanUtils.printGridRecursive(Logger.getDEFAULT(), grid, titlename, width, list, rmemptycolums);
    }

    public static void printGridRecursive(Logger logger, Grid grid, String titlename, int width, boolean list) {
        BeanUtils.printGridRecursive(logger, grid, titlename, width, list, false);
    }

    public static void printGridRecursive(Logger logger, Grid grid, String titlename, int width, boolean list, boolean rmemptycolums) {
        logger.println();
        String title = null;
        title = list ? (grid.getRows().size() == 1 ? "Listing one " + titlename : "Listing " + grid.getRows().size() + " " + titlename) : "Describing " + titlename + "";
        if (!grid.pack(width, true, rmemptycolums)) {
            throw new RuntimeException("Could not form grid for the specified width. Please increase gridwidth.");
        }
        grid.printTo(logger, title);
        int row = 0;
        for (Row r : grid.getRows()) {
            int cell = 0;
            for (Cell c : r.getCells()) {
                HeaderCell header = grid.getColumns().getList().get(cell).getValue();
                if (c.getInnderGrid() != null && !c.isInnerGridSerialized()) {
                    logger.println();
                    BeanUtils.printGridRecursive(logger, c.getInnderGrid(), header.getContent() + " of " + titlename + (list ? " @ row:" + (row + 1) : ""), width, true);
                }
                ++cell;
            }
            ++row;
        }
    }

    public static void printJobs(boolean includeInstance, boolean includeApplication, boolean includeStatus, String title, List<Job> types, boolean local, boolean grid, int width, boolean verbose, Date currentTime, JobManager manager) {
        if (types == null || types.size() == 0) {
            Logger.getDEFAULT().printlnInfoI18n("NLS_INFO_NO_JOB");
        } else if (!grid) {
            if (types.size() == 1) {
                Logger.getDEFAULT().println(NLSUtil.localizeMessage("NLS_INFO_ONE_JOB", title));
            } else {
                Logger.getDEFAULT().printlnI18n("NLS_INFO_MANY_JOBS", new Object[]{types.size(), title});
            }
            int count = 1;
            for (Job obj : types) {
                BeanUtils.print(false, includeInstance, includeApplication, obj, count, false, local, verbose, currentTime, manager != null ? manager.listJobLogs(obj.getJobId()) : null);
                ++count;
            }
        } else {
            Grid g = new Grid();
            g.addColumn("#");
            g.addColumn("Job Id");
            if (includeStatus) {
                g.addColumn("Status");
            }
            if (includeInstance) {
                g.addColumn("Service Instance");
            }
            if (verbose) {
                g.addColumn("Start Time");
                g.addColumn("End Time");
            }
            g.addColumn("Duration");
            if (verbose) {
                g.addColumn("Last Updated Time");
            }
            g.addColumn("Last Updated Description");
            if (includeApplication) {
                g.addColumn("Application Name");
            }
            g.addColumn("Operation");
            if (manager != null) {
                g.addColumn("Logs");
            }
            int count = 1;
            for (Job job : types) {
                Row r = g.createNewRow();
                int col = 0;
                r.setValueAt(String.valueOf(count), col++);
                r.setValueAt(job.getJobId(), col++);
                if (includeStatus) {
                    r.setObjectAt(job.getStatus(), col++);
                }
                if (includeInstance) {
                    r.setValueAt(job.getInstanceName(), col++);
                }
                if (verbose) {
                    r.setValueAt(job.getStartedOn() != null ? job.getStartedOn().toString() : "", col++);
                    r.setValueAt(job.getEndedOn() != null ? job.getEndedOn().toString() : "", col++);
                }
                if (job.getStartedOn() != null && job.getEndedOn() != null) {
                    r.setValueAt(TimeUtils.millisToLongDHMS(job.getEndedOn().getTime() - job.getStartedOn().getTime(), false), col++);
                } else {
                    ++col;
                }
                if (verbose) {
                    r.setValueAt(job.getUpdatedOn() != null ? job.getUpdatedOn().toString() : "", col++);
                }
                r.setValueAt(job.getUpdatedOn() == null ? "" : TimeUtils.millisToLongDHMS(currentTime.getTime() - job.getUpdatedOn().getTime(), false) + " ago", col++);
                if (includeApplication) {
                    r.setValueAt(job.getApplicationName(), col++);
                }
                r.setValueAt(job.getOperation(), col++);
                if (manager != null) {
                    List logs = manager.listJobLogs(job.getJobId());
                    StringBuffer buf = new StringBuffer("");
                    if (!logs.isEmpty()) {
                        buf.append("[");
                        int lc = 0;
                        for (Log l : logs) {
                            if (lc != 0) {
                                buf.append(",");
                            }
                            buf.append(l.getName());
                            ++lc;
                        }
                        buf.append("]");
                    }
                    r.setValueAt(buf.toString(), col++);
                }
                ++count;
            }
            BeanUtils.printGridRecursive(g, (types.size() == 1 ? "job" : "jobs") + " under " + title, width, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int print(String group, ServiceInstance obj, int count, boolean full, int cols) {
        Logger.getDEFAULT().println();
        Logger.getDEFAULT().printlnI18n("NLS_MSG_DESCRIBING_SI", new Object[]{obj.getInstanceName(), group});
        Logger logger = Logger.getDEFAULT();
        synchronized (logger) {
            int diff = Logger.getDEFAULT().tab(cols);
            Logger.getDEFAULT().println();
            OrderedMap<String, String> orderedMap = Logger.getDEFAULT().initMapText();
            synchronized (orderedMap) {
                int length = cols <= 0 ? group.length() + 3 : cols;
                String leftDash = CloudUtil.padChar(length, '-', "", length, true);
                Logger.getDEFAULT().addMapText(leftDash, "------------------");
                Logger.getDEFAULT().addMapText(count + ":Service Instance", obj.getInstanceName());
                Logger.getDEFAULT().addMapText("State", obj.getState());
                Logger.getDEFAULT().addMapText("Size", obj.getSize());
                Logger.getDEFAULT().addMapText("Associations Count", obj.getAssociations() == null ? "0" : String.valueOf(obj.getAssociations().size()));
                Logger.getDEFAULT().addMapText(leftDash, "------------------");
                cols = Logger.getDEFAULT().endMapText();
            }
            Logger.getDEFAULT().shiftTab(diff);
        }
        if (full && obj.getAssociations() != null) {
            cols = BeanUtils.printAssociations(obj.getAssociations(), cols);
        }
        return cols;
    }

    public static void printServiceInstances(String groupName, List<ServiceInstance> types, boolean grid, int width, boolean full, boolean list, int alignwidth) {
        String name = null;
        name = list ? (types.size() > 1 ? "service instances" : "service instance") + " under identity domain " + groupName : "service instance :" + types.get(0).getInstanceName() + " under identity domain:" + groupName;
        Logger.getDEFAULT().println();
        if (!grid) {
            if (list) {
                if (types.size() == 1) {
                    Logger.getDEFAULT().println(NLSUtil.localizeMessage("NLS_INFO_ONE_INSTANCE"));
                } else {
                    Logger.getDEFAULT().printlnI18n("NLS_INFO_MORE_INSTANCES", String.valueOf(types.size()));
                }
            }
            if (list) {
                Logger.getDEFAULT().println("Listing " + name);
            } else {
                Logger.getDEFAULT().println("Describing " + name);
            }
            int count = 1;
            for (ServiceInstance obj : types) {
                alignwidth = BeanUtils.print(groupName, obj, count, full, alignwidth);
                ++count;
            }
        } else {
            Grid g = new Grid();
            if (list) {
                g.addColumn("#");
                g.addColumn("Service Instance");
            }
            g.addColumn("State");
            g.addColumn("Size");
            if (full) {
                g.addColumn("Association(s)");
            } else {
                g.addColumn("#Association(s)");
            }
            int count = 1;
            for (ServiceInstance obj : types) {
                Row r = g.createNewRow();
                int col = 0;
                if (list) {
                    r.setValueAt(String.valueOf(count), col++);
                    r.setObjectAt(obj.getInstanceName(), col++);
                }
                r.setObjectAt(obj.getState(), col++);
                r.setObjectAt(obj.getSize(), col++);
                if (full) {
                    r.setGridAt(BeanUtils.getAssociationsAsGrid(obj.getAssociations()), col++);
                } else {
                    r.setValueAt(String.valueOf(obj.getAssociations().size()), col++);
                }
                ++count;
            }
            BeanUtils.printGridRecursive(g, name, width, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printApplications(String title, List<Application> types, boolean grid, int width, boolean full, boolean list, int cols) {
        if (types == null || types.size() == 0) {
            Logger.getDEFAULT().printlnInfoI18n("NLS_INFO_NO_APPLICATIONS");
            Logger.getDEFAULT().printlnTipI18n("NLS_TIP_INSTALL", "install");
        } else if (!grid) {
            Logger logger = Logger.getDEFAULT();
            synchronized (logger) {
                int diff = Logger.getDEFAULT().tab(cols);
                if (list) {
                    Logger.getDEFAULT().println();
                    if (types.size() == 1) {
                        Logger.getDEFAULT().println(NLSUtil.localizeMessage("NLS_INFO_ONE_APPLICATION"));
                    } else {
                        Logger.getDEFAULT().printlnI18n("NLS_INFO_MORE_APPLICATIONS", String.valueOf(types.size()));
                    }
                }
                int count = 1;
                for (Application obj : types) {
                    cols = BeanUtils.print(obj, count, full, cols);
                    ++count;
                }
                Logger.getDEFAULT().shiftTab(diff);
            }
        } else {
            Grid g = new Grid();
            g.addColumn("#");
            g.addColumn("Application Name");
            g.addColumn("State");
            g.addColumn("Application Urls");
            if (full) {
                g.addColumn("Type");
            }
            int count = 1;
            for (Application obj : types) {
                Row r = g.createNewRow();
                int col = 0;
                r.setValueAt(String.valueOf(count), col++);
                r.setValueAt(obj.getApplicationName(), col++);
                r.setValueAt(obj.getState().toString(), col++, true);
                r.setContents(obj.getApplicationUrls(), col++);
                if (full) {
                    r.setObjectAt(obj.getType(), col++);
                }
                ++count;
            }
            if (list) {
                BeanUtils.printGridRecursive(g, (types.size() == 1 ? "application" : "applications") + " under " + title, width, list);
            } else {
                BeanUtils.printGridRecursive(g, "application " + types.get(0).getApplicationName(), width, list);
            }
        }
    }

    public static Grid findGrid(Grid g, Cell c) {
        Row r;
        if (g.getRows().size() > 0 && (r = g.getRows().get(g.getRows().size() - 1)).getCells().get(0).getContent().equals(c.getContent())) {
            return r.getCells().get(1).getInnderGrid();
        }
        return null;
    }

    public static void main(String[] s) throws Exception {
        Grid g = new Grid();
        g.addColumn("1");
        g.addColumn("2");
        g.addColumn("3");
        Row r = g.createNewRow();
        r.setValueAt("a", 0);
        r.setValueAt("a", 1);
        r.setValueAt("d", 2);
        r = g.createNewRow();
        r.setValueAt("a", 0);
        r.setValueAt("ca", 1);
        r.setValueAt("k", 2);
        r = g.createNewRow();
        r.setValueAt("a", 0);
        r.setValueAt("b", 1);
        r.setValueAt("a", 2);
        r = g.createNewRow();
        r.setValueAt("b", 0);
        r.setValueAt("b", 1);
        r.setValueAt("f", 2);
        g.pack(100);
        g.printTo(Logger.getDEFAULT());
        g = BeanUtils.asTree(g, "Metrics", 1);
        g.pack(100);
        g.printTo(Logger.getDEFAULT());
    }

    private static Grid asTree(Grid table, String groupcolumnname, int lastcolumns_to_retain) {
        if (lastcolumns_to_retain == 0) {
            return table;
        }
        if (table.getColumns().size() <= 2) {
            return table;
        }
        if (table.getColumns().size() <= lastcolumns_to_retain + 1) {
            return table;
        }
        Grid g = new Grid();
        g.addColumn(table.getColumns().getList().get(0).getValue().getContent());
        g.addColumn(groupcolumnname);
        for (Row r : table.getRows()) {
            Grid temp = g;
            Row temprow = null;
            for (int i = 0; i < r.getCells().size(); ++i) {
                Cell c = r.getCells().get(i);
                if (i >= r.getCells().size() - lastcolumns_to_retain - 1) {
                    if (temprow == null) {
                        for (int col = i; col < table.getColumns().getList().size(); ++col) {
                            temp.addColumn(table.getColumns().getList().get(col).getName());
                        }
                        temprow = temp.createNewRow();
                    }
                    temprow.setValueAt(c.getContent() == null ? "" : c.getContent(), i - r.getCells().size() + lastcolumns_to_retain + 1);
                    continue;
                }
                Grid current = BeanUtils.findGrid(temp, c);
                if (current == null) {
                    Row row = temp.createNewRow();
                    row.setValueAt(c.getContent() == null ? "" : c.getContent(), 0);
                    Grid inner = new Grid();
                    inner.addColumn(table.getColumns().getList().get(i + 1).getName());
                    if (i + 1 < r.getCells().size() - lastcolumns_to_retain - 1) {
                        inner.addColumn(groupcolumnname);
                    }
                    row.setGridAt(inner, 1);
                    temp = inner;
                    continue;
                }
                temp = current;
            }
        }
        return g;
    }

    public static void printMetrics(String title, List<Metric> types, int gridwidth, boolean verbose, boolean tree) {
        if (types == null || types.size() == 0) {
            Logger.getDEFAULT().printlnInfo("No metrics");
        } else {
            String valColumName = "Value";
            String valMetric = "Metric Name";
            Grid g = new Grid();
            if (!tree) {
                g.addColumn("#");
            }
            g.addColumn("Server Name");
            g.addColumn("Component Name");
            g.addColumn("Component Instance Name");
            g.addColumn(valMetric);
            g.addColumn(valColumName);
            if (verbose) {
                g.addColumn("Description");
            }
            int count = 1;
            for (Metric obj : types) {
                Row r = g.createNewRow();
                int col = 0;
                if (!tree) {
                    r.setValueAt(String.valueOf(count), col++);
                }
                r.setValueAt(obj.getServer(), col++);
                r.setValueAt(obj.getCategory(), col++);
                r.setValueAt(obj.getComponent(), col++);
                r.setValueAt(obj.getName(), col++);
                double val = obj.getValue();
                String str = null;
                str = obj.isValueMiliSeconds() ? TimeUtils.millisToLongDHMS((long)val, true) : (obj.isValueByte() ? String.valueOf((double)((long)(val / 1024.0) * 100L) / 100.0) + " KB." : (val - (double)((long)val) == 0.0 ? String.valueOf((long)val) : String.valueOf((double)Math.round(val * 100.0) / 100.0)));
                r.setValueAt(str, col++);
                if (verbose) {
                    r.setValueAt(obj.getDescription(), col++);
                }
                ++count;
            }
            g.removeEmptyColumns();
            if (tree) {
                g = BeanUtils.asTree(g, "Metrics", g.getColumns().size() - g.getColumnIndex(valMetric) - 1);
            }
            BeanUtils.printGridRecursive(g, (types.size() == 1 ? "metric" : "metrics") + " under " + title, gridwidth, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printLogs(List<Log> types, boolean grid, int width, boolean list, int cols, String forwhat, boolean verbose, Date currentTime, ApplicationManager manager, String jobid, boolean autodownload) {
        if (types == null || types.size() == 0) {
            Logger.getDEFAULT().printlnInfoI18n("NLS_INFO_NO_LOG", forwhat);
        } else if (!grid) {
            Logger logger = Logger.getDEFAULT();
            synchronized (logger) {
                int diff = Logger.getDEFAULT().tab(cols);
                if (list) {
                    Logger.getDEFAULT().println();
                    if (types.size() == 1) {
                        Logger.getDEFAULT().println(NLSUtil.localizeMessage("NLS_INFO_ONE_LOG", forwhat));
                    } else {
                        Logger.getDEFAULT().printlnI18n("NLS_INFO_MANY_APP_LOGS", new Object[]{String.valueOf(types.size()), forwhat});
                    }
                }
                int count = 1;
                for (Log obj : types) {
                    BeanUtils.print(obj, count, 0, verbose, currentTime);
                    ++count;
                }
                Logger.getDEFAULT().shiftTab(diff);
            }
        } else {
            Grid g = new Grid();
            g.addColumn("#");
            g.addColumn("Log Name");
            if (autodownload) {
                g.addColumn("Content");
            }
            if (verbose) {
                g.addColumn("Last Updated");
            }
            g.addColumn("Last Updated Description");
            g.addColumn("Content Type");
            int count = 1;
            for (Log obj : types) {
                Row r = g.createNewRow();
                int col = 0;
                r.setValueAt(String.valueOf(count), col++);
                r.setValueAt(obj.getName(), col++);
                if (autodownload) {
                    ByteArrayOutputStream bo = new ByteArrayOutputStream();
                    manager.fetchJobLog(jobid, obj.getName(), (OutputStream)bo);
                    r.setValueAt(new String(bo.toByteArray()), col++);
                }
                if (verbose) {
                    r.setValueAt(obj.getLastModified() == null ? "" : obj.getLastModified().toString(), col++);
                }
                r.setValueAt(obj.getLastModified() == null ? "" : TimeUtils.millisToLongDHMS(currentTime.getTime() - obj.getLastModified().getTime(), false) + " ago", col++);
                r.setValueAt(obj.getContentType(), col++);
                ++count;
            }
            if (list) {
                BeanUtils.printGridRecursive(g, forwhat + (types.size() == 1 ? " log" : " logs"), width, list);
            } else {
                BeanUtils.printGridRecursive(g, "log " + types.get(0).getName(), width, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int print(Application obj, int count, boolean full, int cols) {
        Logger logger = Logger.getDEFAULT();
        synchronized (logger) {
            int diff = Logger.getDEFAULT().tab(cols);
            Logger.getDEFAULT().println();
            OrderedMap<String, String> orderedMap = Logger.getDEFAULT().initMapText();
            synchronized (orderedMap) {
                Logger.getDEFAULT().addMapText("-----------", "-----------------------");
                Logger.getDEFAULT().addMapText(count + ":Application Name", obj.getApplicationName());
                Logger.getDEFAULT().addMapText("State", obj.getState().toString());
                Logger.getDEFAULT().addMapText("Application Urls", CloudUtil.getSeparatedListOfString(obj.getApplicationUrls(), "", "", false, "\n\n"));
                if (full) {
                    Logger.getDEFAULT().addMapText("Application Type", obj.getType().toString());
                    Logger.getDEFAULT().addMapText("Identity Domain", obj.getGroupName());
                    Logger.getDEFAULT().addMapText("Service Instance", obj.getInstanceName());
                }
                Logger.getDEFAULT().addMapText("----------- ", "-----------------------");
                cols = Logger.getDEFAULT().endMapText();
            }
            Logger.getDEFAULT().shiftTab(diff);
        }
        return cols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(Log log, int numbebr, int align, boolean full, Date currentTime) {
        if (align == 0) {
            align = 20;
        }
        Logger.getDEFAULT().println();
        OrderedMap<String, String> orderedMap = Logger.getDEFAULT().initMapText();
        synchronized (orderedMap) {
            String dahshes = CloudUtil.padChar(align, '-', "", align, true);
            Logger.getDEFAULT().addMapText(dahshes, "-----------------------");
            Logger.getDEFAULT().addMapText("Log Number:", String.valueOf(numbebr));
            Logger.getDEFAULT().addMapText("->", "Properties");
            Logger.getDEFAULT().addMapText(dahshes, "-----------------------");
            Logger.getDEFAULT().addMapText("Log Name", log.getName());
            if (full) {
                Logger.getDEFAULT().addMapText("Last Updated", log.getLastModified());
            }
            Logger.getDEFAULT().addMapText("Last Updated Description", log.getLastModified() == null ? "" : TimeUtils.millisToLongDHMS(currentTime.getTime() - log.getLastModified().getTime(), false) + " ago");
            Logger.getDEFAULT().addMapText("Log Type", log.getContentType());
            Logger.getDEFAULT().addMapText(dahshes, "-----------------------");
            Logger.getDEFAULT().endMapText();
        }
    }

    public static void print(Job job, int count, boolean describeJob, boolean local, Date currentTime, List<Log> logs) {
        BeanUtils.print(job, count, describeJob, local, true, currentTime, logs);
    }

    public static void print(Job job, int count, boolean describeJob, boolean local, boolean verbose, Date currentTime, List<Log> logs) {
        BeanUtils.print(true, true, true, job, count, describeJob, local, verbose, currentTime, logs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int print(boolean includegroup, boolean includeInstance, boolean includeApplication, Job job, int count, boolean describeJob, boolean local, boolean verbose, Date currentTime, List<Log> logs) {
        Logger.getDEFAULT().println();
        int cols = 0;
        Object object = Logger.getDEFAULT().initMapText();
        synchronized (object) {
            Logger.getDEFAULT().addMapText(count + ":Job Id", job.getJobId());
            Logger.getDEFAULT().addMapText("-----------", "-----------------------");
            Logger.getDEFAULT().addMapText("->", "Properties");
            Logger.getDEFAULT().addMapText("------------", "-----------------------");
            Logger.getDEFAULT().addMapText("Status", job.getStatus());
            if (includegroup) {
                Logger.getDEFAULT().addMapText("Identity Domain", job.getGroupName());
            }
            if (includeInstance) {
                Logger.getDEFAULT().addMapText("Service Instance", job.getInstanceName());
            }
            if (includeApplication) {
                Logger.getDEFAULT().addMapText("Application", job.getApplicationName());
            }
            if (verbose) {
                Logger.getDEFAULT().addMapText("Start Time", job.getStartedOn());
                Logger.getDEFAULT().addMapText("End Time", job.getEndedOn());
            }
            if (job.getStartedOn() != null && job.getEndedOn() != null) {
                Logger.getDEFAULT().addMapText("Duration", TimeUtils.millisToLongDHMS(job.getEndedOn().getTime() - job.getStartedOn().getTime(), false));
            }
            if (verbose) {
                Logger.getDEFAULT().addMapText("Last Updated Time", job.getUpdatedOn());
            }
            if (job.getUpdatedOn() != null) {
                Logger.getDEFAULT().addMapText("Last Updated Description", TimeUtils.millisToLongDHMS(currentTime.getTime() - job.getStartedOn().getTime(), false) + " ago");
            }
            Logger.getDEFAULT().addMapText("Operation", job.getOperation());
            if (logs != null) {
                Logger.getDEFAULT().addMapText("Number of Logs", logs.size());
            }
            Logger.getDEFAULT().addMapText("-------------", "-----------------------");
            cols = Logger.getDEFAULT().endMapText();
        }
        Logger.getDEFAULT().println();
        object = Logger.getDEFAULT();
        synchronized (object) {
            int diff = Logger.getDEFAULT().tab(cols);
            if (!describeJob && !local) {
                Logger.getDEFAULT().printlnTipI18n("NLS_TIP_DESCRIBE_JOB", "job-status");
            }
            if (logs != null && logs.size() > 0 && !local) {
                Logger.getDEFAULT().printlnTipI18n("NLS_TIP_FETCH_LOG", "job-log-file");
            }
            Logger.getDEFAULT().shiftTab(diff);
        }
        int c = 1;
        if (logs != null) {
            for (Log log : logs) {
                BeanUtils.print(log, c, cols, verbose, currentTime);
                ++c;
            }
        }
        return cols;
    }

    public static Grid getAssociationsAsGrid(List<Association> list) {
        if (list.size() == 0) {
            return null;
        }
        Grid g = new Grid();
        g.addColumn("Service Type");
        g.addColumn("Service Instance");
        for (Association p : list) {
            Row r = g.createNewRow();
            r.setObjectAt(p.getTargetServiceType(), 0);
            r.setValueAt(p.getTargetInstanceName(), 1);
        }
        return g;
    }

    public static int printAssociations(List<Association> prop, int cols) {
        int count = 1;
        for (Association a : prop) {
            cols = BeanUtils.printAssociation(a, count++, cols);
        }
        return cols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int printAssociation(Association a, int count, int cols) {
        Logger.getDEFAULT().println();
        Logger logger = Logger.getDEFAULT();
        synchronized (logger) {
            int diff = Logger.getDEFAULT().tab(cols);
            OrderedMap<String, String> orderedMap = Logger.getDEFAULT().initMapText();
            synchronized (orderedMap) {
                Logger.getDEFAULT().addMapText(count + ":Associated Instance", a.getTargetInstanceName());
                Logger.getDEFAULT().addMapText("->", "Properties");
                int length = cols <= 0 ? a.getTargetInstanceName().length() + 3 : cols;
                String leftDash = CloudUtil.padChar(length, '-', "", length, true);
                Logger.getDEFAULT().addMapText(leftDash, "-----------------------");
                Logger.getDEFAULT().addMapText("Service Type", a.getTargetServiceType().toString());
                Logger.getDEFAULT().addMapText("Service Instance", a.getTargetInstanceName());
                Logger.getDEFAULT().addMapText(leftDash, "-----------------------");
                cols = Logger.getDEFAULT().endMapText();
            }
            Logger.getDEFAULT().shiftTab(diff);
        }
        return cols;
    }
}

