/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.bean;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import oracle.cloud.paas.client.cli.bean.ApplicationLogRecord;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloudlogic.javaservice.common.clibase.display.Cell;
import oracle.cloudlogic.javaservice.common.clibase.display.Grid;
import oracle.cloudlogic.javaservice.common.clibase.display.HeaderCell;
import oracle.cloudlogic.javaservice.common.clibase.display.Row;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.TimeUtils;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ApplicationLogRecords", propOrder={"msg"})
@XmlRootElement(name="msgs")
public class ApplicationLogRecords {
    private List<ApplicationLogRecord> msg = new ArrayList<ApplicationLogRecord>();

    public List<ApplicationLogRecord> getMsg() {
        return this.msg;
    }

    public int writeDeltaTo(ApplicationLogRecords old, Logger logger, Grid table, int ROW, int tablewidth, boolean full) {
        boolean freeflow = false;
        boolean needPack = ROW == 0;
        for (ApplicationLogRecord rec : this.msg) {
            if (!freeflow) {
                if (old.isPresent(rec)) continue;
                freeflow = true;
            }
            if (table == null) {
                logger.println(rec.toString());
                continue;
            }
            int col = 0;
            Row row = table.createNewRow();
            row.setValueAt(String.valueOf(++ROW), col++);
            row.setValueAt(rec.getTime(), col++);
            if (full) {
                row.setObjectAt(rec.getDateTime(), col++);
                row.setValueAt(TimeUtils.millisToLongDHMS(new Date().getTime() - rec.getDateTime().getTime()), col++);
            }
            row.setValueAt(rec.getType() + ":" + rec.getLevel(), col++);
            row.setValueAt(rec.getText() + (rec.getSuppl_detail() == null ? "" : "\n" + rec.getSuppl_detail()), col++);
            if (needPack) {
                needPack = false;
                BeanUtils.printGridRecursive(table, "initial record and following", tablewidth, true);
            } else {
                this.resetFormatting(table, row);
                table.printRow(logger, row, true);
                logger.println(table.getRowSpliter(true));
            }
            table.getRows().clear();
        }
        return ROW;
    }

    public void resetFormatting(Grid table, Row r) {
        int c = 0;
        for (NameValuePair<String, HeaderCell> pair : table.getColumns().getList()) {
            pair.getValue().cutWithWidth(pair.getValue().getWidth(), false);
            Cell cell = r.getCells().get(c);
            cell.cutWithWidth(pair.getValue().getWidth(), false);
            ++c;
        }
    }

    public boolean isPresent(ApplicationLogRecord rec) {
        for (int i = this.msg.size() - 1; i >= 0; --i) {
            ApplicationLogRecord old = this.msg.get(i);
            if (old.getDateTime().equals(rec.getDateTime())) {
                if (!old.toString().equals(rec.toString())) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

