/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli;

import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Properties;
import oracle.cloud.paas.client.ClientConstants;
import oracle.cloud.paas.client.cli.bean.ApplicationComparator;
import oracle.cloud.paas.client.cli.bean.ApplicationLogRecord;
import oracle.cloud.paas.client.cli.bean.CertificateComparator;
import oracle.cloud.paas.client.cli.bean.JobComparator;
import oracle.cloud.paas.client.cli.bean.JobLogComparator;
import oracle.cloud.paas.client.cli.bean.LibraryComparator;
import oracle.cloud.paas.client.cli.bean.LogRecordComparator;
import oracle.cloud.paas.client.cli.bean.MetricComparator;
import oracle.cloud.paas.client.cli.bean.ServerComparator;
import oracle.cloud.paas.client.cli.command.ApplicationBaseExecutor;
import oracle.cloud.paas.client.cli.command.BaseExecutor;
import oracle.cloud.paas.client.cli.command.DescribeApplication;
import oracle.cloud.paas.client.cli.command.DescribeJob;
import oracle.cloud.paas.client.cli.command.DescribeLibrary;
import oracle.cloud.paas.client.cli.command.DescribeServiceInstance;
import oracle.cloud.paas.client.cli.command.FetchApplicationLogRecordsExecutor;
import oracle.cloud.paas.client.cli.command.FetchJobLog;
import oracle.cloud.paas.client.cli.command.HtmlUsagePageGenerator;
import oracle.cloud.paas.client.cli.command.InstallApplication;
import oracle.cloud.paas.client.cli.command.InstallLibrary;
import oracle.cloud.paas.client.cli.command.LibraryBaseExecutor;
import oracle.cloud.paas.client.cli.command.ListApplications;
import oracle.cloud.paas.client.cli.command.ListJobLogs;
import oracle.cloud.paas.client.cli.command.ListJobs;
import oracle.cloud.paas.client.cli.command.ListLibraries;
import oracle.cloud.paas.client.cli.command.ListServiceInstances;
import oracle.cloud.paas.client.cli.command.ListServiceMetrics;
import oracle.cloud.paas.client.cli.command.RestartServiceInstanceExecutor;
import oracle.cloud.paas.client.cli.command.ServiceBaseGridGroupByExecutor;
import oracle.cloud.paas.client.cli.command.StartApplication;
import oracle.cloud.paas.client.cli.command.StopApplication;
import oracle.cloud.paas.client.cli.command.UninstallApplication;
import oracle.cloud.paas.client.cli.command.UninstallLibrary;
import oracle.cloud.paas.client.cli.command.UpdateApplication;
import oracle.cloud.paas.client.cli.command.UpdateLibrary;
import oracle.cloud.paas.client.cli.command.VersionProvider;
import oracle.cloud.paas.client.cli.command.common.certficate.CommonGetCertificates;
import oracle.cloud.paas.client.cli.command.common.cred.DeleteCredential;
import oracle.cloud.paas.client.cli.command.common.cred.DescribeCredential;
import oracle.cloud.paas.client.cli.command.common.cred.ListCredentialMaps;
import oracle.cloud.paas.client.cli.command.common.cred.ListCredentials;
import oracle.cloud.paas.client.cli.command.common.cred.SetCredential;
import oracle.cloud.paas.client.cli.command.common.dsjndi.AddDSJndiName;
import oracle.cloud.paas.client.cli.command.common.dsjndi.DeleteDSJndiName;
import oracle.cloud.paas.client.cli.command.common.dsjndi.ListDSJndiNames;
import oracle.cloud.paas.client.cli.command.common.fs.FSShell;
import oracle.cloud.paas.client.cli.command.common.owsm.trust.AddCertificate;
import oracle.cloud.paas.client.cli.command.common.owsm.trust.GetCertificate;
import oracle.cloud.paas.client.cli.command.common.owsm.trust.ListCertificates;
import oracle.cloud.paas.client.cli.command.common.owsm.trust.ResetStore;
import oracle.cloud.paas.client.cli.command.common.ssl.trust.DeleteCertificate;
import oracle.cloud.paas.client.cli.command.common.wlst.WLSTShell;
import oracle.cloud.paas.client.cli.command.util.ListCommands;
import oracle.cloud.paas.client.nls.C9ClientMessageBundle;
import oracle.cloud.paas.model.ApplicationType;
import oracle.cloud.paas.model.JobStatus;
import oracle.cloud.paas.model.LibraryDeployType;
import oracle.cloud.paas.model.LibraryType;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.CommandLineArg;
import oracle.cloudlogic.javaservice.common.clibase.MainBase;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.provider.CliExecutorProvider;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.common.clibase.util.ProcessUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class Main
extends MainBase
implements ClientConstants {
    public static OrderedMap<String, CommandLine> allCommands = new OrderedMap();
    public static String DEFAULT_PROP_SEPARATOR = ",";
    public static final String JAR_NAME = "javacloud.jar";
    public static final String JAR_CLOCAL_LOUD9_NAME = "localextension.jar";
    public static final String DEF_ADMIN_URL_FORMAT = "https://javaservices.<datacenter>.cloud.oracle.com";
    public static CommandLineArg ARG_LOCAL = null;
    public static CommandLineArg ARG_LOCAL_HIDDEN = null;
    public static CommandLineArg ARG_SYS_PROPERTIES = null;
    public static CommandLineArg ARG_PROVIDER_PROPERTIES = null;
    public static CommandLineArg ARG_ACP = null;
    public static CommandLineArg ARG_SERVICE_GROUP = null;
    public static CommandLineArg ARG_SERVICE_INSTANCE = null;
    public static CommandLineArg ARG_SHELL_COMMAND = null;
    public static CommandLineArg ARG_SHELL_AUTO_EXIT = null;
    public static CommandLineArg ARG_SHELL_VALIDATE_SPECIAL_CHARS = null;
    public static CommandLineArg ARG_STRIPE_NAME = null;
    public static CommandLineArg ARG_KEYSTORE_NAME = null;
    public static CommandLineArg ARG_KEYSTORE_PWD = null;
    public static CommandLineArg ARG_ADMIN_URL = null;
    public static CommandLineArg ARG_DATA_CENTER = null;
    public static CommandLineArg ARG_USER = null;
    public static CommandLineArg ARG_DESC = null;
    public static CommandLineArg ARG_PWD = null;
    public static CommandLineArg ARG_ADMIN_STATE = null;
    public static CommandLineArg ARG_LOG_NAME = null;
    public static CommandLineArg ARG_GREP = null;
    public static CommandLineArg ARG_MAP = null;
    public static CommandLineArg ARG_KEY = null;
    public static CommandLineArg ARG_KEY_USER = null;
    public static CommandLineArg ARG_ALIAS = null;
    public static CommandLineArg ARG_ALIAS_MANDATORY = null;
    public static CommandLineArg ARG_CERT_FILE_TYPE = null;
    public static CommandLineArg ARG_CERT_FILE_TYPE_OUTPUT = null;
    public static CommandLineArg ARG_KEY_PWD = null;
    public static CommandLineArg ARG_OUTPUT = null;
    public static CommandLineArg ARG_HTTP_PROXY = null;
    public static CommandLineArg ARG_NO_HTTP_PROXY = null;
    public static CommandLineArg ARG_WEB_MODULE_URI = null;
    public static CommandLineArg ARG_WORK_MANAGER_NAME = null;
    public static CommandLineArg ARG_JOB_SORT_ON = null;
    public static CommandLineArg ARG_APP_LOGS_SORT_ON = null;
    public static CommandLineArg ARG_JOB_LOG_SORT_ON = null;
    public static CommandLineArg ARG_SERVER_SORT_ON = null;
    public static CommandLineArg ARG_CERTIFICATE_SORT_ON = null;
    public static CommandLineArg ARG_APPLICATION_SORT_ON = null;
    public static CommandLineArg ARG_LIBRARY_SORT_ON = null;
    public static CommandLineArg ARG_METRICS_SORT_ON = null;
    public static CommandLineArg ARG_METRICS_GROUP_BY = null;
    public static CommandLineArg ARG_SORT_DESCENDING = null;
    public static CommandLineArg ARG_START_TIME = null;
    public static CommandLineArg ARG_END_TIME = null;
    public static CommandLineArg ARG_SEVERITY = null;
    public static CommandLineArg ARG_STATUS = null;
    public static CommandLineArg ARG_FOLLOW = null;
    public static CommandLineArg ARG_FORCE = null;
    public static CommandLineArg ARG_TIMEOUT = null;
    public static CommandLineArg ARG_FOLLOW_MILLIS = null;
    public static CommandLineArg ARG_XML = null;
    public static CommandLineArg ARG_AUTO_VIEW_LOGS = null;
    public static CommandLineArg ARG_TREE = null;
    public static CommandLineArg ARG_LAST = null;
    public static CommandLineArg ARG_DATE_FORMAT = null;
    public static CommandLineArg ARG_UNIT = null;
    public static CommandLineArg ARG_LIMIT = null;
    public static CommandLineArg ARG_CONTAINS = null;
    public static CommandLineArg ARG_CONTAINS_SEPERATOR = null;
    public static CommandLineArg ARG_DS_NAME = null;
    public static CommandLineArg ARG_JNDI_NAME = null;
    public static CommandLineArg fullFormat = null;
    public static CommandLineArg appName = null;
    public static CommandLineArg gridwidth = null;

    @Override
    public Properties getDefaultProperties(CommandLine cmd) {
        File prop;
        String fileName = "javacloud.properties";
        Properties p = super.getDefaultProperties(cmd);
        if (p == null) {
            p = new Properties();
        }
        if (!(prop = new File("./", fileName)).exists() || !prop.isFile()) {
            prop = new File(ProcessUtil.getUSER_HOME(), fileName);
        }
        if (prop.exists() && prop.isFile()) {
            Logger.getDEFAULT().printlnDebug("Reading property file at:" + prop.getAbsolutePath());
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(prop);
                p.load(fis);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e1) {}
                }
            }
        }
        return p;
    }

    public static void addCommandLine(CommandLine command) {
        allCommands.put(command.getCommandName(), command);
    }

    @Override
    public OrderedMap<String, CommandLine> getAllCommands() {
        return allCommands;
    }

    @Override
    public String getUsage(boolean html) {
        String command1 = "java -jar javacloud.jar -install -application myApp -user user1 -path c:\\local\\myapp.war -serviceinstance myservice -identitydomain myidentitydomain";
        String command2 = "java -jar javacloud.jar -job-status -user user1 -jobid 23223";
        String command3 = "java -jar javacloud.jar query-service-metrics -help";
        String note = NLSUtil.localizeMessage("NLS_USAGE_NOTE", JAR_NAME);
        if (html) {
            command1 = CloudUtil.textEncodetoXML(command1, true);
            command2 = CloudUtil.textEncodetoXML(command2, true);
            command3 = CloudUtil.textEncodetoXML(command3, true);
        }
        return "java -jar javacloud.jar <-command> [-argument ...] [-help] \n\n" + (html ? CloudUtil.convertToHelpText(note, 80, 5) : note) + "\n\n\nFor example:\n" + "     1.)" + (html ? CloudUtil.convertToHelpText(command1, html ? 160 : 80, 10) : command1) + "\n\n     2.)" + (html ? CloudUtil.convertToHelpText(command2, html ? 160 : 80, 10) : command2) + "\n\n     3.)" + (html ? CloudUtil.convertToHelpText(command3, html ? 160 : 80, 10) : command3);
    }

    static {
        try {
            NLSUtil.addBundle(C9ClientMessageBundle.class.getName(), Main.class.getClassLoader());
            ARG_DATE_FORMAT = new CommandLineArg("datetimeformat", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_DATE_FORMAT"));
            ARG_DATE_FORMAT.setShortCut("dtf");
            ARG_DATE_FORMAT.setOptionDefaltValue("MM/dd");
            ARG_CONTAINS = new CommandLineArg("contains", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.many, ",", null), NLSUtil.localizeMessage("NLS_PARAM_DESC_CONTAINS", "containsseperator"));
            ARG_CONTAINS.setNullStringAllowed(true);
            ARG_CONTAINS_SEPERATOR = new CommandLineArg("containsseperator", false, new CommandLineArg.DateOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_CONTAINS_SEPERATOR", "contains"));
            ARG_CONTAINS_SEPERATOR.setOptionDefaltValue(",");
            ARG_START_TIME = new CommandLineArg("starttime", false, new CommandLineArg.DateOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_START_TIME", "last"));
            ARG_START_TIME.setShortCut("st");
            ARG_END_TIME = new CommandLineArg("endtime", false, new CommandLineArg.DateOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_END_TIME", "starttime"));
            ARG_END_TIME.setShortCut("et");
            ARG_SEVERITY = new CommandLineArg("severity", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.many, ",", null), NLSUtil.localizeMessage("NLS_PARAM_DESC_SEVERITY"));
            ARG_SEVERITY.setShortCut("sev");
            ARG_SEVERITY.setPossibleEnumValues(CloudUtil.getEnumValuesAsList(ApplicationLogRecord.SEVERITY.class));
            ARG_SEVERITY.setOptionDefaltValue(ApplicationLogRecord.SEVERITY.WARNING.toString() + "," + ApplicationLogRecord.SEVERITY.ERROR.toString() + "," + ApplicationLogRecord.SEVERITY.INCIDENT_ERROR.toString());
            ARG_SEVERITY.setNullStringAllowed(true);
            ARG_STATUS = new CommandLineArg("status", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.many, ",", null), NLSUtil.localizeMessage("NLS_PARAM_DESC_PARAM_STATUS_LIST", " job"));
            ARG_STATUS.setShortCut("s");
            ARG_STATUS.setPossibleEnumValues(Arrays.asList(JobStatus.FAILED.toString(), JobStatus.COMPLETE.toString(), JobStatus.RUNNING.toString()));
            ARG_STATUS.setNullStringAllowed(true);
            ARG_FOLLOW = new CommandLineArg("follow", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_FOLLOW", "endtime"));
            ARG_FOLLOW.setOptionDefaltValue("false");
            ARG_FORCE = new CommandLineArg("force", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_FORCE"));
            ARG_FORCE.setOptionDefaltValue("false");
            ARG_FOLLOW_MILLIS = new CommandLineArg("followmillis", false, new CommandLineArg.NumberOptionType(), "Time for the poll, when follow is on.");
            ARG_FOLLOW_MILLIS.setOptionDefaltValue("1000");
            ARG_FOLLOW_MILLIS.setHidden(true);
            ARG_XML = new CommandLineArg("xml", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_LOG_XML_FORMAT"));
            ARG_XML.setOptionDefaltValue("false");
            ARG_XML.setShortCut("x");
            ARG_AUTO_VIEW_LOGS = new CommandLineArg("viewlogs", false, new CommandLineArg.BooleanOptionType(), "Downloads all the job logs and displays. Applicable when grid is on.");
            ARG_AUTO_VIEW_LOGS.setOptionDefaltValue("false");
            ARG_AUTO_VIEW_LOGS.setShortCut("vl");
            ARG_AUTO_VIEW_LOGS.setHidden(true);
            ARG_TREE = new CommandLineArg("gridtree", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_PARAM_TREE"));
            ARG_TREE.setOptionDefaltValue("false");
            ARG_TREE.setHidden(true);
            ARG_LAST = new CommandLineArg("last", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_LAST", new Object[]{"unit", FetchApplicationLogRecordsExecutor.LAST.RECORDS, 100, "limit", "starttime"}));
            ARG_LAST.setShortCut("la");
            ARG_LAST.setPossibleEnumValues(CloudUtil.getEnumValuesAsList(FetchApplicationLogRecordsExecutor.LAST.class));
            ARG_LAST.setOptionDefaltValue(FetchApplicationLogRecordsExecutor.LAST.DAY.toString());
            ARG_LAST.setNullStringAllowed(true);
            ARG_UNIT = new CommandLineArg("unit", false, new CommandLineArg.NumberOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_UNIT", "last"));
            ARG_UNIT.setOptionDefaltValue("1");
            ARG_LIMIT = new CommandLineArg("limit", false, new CommandLineArg.NumberOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_PARAM_LIMIT"));
            ARG_TIMEOUT = new CommandLineArg("timeout", false, new CommandLineArg.NumberOptionType(), NLSUtil.localizeMessage("NLS_PARAM_PARAM_TIMEOUT"));
            ARG_TIMEOUT.setShortCut("to");
            ARG_TIMEOUT.setOptionDefaltValue("600");
            ARG_TIMEOUT.setNullStringAllowed(true);
            ARG_SORT_DESCENDING = new CommandLineArg("descending", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_SORT_DESCENDING", "sorton"));
            ARG_SORT_DESCENDING.setOptionDefaltValue("false");
            ARG_SORT_DESCENDING.setShortCut("desc");
            ARG_JOB_SORT_ON = new CommandLineArg("sorton", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_SORT_ON", new Object[]{"jobs", "descending"}));
            ARG_JOB_SORT_ON.setShortCut("so");
            ARG_JOB_SORT_ON.setPossibleEnumValues(CloudUtil.getEnumValuesAsList(JobComparator.FIELD.class));
            ARG_JOB_SORT_ON.setNullStringAllowed(true);
            ARG_APP_LOGS_SORT_ON = new CommandLineArg("sorton", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_SORT_ON", new Object[]{"log records", "descending"}));
            ARG_APP_LOGS_SORT_ON.setShortCut("so");
            ARG_APP_LOGS_SORT_ON.setPossibleEnumValues(CloudUtil.getEnumValuesAsList(LogRecordComparator.FIELD.class));
            ARG_APP_LOGS_SORT_ON.setNullStringAllowed(true);
            ARG_JOB_LOG_SORT_ON = new CommandLineArg("sorton", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_SORT_ON", new Object[]{"logs", "descending"}));
            ARG_JOB_LOG_SORT_ON.setShortCut("so");
            ARG_JOB_LOG_SORT_ON.setPossibleEnumValues(CloudUtil.getEnumValuesAsList(JobLogComparator.FIELD.class));
            ARG_JOB_LOG_SORT_ON.setNullStringAllowed(true);
            ARG_SERVER_SORT_ON = ARG_JOB_SORT_ON.simpleClone();
            ARG_SERVER_SORT_ON.setDescription(NLSUtil.localizeMessage("NLS_PARAM_DESC_SORT_ON", new Object[]{"servers", "descending"}));
            ARG_SERVER_SORT_ON.setPossibleEnumValues(CloudUtil.getEnumValuesAsList(ServerComparator.FIELD.class));
            ARG_SERVER_SORT_ON.setNullStringAllowed(true);
            ARG_APPLICATION_SORT_ON = ARG_JOB_SORT_ON.simpleClone();
            ARG_APPLICATION_SORT_ON.setDescription(NLSUtil.localizeMessage("NLS_PARAM_DESC_SORT_ON", new Object[]{"applications", "descending"}));
            ARG_APPLICATION_SORT_ON.setPossibleEnumValues(CloudUtil.getEnumValuesAsList(ApplicationComparator.FIELD.class));
            ARG_APPLICATION_SORT_ON.setNullStringAllowed(true);
            ARG_CERTIFICATE_SORT_ON = ARG_JOB_SORT_ON.simpleClone();
            ARG_CERTIFICATE_SORT_ON.setDescription(NLSUtil.localizeMessage("NLS_PARAM_DESC_SORT_ON", new Object[]{"certificates", "descending"}));
            ARG_CERTIFICATE_SORT_ON.setPossibleEnumValues(CloudUtil.getEnumValuesAsList(CertificateComparator.FIELD.class));
            ARG_CERTIFICATE_SORT_ON.setNullStringAllowed(true);
            ARG_LIBRARY_SORT_ON = ARG_JOB_SORT_ON.simpleClone();
            ARG_LIBRARY_SORT_ON.setDescription(NLSUtil.localizeMessage("NLS_PARAM_DESC_SORT_ON", new Object[]{"libraries", "descending"}));
            ARG_LIBRARY_SORT_ON.setPossibleEnumValues(CloudUtil.getEnumValuesAsList(LibraryComparator.FIELD.class));
            ARG_LIBRARY_SORT_ON.setNullStringAllowed(true);
            ARG_METRICS_SORT_ON = ARG_JOB_SORT_ON.simpleClone();
            ARG_METRICS_SORT_ON.setDescription(NLSUtil.localizeMessage("NLS_PARAM_DESC_SORT_ON", new Object[]{"metrics", "descending"}));
            ARG_METRICS_SORT_ON.setPossibleEnumValues(CloudUtil.getEnumValuesAsList(MetricComparator.FIELD.class));
            ARG_METRICS_SORT_ON.setNullStringAllowed(true);
            ARG_METRICS_GROUP_BY = new CommandLineArg("groupby", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_GROUP_BY"));
            ARG_METRICS_GROUP_BY.setShortCut("gb");
            ARG_METRICS_GROUP_BY.setPossibleEnumValues(CloudUtil.getEnumValuesAsList(ServiceBaseGridGroupByExecutor.GROUPBY.class));
            ARG_METRICS_GROUP_BY.setNullStringAllowed(true);
            ARG_SYS_PROPERTIES = new CommandLineArg("systemproperties", false, new CommandLineArg.PropertiesOptionType(), "The list of system properties. E.g) a=b,c=d ");
            ARG_SYS_PROPERTIES.setHidden(true);
            ARG_SYS_PROPERTIES.setShortCut("sys");
            ARG_SYS_PROPERTIES.setAdvancedOption(true);
            ARG_SYS_PROPERTIES.setNullStringAllowed(true);
            ARG_PROVIDER_PROPERTIES = new CommandLineArg("providerproperties", false, new CommandLineArg.PropertiesOptionType(), NLSUtil.localizeMessage("NLS_PARAM_PROVIDER_PROPERTIES"));
            ARG_PROVIDER_PROPERTIES.setHidden(true);
            ARG_PROVIDER_PROPERTIES.setShortCut("pp");
            ARG_PROVIDER_PROPERTIES.setAdvancedOption(true);
            ARG_PROVIDER_PROPERTIES.setNullStringAllowed(true);
            ARG_HTTP_PROXY = new CommandLineArg("httpproxy", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_HTTP_PROXY", new Object[]{"adminurl"}));
            ARG_HTTP_PROXY.setShortCut("hp");
            ARG_HTTP_PROXY.setNullStringAllowed(true);
            ARG_WEB_MODULE_URI = new CommandLineArg("moduleuri", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_WEB_MODULE_URI"));
            ARG_WEB_MODULE_URI.setShortCut("uri");
            ARG_WORK_MANAGER_NAME = new CommandLineArg("workmanager", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_WORK_MANAGER_NAME"));
            ARG_WORK_MANAGER_NAME.setShortCut("wm");
            ARG_NO_HTTP_PROXY = new CommandLineArg("nohttpproxy", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_NO_HTTP_PROXY", new Object[]{"adminurl", "httpproxy", "httpproxy"}));
            ARG_NO_HTTP_PROXY.setShortCut("nhp");
            ARG_NO_HTTP_PROXY.setOptionDefaltValue("false");
            ARG_NO_HTTP_PROXY.setAdvancedOption(true);
            ARG_ADMIN_URL = new CommandLineArg("adminurl", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_ADMIN_URL", "datacenter", DEF_ADMIN_URL_FORMAT));
            ARG_ADMIN_URL.setNullStringAllowed(true);
            ARG_ADMIN_URL.setAdvancedOption(true);
            ARG_DATA_CENTER = new CommandLineArg("datacenter", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_PARAM_DATA_CENTER", new Object[]{"adminurl"}));
            ARG_DATA_CENTER.setShortCut("dc");
            ARG_DATA_CENTER.setPossibleEnumValues(CloudUtil.getEnumValuesAsList(BaseExecutor.DATACENTER.class, null, true));
            ARG_DATA_CENTER.setOptionDefaltValue(BaseExecutor.DATACENTER.us1.toString());
            ARG_DATA_CENTER.setAdvancedOption(true);
            ARG_USER = new CommandLineArg("user", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_USER"));
            ARG_DESC = new CommandLineArg("description", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESCRIPTION", "credential"));
            ARG_PWD = new CommandLineArg("password", true, new CommandLineArg.PasswordType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_PWD", "user"));
            ARG_LOCAL = new CommandLineArg("local", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_LOCAL", new Object[]{"adminurl", "identitydomain", "serviceinstance", "classpath"}));
            ARG_LOCAL.setOptionDefaltValue("false");
            ARG_LOCAL.setAdvancedOption(true);
            ARG_LOCAL_HIDDEN = ARG_LOCAL.simpleClone();
            ARG_LOCAL_HIDDEN.setHidden(true);
            ARG_ADMIN_STATE = new CommandLineArg("adminstate", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_ADMIN_STATE"));
            ARG_ADMIN_STATE.setOptionDefaltValue("false");
            ARG_ADMIN_STATE.setShortCut("as");
            ARG_ADMIN_STATE.setHidden(true);
            ARG_ACP = new CommandLineArg("classpath", false, new CommandLineArg.FileOptionType(CommandLineArg.CardinalityEnum.many, File.pathSeparator, null, true, true), NLSUtil.localizeMessage("NLS_PARAM_DESC_CLASSPATH", new String[]{"local", JAR_CLOCAL_LOUD9_NAME}));
            ARG_ACP.setShortCut("cp");
            ARG_ACP.setOptionDefaltValue(System.getenv("CLASSPATH"));
            ARG_ACP.setNullStringAllowed(true);
            ARG_ACP.setAdvancedOption(true);
            CommandLineArg ARG_ACP_FOR_COMMON = ARG_ACP.simpleClone();
            ARG_ACP_FOR_COMMON.setHidden(true);
            ARG_SERVICE_GROUP = new CommandLineArg("identitydomain", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_SYS_NAME"));
            ARG_SERVICE_GROUP.setShortCut("id");
            ARG_LOG_NAME = new CommandLineArg("log", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_LOG_NAME"));
            ARG_GREP = new CommandLineArg("search", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_PARAM_GREP"));
            ARG_GREP.setOptionDefaltValue("");
            ARG_GREP.setNullStringAllowed(true);
            ARG_MAP = new CommandLineArg("map", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_MAP_NAME"));
            ARG_MAP.setOptionDefaltValue("oracle.wsm.security");
            ARG_MAP.setHidden(true);
            ARG_KEY = new CommandLineArg("key", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_KEY_NAME"));
            ARG_KEY_USER = new CommandLineArg("keyuser", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_KEY_USER"));
            ARG_ALIAS = new CommandLineArg("alias", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.many, null, null), NLSUtil.localizeMessage("NLS_PARAM_ALIAS", "certfiletype"));
            ARG_ALIAS_MANDATORY = ARG_ALIAS.simpleClone();
            ARG_ALIAS_MANDATORY.setDescription(NLSUtil.localizeMessage("NLS_PARAM_ALIAS_MANDATORY"));
            ARG_ALIAS_MANDATORY.setMandatory(true);
            ARG_CERT_FILE_TYPE = new CommandLineArg("certfiletype", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_CERT_FILE_TYPE", "path"));
            ARG_CERT_FILE_TYPE.setPossibleEnumValues(CloudUtil.getEnumValuesAsList(CommonGetCertificates.CERT_TYPE.class));
            ARG_CERT_FILE_TYPE.setShortCut("cft");
            ARG_CERT_FILE_TYPE_OUTPUT = ARG_CERT_FILE_TYPE.simpleClone();
            ARG_CERT_FILE_TYPE_OUTPUT.setDescription(NLSUtil.localizeMessage("NLS_PARAM_CERT_FILE_TYPE_OUTPUT", "output"));
            ARG_KEY_USER.setShortCut("ku");
            ARG_KEY_PWD = new CommandLineArg("keypassword", true, new CommandLineArg.PasswordType(), NLSUtil.localizeMessage("NLS_PARAM_KEY_PWD"));
            ARG_KEY_PWD.setShortCut("kp");
            ARG_OUTPUT = new CommandLineArg("output", false, new CommandLineArg.FileOptionType(CommandLineArg.CardinalityEnum.one, null, null, true, true), NLSUtil.localizeMessage("NLS_PARAM_LOG_FETCH_OUTPUT", "log"));
            ARG_OUTPUT.setOptionDefaltValue("./");
            ARG_DS_NAME = new CommandLineArg("datasource", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DS_NAME"));
            ARG_DS_NAME.setShortCut("ds");
            ARG_DS_NAME.setMandatory(false);
            ARG_JNDI_NAME = new CommandLineArg("jndiname", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_JNDI_NAME"));
            ARG_JNDI_NAME.setShortCut("jn");
            appName = new CommandLineArg("application", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_APP_NAME"));
            appName.setShortCut("app");
            CommandLineArg apptype = new CommandLineArg("applicationtype", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_APP_TYPE", new Object[]{"path"}));
            apptype.setShortCut("at");
            apptype.setPossibleEnumValues(CloudUtil.getEnumValuesAsList(ApplicationType.class));
            apptype.setNullStringAllowed(true);
            ARG_SERVICE_INSTANCE = new CommandLineArg("serviceinstance", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_SVC_NAME", "identitydomain"));
            ARG_SERVICE_INSTANCE.setShortCut("si");
            ARG_SHELL_COMMAND = new CommandLineArg("command", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_PARAM_COMMAND", "autoexitonfailure"));
            ARG_SHELL_COMMAND.setShortCut("c");
            ARG_SHELL_COMMAND.setNullStringAllowed(true);
            ARG_SHELL_AUTO_EXIT = new CommandLineArg("autoexitonfailure", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_ATUO_EXIT_FAILURE", "command"));
            ARG_SHELL_AUTO_EXIT.setShortCut("ax");
            ARG_SHELL_AUTO_EXIT.setOptionDefaltValue("false");
            ARG_SHELL_VALIDATE_SPECIAL_CHARS = new CommandLineArg("validatespecialchars", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_VALIDATE_SPECIAL_CHARS", new String(FSShell.not_allowed_chars)));
            ARG_SHELL_VALIDATE_SPECIAL_CHARS.setShortCut("val");
            ARG_SHELL_VALIDATE_SPECIAL_CHARS.setOptionDefaltValue("true");
            ARG_STRIPE_NAME = new CommandLineArg("stripe", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_STRIPE_NAME", "stripe"));
            ARG_STRIPE_NAME.setShortCut("sn");
            ARG_STRIPE_NAME.setHidden(true);
            ARG_KEYSTORE_NAME = new CommandLineArg("keystore", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_KEYSTORE_NAME", "keystore"));
            ARG_KEYSTORE_NAME.setShortCut("ks");
            ARG_KEYSTORE_NAME.setHidden(true);
            ARG_KEYSTORE_PWD = new CommandLineArg("storepassword", false, new CommandLineArg.PasswordType(), NLSUtil.localizeMessage("NLS_PARAM_KEYSTORE_PWD"));
            ARG_KEYSTORE_PWD.setHidden(true);
            CommandLineArg path = new CommandLineArg("path", true, new CommandLineArg.FileOptionType(CommandLineArg.CardinalityEnum.one, null, null, false, true), NLSUtil.localizeMessage("NLS_PARAM_DESC_ARCHIVE_LOC"));
            CommandLineArg certpath = new CommandLineArg("path", true, new CommandLineArg.FileOptionType(CommandLineArg.CardinalityEnum.one, null, null, false, true), NLSUtil.localizeMessage("NLS_PARAM_PATH_CERTIFICATE", "certfiletype"));
            CommandLineArg optionalPath = new CommandLineArg("path", false, new CommandLineArg.FileOptionType(CommandLineArg.CardinalityEnum.one, null, null, false, true), NLSUtil.localizeMessage("NLS_PARAM_DESC_ARCHIVE_LOC"));
            CommandLineArg libPath = new CommandLineArg("path", true, new CommandLineArg.FileOptionType(CommandLineArg.CardinalityEnum.one, null, null, false, true), NLSUtil.localizeMessage("NLS_PARAM_DESC_LIB_ARCHIVE_LOC"));
            fullFormat = new CommandLineArg("verbose", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_FULL_FORMAT"));
            fullFormat.setOptionDefaltValue("false");
            CommandLineArg grid = new CommandLineArg("grid", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_GRID_DISPLAY"));
            grid.setOptionDefaltValue("false");
            gridwidth = new CommandLineArg("gridwidth", false, new CommandLineArg.NumberOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_GRID_WIDTH", "grid"));
            gridwidth.setOptionDefaltValue(String.valueOf(180));
            gridwidth.setShortCut("gw");
            CommandLineArg libName = new CommandLineArg("library", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_LIB_NAME"));
            libName.setShortCut("lib");
            CommandLineArg libType = new CommandLineArg("librarytype", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_LIB_TYPE", new Object[]{"path"}));
            libType.setShortCut("t");
            libType.setPossibleEnumValues(CloudUtil.getEnumValuesAsList(LibraryType.class));
            libType.setNullStringAllowed(true);
            CommandLineArg libDeployType = new CommandLineArg("librarydeploytype", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_LIB_DEPLOY_TYPE", new Object[]{"path"}));
            libDeployType.setShortCut("dt");
            libDeployType.setPossibleEnumValues(CloudUtil.getEnumValuesAsList(LibraryDeployType.class));
            libDeployType.setNullStringAllowed(true);
            CommandLineArg specVersion = new CommandLineArg("specversion", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_LIB_SPEC_VERSION"));
            specVersion.setShortCut("sv");
            CommandLineArg implVersion = new CommandLineArg("implversion", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_LIB_IMPL_VERSION"));
            implVersion.setShortCut("iv");
            Main main = new Main();
            MainBase.setMain(main);
            CommandLine command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("install");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_INSTALL_DESC", "install-library"));
            command.setCliProvider(new CliExecutorProvider<InstallApplication>(InstallApplication.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            CommandLineArg app_from_path = appName.simpleClone();
            app_from_path.setMandatory(false);
            app_from_path.setNullStringAllowed(true);
            app_from_path.setDescription(NLSUtil.localizeMessage("NLS_PARAM_DESC_APPLICATION_INSTALL", "path"));
            command.addArg(app_from_path);
            command.addArg(path);
            command.addArg(apptype);
            command.addArg(ARG_ADMIN_STATE);
            command.addArg(ARG_LOCAL);
            command.addArg(ARG_ACP);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("delete");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_UNINSTALL_DESC"));
            command.setCliProvider(new CliExecutorProvider<UninstallApplication>(UninstallApplication.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(appName);
            command.addArg(ARG_LOCAL);
            command.addArg(ARG_ACP);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("update");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_UPDATE_DESC"));
            command.setCliProvider(new CliExecutorProvider<UpdateApplication>(UpdateApplication.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(app_from_path);
            command.addArg(path);
            command.addArg(ARG_ADMIN_STATE);
            command.addArg(ARG_LOCAL);
            command.addArg(ARG_ACP);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("start");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_START_DESC"));
            command.setCliProvider(new CliExecutorProvider<StartApplication>(StartApplication.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_ADMIN_STATE);
            command.addArg(appName);
            command.addArg(ARG_LOCAL);
            command.addArg(ARG_ACP);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("stop");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_STOP_DESC"));
            command.setCliProvider(new CliExecutorProvider<StopApplication>(StopApplication.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_ADMIN_STATE);
            command.addArg(appName);
            command.addArg(ARG_LOCAL);
            command.addArg(ARG_ACP);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("list-jobs");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_LIST_JOBS_DESC", new Object[]{"serviceinstance", "application"}));
            command.setCliProvider(new CliExecutorProvider<ListJobs>(ListJobs.class));
            CommandLineArg service1 = ARG_SERVICE_INSTANCE.simpleClone();
            service1.setMandatory(false);
            service1.setNullStringAllowed(true);
            command.addArg(service1);
            CommandLineArg ap1 = appName.simpleClone();
            ap1.setMandatory(false);
            ap1.setNullStringAllowed(true);
            ap1.setDescription(NLSUtil.localizeMessage("NLS_PARAM_DESC_APPLICATIONS"));
            ap1.setOptionType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.many, ",", null));
            command.addArg(ap1);
            command.addArg(ARG_STATUS);
            command.addArg(ARG_LIMIT);
            command.addArg(fullFormat);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.addArg(ARG_LOCAL);
            command.addArg(ARG_ACP);
            command.addArg(ARG_JOB_SORT_ON);
            command.addArg(ARG_SORT_DESCENDING);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("job-status");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_DESCRIBE_JOBS_DESC"));
            command.setCliProvider(new CliExecutorProvider<DescribeJob>(DescribeJob.class));
            command.addArg(new CommandLineArg("jobid", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_JOB_ID")));
            command.addArg(ARG_LOCAL);
            command.addArg(ARG_ACP);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("list-job-logs");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_LIST_JOB_LOGS_DESC"));
            command.setCliProvider(new CliExecutorProvider<ListJobLogs>(ListJobLogs.class));
            command.addArg(new CommandLineArg("jobid", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_JOB_ID")));
            command.addArg(fullFormat);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.addArg(ARG_LOCAL);
            command.addArg(ARG_ACP);
            command.addArg(ARG_JOB_LOG_SORT_ON);
            command.addArg(ARG_SORT_DESCENDING);
            command.addArg(ARG_AUTO_VIEW_LOGS);
            command.updateShortCut();
            Main.addCommandLine(command);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("job-log-file");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_FETCH_JOB_LOG"));
            command.setCliProvider(new CliExecutorProvider<FetchJobLog>(FetchJobLog.class));
            command.addArg(new CommandLineArg("jobid", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_DESC_JOB_ID")));
            command.addArg(ARG_LOG_NAME);
            command.addArg(ARG_OUTPUT);
            command.addArg(ARG_LOCAL);
            command.addArg(ARG_ACP);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("list-applications");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_LIST_APPS"));
            command.setCliProvider(new CliExecutorProvider<ListApplications>(ListApplications.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_LOCAL);
            command.addArg(ARG_ACP);
            command.addArg(fullFormat);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.addArg(ARG_APPLICATION_SORT_ON);
            command.addArg(ARG_SORT_DESCENDING);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("describe-application");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_DESCRIBE_APP", "query-service-metrics"));
            command.setCliProvider(new CliExecutorProvider<DescribeApplication>(DescribeApplication.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_LOCAL);
            command.addArg(ARG_ACP);
            command.addArg(appName);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("query-service-logs");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_DESC_GET_APP_LOGS", new String[]{"last,unit", "starttime,endtime", "limit"}));
            command.setCliProvider(new CliExecutorProvider<FetchApplicationLogRecordsExecutor>(FetchApplicationLogRecordsExecutor.class));
            CommandLineArg service2 = ARG_SERVICE_INSTANCE.simpleClone();
            service2.setMandatory(true);
            CommandLineArg outlogrecords = ARG_OUTPUT.simpleClone();
            outlogrecords.setNullStringAllowed(true);
            outlogrecords.setDescription(NLSUtil.localizeMessage("NLS_PARAM_APP_LOG_RECORD_FETCH_OUTPUT", "log_identitydomain_serviceinstance.log"));
            outlogrecords.setOptionDefaltValue(null);
            command.addArg(outlogrecords);
            command.addArg(ARG_XML);
            command.addArg(service2);
            CommandLineArg ap2 = appName.simpleClone();
            ap2.setMandatory(false);
            ap2.setNullStringAllowed(true);
            ap2.setDescription(NLSUtil.localizeMessage("NLS_PARAM_DESC_APPLICATIONS"));
            ap2.setOptionType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.many, ",", null));
            command.addArg(ap2);
            command.addArg(ARG_SEVERITY);
            command.addArg(ARG_CONTAINS);
            command.addArg(ARG_CONTAINS_SEPERATOR);
            command.addArg(ARG_LAST);
            command.addArg(ARG_UNIT);
            command.addArg(ARG_START_TIME);
            command.addArg(ARG_END_TIME);
            command.addArg(ARG_DATE_FORMAT);
            command.addArg(ARG_LIMIT);
            command.addArg(ARG_FOLLOW);
            command.addArg(ARG_FOLLOW_MILLIS);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.addArg(fullFormat);
            command.addArg(ARG_LOCAL);
            command.addArg(ARG_ACP);
            command.addArg(ARG_APP_LOGS_SORT_ON);
            command.addArg(ARG_SORT_DESCENDING);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = LibraryBaseExecutor.getBaseCommandLine();
            command.setCommandName("list-libraries");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_LIST_LIBS"));
            command.setCliProvider(new CliExecutorProvider<ListLibraries>(ListLibraries.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_ACP);
            command.addArg(fullFormat);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.addArg(ARG_LIBRARY_SORT_ON);
            command.addArg(ARG_SORT_DESCENDING);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = LibraryBaseExecutor.getBaseCommandLine();
            command.setCommandName("describe-library");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_DESCRIBE_LIB", "query-service-metrics"));
            command.setCliProvider(new CliExecutorProvider<DescribeLibrary>(DescribeLibrary.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_ACP);
            CommandLineArg lbName = libName.simpleClone();
            lbName.setNullStringAllowed(false);
            lbName.setMandatory(true);
            command.addArg(lbName);
            CommandLineArg lbSpec = specVersion.simpleClone();
            lbSpec.setNullStringAllowed(false);
            lbSpec.setMandatory(true);
            command.addArg(lbSpec);
            CommandLineArg lbImpl = implVersion.simpleClone();
            lbImpl.setNullStringAllowed(false);
            lbImpl.setMandatory(true);
            command.addArg(lbImpl);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = LibraryBaseExecutor.getBaseCommandLine();
            command.setCommandName("install-library");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_INSTALL_LIB"));
            command.setCliProvider(new CliExecutorProvider<InstallLibrary>(InstallLibrary.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(libPath);
            command.addArg(libName);
            command.addArg(specVersion);
            command.addArg(implVersion);
            command.addArg(libType);
            command.addArg(ARG_ACP);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = LibraryBaseExecutor.getBaseCommandLine();
            command.setCommandName("update-library");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_UPDATE_DESC_LIBRARY"));
            command.setCliProvider(new CliExecutorProvider<UpdateLibrary>(UpdateLibrary.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(libName);
            command.addArg(path);
            command.addArg(specVersion);
            command.addArg(implVersion);
            command.addArg(libType);
            command.addArg(ARG_ACP);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = LibraryBaseExecutor.getBaseCommandLine();
            command.setCommandName("delete-library");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_UNINSTALL_DESC_LIBRARY"));
            command.setCliProvider(new CliExecutorProvider<UninstallLibrary>(UninstallLibrary.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(lbName);
            command.addArg(lbSpec);
            command.addArg(lbImpl);
            command.addArg(ARG_ACP);
            command.addArg(ARG_FORCE);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("query-service-metrics");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_COMMAND_LIST_SERVICE_METRICS"));
            command.setCliProvider(new CliExecutorProvider<ListServiceMetrics>(ListServiceMetrics.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            CommandLineArg ap0 = appName.simpleClone();
            ap0.setNullStringAllowed(true);
            ap0.setMandatory(false);
            command.addArg(ap0);
            command.addArg(ARG_LOCAL);
            command.addArg(ARG_ACP);
            command.addArg(ARG_METRICS_GROUP_BY);
            command.addArg(fullFormat);
            command.addArg(ARG_TREE);
            command.addArg(gridwidth);
            command.addArg(ARG_METRICS_SORT_ON);
            command.addArg(ARG_SORT_DESCENDING);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("list-credential-maps");
            command.setDescription(NLSUtil.localizeMessage("NLs_COMMAND_LIST_CREDENTIAL_MAPS"));
            command.setCliProvider(new CliExecutorProvider<ListCredentialMaps>(ListCredentialMaps.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.addArg(fullFormat);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.updateShortCut();
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("list-credentials");
            command.setDescription(NLSUtil.localizeMessage("NLs_COMMAND_LIST_CREDENTIALS"));
            command.setCliProvider(new CliExecutorProvider<ListCredentials>(ListCredentials.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_MAP);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.addArg(fullFormat);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("describe-credential");
            command.setDescription(NLSUtil.localizeMessage("NLs_COMMAND_DESCRIBE_CREDENTIAL"));
            command.setCliProvider(new CliExecutorProvider<DescribeCredential>(DescribeCredential.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_MAP);
            command.addArg(ARG_KEY);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("set-credential");
            command.setDescription(NLSUtil.localizeMessage("NLs_COMMAND_SET_CREDENTIAL"));
            command.setCliProvider(new CliExecutorProvider<SetCredential>(SetCredential.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_MAP);
            command.addArg(ARG_KEY);
            command.addArg(ARG_DESC);
            command.addArg(ARG_KEY_USER);
            command.addArg(ARG_KEY_PWD);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("delete-credential");
            command.setDescription(NLSUtil.localizeMessage("NLs_COMMAND_DELETE_CREDENTIAL"));
            command.setCliProvider(new CliExecutorProvider<DeleteCredential>(DeleteCredential.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_MAP);
            command.addArg(ARG_KEY);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("reset-ssl-certificate-store");
            command.setDescription(NLSUtil.localizeMessage("NLS_COMMAND_RESET_SSL_TRUST_STORE"));
            command.setCliProvider(new CliExecutorProvider<oracle.cloud.paas.client.cli.command.common.ssl.trust.ResetStore>(oracle.cloud.paas.client.cli.command.common.ssl.trust.ResetStore.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("list-ssl-certificates");
            command.setDescription(NLSUtil.localizeMessage("NLS_COMMAND_LIST_SSL_CERTS"));
            command.setCliProvider(new CliExecutorProvider<oracle.cloud.paas.client.cli.command.common.ssl.trust.ListCertificates>(oracle.cloud.paas.client.cli.command.common.ssl.trust.ListCertificates.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.addArg(fullFormat);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.addArg(ARG_CERTIFICATE_SORT_ON);
            command.addArg(ARG_SORT_DESCENDING);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("add-ssl-certificates");
            command.setDescription(NLSUtil.localizeMessage("NLS_COMMAND_ADD_SSL_CERT"));
            command.setCliProvider(new CliExecutorProvider<oracle.cloud.paas.client.cli.command.common.ssl.trust.AddCertificate>(oracle.cloud.paas.client.cli.command.common.ssl.trust.AddCertificate.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_ALIAS);
            command.addArg(certpath);
            command.addArg(ARG_KEYSTORE_PWD);
            command.addArg(ARG_CERT_FILE_TYPE);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("delete-ssl-certificates");
            command.setDescription(NLSUtil.localizeMessage("NLS_COMMAND_DELETE_SSL_CERT"));
            command.setCliProvider(new CliExecutorProvider<DeleteCertificate>(DeleteCertificate.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_ALIAS_MANDATORY);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("download-ssl-certificates");
            command.setDescription(NLSUtil.localizeMessage("NLS_COMMAND_DOWNLOAD_SSL_CERT"));
            command.setCliProvider(new CliExecutorProvider<oracle.cloud.paas.client.cli.command.common.ssl.trust.GetCertificate>(oracle.cloud.paas.client.cli.command.common.ssl.trust.GetCertificate.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_ALIAS);
            CommandLineArg downloadcert = ARG_OUTPUT.simpleClone();
            downloadcert.setNullStringAllowed(true);
            downloadcert.setDescription(NLSUtil.localizeMessage("NLS_PARAM_CERT_DOWNLOAD_OUTPUT", "alias", "certfiletype"));
            command.addArg(downloadcert);
            command.addArg(ARG_CERT_FILE_TYPE_OUTPUT);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("reset-wss-certificate-store");
            command.setDescription(NLSUtil.localizeMessage("NLS_COMMAND_RESET_OWSM_TRUST_STORE"));
            command.setCliProvider(new CliExecutorProvider<ResetStore>(ResetStore.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.addArg(ARG_STRIPE_NAME);
            command.addArg(ARG_KEYSTORE_NAME);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("list-wss-certificates");
            command.setDescription(NLSUtil.localizeMessage("NLS_COMMAND_LIST_OWSM_CERTS"));
            command.setCliProvider(new CliExecutorProvider<ListCertificates>(ListCertificates.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.addArg(fullFormat);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.addArg(ARG_STRIPE_NAME);
            command.addArg(ARG_KEYSTORE_NAME);
            command.addArg(ARG_CERTIFICATE_SORT_ON);
            command.addArg(ARG_SORT_DESCENDING);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("add-wss-certificates");
            command.setDescription(NLSUtil.localizeMessage("NLS_COMMAND_ADD_OWSM_CERT"));
            command.setCliProvider(new CliExecutorProvider<AddCertificate>(AddCertificate.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_ALIAS);
            command.addArg(certpath);
            command.addArg(ARG_KEYSTORE_PWD);
            command.addArg(ARG_CERT_FILE_TYPE);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.addArg(ARG_STRIPE_NAME);
            command.addArg(ARG_KEYSTORE_NAME);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("delete-wss-certificates");
            command.setDescription(NLSUtil.localizeMessage("NLS_COMMAND_DELETE_OWSM_CERT"));
            command.setCliProvider(new CliExecutorProvider<oracle.cloud.paas.client.cli.command.common.owsm.trust.DeleteCertificate>(oracle.cloud.paas.client.cli.command.common.owsm.trust.DeleteCertificate.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_ALIAS_MANDATORY);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.addArg(ARG_STRIPE_NAME);
            command.addArg(ARG_KEYSTORE_NAME);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("download-wss-certificates");
            command.setDescription(NLSUtil.localizeMessage("NLS_COMMAND_DOWNLOAD_OWSM_CERT"));
            command.setCliProvider(new CliExecutorProvider<GetCertificate>(GetCertificate.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_ALIAS);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.addArg(ARG_STRIPE_NAME);
            command.addArg(ARG_KEYSTORE_NAME);
            command.addArg(downloadcert);
            command.addArg(ARG_CERT_FILE_TYPE_OUTPUT);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("list-service-instances");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_LIST_SERVICE_INSTANCES"));
            command.setCliProvider(new CliExecutorProvider<ListServiceInstances>(ListServiceInstances.class));
            command.addArg(ARG_LOCAL);
            command.addArg(ARG_ACP);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.addArg(fullFormat);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("describe-service-instance");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_DESC_SERVICE_INSTANCE"));
            command.setCliProvider(new CliExecutorProvider<DescribeServiceInstance>(DescribeServiceInstance.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_LOCAL);
            command.addArg(ARG_ACP);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("restart-service-instance");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_RESTART_SERVICE_INSTANCE"));
            command.setCliProvider(new CliExecutorProvider<RestartServiceInstanceExecutor>(RestartServiceInstanceExecutor.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_TIMEOUT);
            command.addArg(ARG_FORCE);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.addArg(ARG_LOCAL_HIDDEN);
            command.updateShortCut();
            command.addArg(ARG_ACP_FOR_COMMON);
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("fs-shell");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_COMMAND_FILE_SYSTEM_SHELL", new String(FSShell.not_allowed_chars), "validatespecialchars"));
            command.setCliProvider(new CliExecutorProvider<FSShell>(FSShell.class));
            command.addCommandAlias("fs");
            command.addArg(ARG_ACP_FOR_COMMON);
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_SHELL_COMMAND);
            command.addArg(ARG_SHELL_AUTO_EXIT);
            command.addArg(ARG_SHELL_VALIDATE_SPECIAL_CHARS);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("config-shell");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_COMMAND_WLST_SHELL"));
            command.setCliProvider(new CliExecutorProvider<WLSTShell>(WLSTShell.class));
            command.addArg(ARG_ACP_FOR_COMMON);
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_SHELL_COMMAND);
            command.addArg(ARG_SHELL_AUTO_EXIT);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("usage");
            command.setCliProvider(new CliExecutorProvider<HtmlUsagePageGenerator>(HtmlUsagePageGenerator.class));
            command.setDescription(NLSUtil.localizeMessage("COMMAND_DESCR_USAGE", HtmlUsagePageGenerator.FILE_NAME));
            command.addArg(new CommandLineArg("output", false, (CommandLineArg.OptionType)new CommandLineArg.FileOptionType(CommandLineArg.CardinalityEnum.one, null, null, true, true), NLSUtil.localizeMessage("PARAM_DESCR_OUTPUT"), NLSUtil.localizeMessage("PARAM_MSG_OUTDIR")));
            CommandLineArg xml = new CommandLineArg("xml", false, new CommandLineArg.BooleanOptionType(), "When true, the help is printed as xml doc.");
            xml.setOptionDefaltValue("false");
            xml.setShortCut("x");
            xml.setHidden(true);
            command.addArg(xml);
            CommandLineArg fs = new CommandLineArg("fsdoc", false, new CommandLineArg.BooleanOptionType(), "When true, document is printed for file system commands.");
            fs.setOptionDefaltValue("false");
            fs.setHidden(true);
            command.addArg(fs);
            CommandLineArg appconfig = new CommandLineArg("appconfigdoc", false, new CommandLineArg.BooleanOptionType(), "When true, document is printed for application configuration commands.");
            appconfig.setOptionDefaltValue("false");
            appconfig.setHidden(true);
            command.addArg(appconfig);
            command.addHelp();
            command.updateShortCut();
            Main.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("version");
            command.setDescription(NLSUtil.localizeMessage("COMMAND_DESCR_VERSION"));
            command.setCliProvider(new CliExecutorProvider<VersionProvider>(VersionProvider.class));
            command.addHelp();
            command.updateShortCut();
            Main.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("list-commands");
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_COMMAND_LIST_COMMANDS_DESC", "search"));
            command.setCliProvider(new CliExecutorProvider<ListCommands>(ListCommands.class, MainBase.class, main));
            command.addArg(ARG_GREP);
            command.addArg(fullFormat);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.addHelp();
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("list-datasource-jndinames");
            command.setDescription(NLSUtil.localizeMessage("NLS_COMMAND_LIST_DS_JNDINAMES"));
            command.setCliProvider(new CliExecutorProvider<ListDSJndiNames>(ListDSJndiNames.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_DS_NAME);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.addArg(fullFormat);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("add-datasource-jndiname");
            command.setDescription(NLSUtil.localizeMessage("NLS_COMMAND_ADD_DS_JNDINAME"));
            command.setCliProvider(new CliExecutorProvider<AddDSJndiName>(AddDSJndiName.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_DS_NAME);
            command.addArg(ARG_JNDI_NAME);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.addArg(fullFormat);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.updateShortCut();
            Main.addCommandLine(command);
            command = ApplicationBaseExecutor.getBaseCommandLine();
            command.setCommandName("delete-datasource-jndiname");
            command.setDescription(NLSUtil.localizeMessage("NLS_COMMAND_DELETE_DS_JNDINAME"));
            command.setCliProvider(new CliExecutorProvider<DeleteDSJndiName>(DeleteDSJndiName.class));
            command.addArg(ARG_SERVICE_INSTANCE);
            command.addArg(ARG_DS_NAME);
            command.addArg(ARG_JNDI_NAME);
            command.addArg(ARG_FORCE);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.addArg(fullFormat);
            command.addArg(ARG_ACP_FOR_COMMON);
            command.updateShortCut();
            Main.addCommandLine(command);
            main.defaultCommand = "list-commands";
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.getDEFAULT().printlnThrowable(e);
        }
    }
}

