/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.templating.velocity.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class DirectiveRegistry {
    private static DirectiveRegistry _instance = null;
    private Map<String, Bundle> _classBundleMap = new HashMap<String, Bundle>();
    public static final String DIRECTIVES_EXTENSION_POINT_ID = "oracle.eclipse.tools.common.templating.velocity.directives";
    public static final String ELEMENT_DIRECTIVE = "directive";
    public static final String ELEMENTATTR_DIRECTIVE_CLASS = "class";

    private DirectiveRegistry() {
        IConfigurationElement[] directives;
        IExtensionRegistry extensionReg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = directives = extensionReg.getConfigurationElementsFor(DIRECTIVES_EXTENSION_POINT_ID);
        int n = directives.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement nextElement = iConfigurationElementArray[n2];
            String elementName = nextElement.getName();
            if (elementName.equals(ELEMENT_DIRECTIVE)) {
                this.registerDirective(nextElement);
            }
            ++n2;
        }
    }

    public static DirectiveRegistry get() {
        if (_instance == null) {
            _instance = new DirectiveRegistry();
        }
        return _instance;
    }

    public static Set<String> getUserDirectives() {
        return DirectiveRegistry.get()._classBundleMap.keySet();
    }

    private void registerDirective(IConfigurationElement directiveElement) {
        String directiveClass = directiveElement.getAttribute(ELEMENTATTR_DIRECTIVE_CLASS);
        String pluginID = directiveElement.getDeclaringExtension().getNamespace();
        Bundle bundle = Platform.getBundle((String)pluginID);
        assert (!this._classBundleMap.containsKey(directiveClass)) : "A directive with class name (" + directiveClass + ") has already been defined";
        this._classBundleMap.put(directiveClass, bundle);
    }
}

