/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.templating.velocity.logging;

import oracle.eclipse.tools.common.templating.velocity.BEAVelocityPlugin;
import oracle.eclipse.tools.common.util.ResourceLoader;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogSystem;
import org.eclipse.core.runtime.Plugin;

public class MessageServiceLogSystem
implements LogSystem {
    private static final ResourceLoader _resourceLoader = new ResourceLoader(MessageServiceLogSystem.class);
    private static final String VELOCITY_OUTPUT = "=VELOCITY=> ";
    public static final String OPTION_VTL_DEBUG = "/logging/vtl/debug";
    public static final String OPTION_VTL_INFO = "/logging/vtl/info";
    public static final String OPTION_VTL_WARNING = "/logging/vtl/warning";
    public static final String OPTION_VTL_ERROR = "/logging/vtl/error";

    public MessageServiceLogSystem() {
        LoggingService.logDebug((Plugin)BEAVelocityPlugin.getDefault(), (String)"=VELOCITY=> Initializing Velocity's LoggingService...");
    }

    private void checkAndLogDebug(Plugin plugin, String message) {
        if (LoggingService.isOptionEnabled((Plugin)plugin, (String)OPTION_VTL_DEBUG)) {
            LoggingService.logDebug((Plugin)plugin, (String)message);
        }
    }

    private void checkAndLogInfo(Plugin plugin, String message) {
        if (LoggingService.isOptionEnabled((Plugin)plugin, (String)OPTION_VTL_INFO)) {
            LoggingService.logInfo((Plugin)plugin, (String)message);
        }
    }

    private void checkAndLogWarning(Plugin plugin, String message) {
        if (LoggingService.isOptionEnabled((Plugin)plugin, (String)OPTION_VTL_WARNING)) {
            LoggingService.logWarning((Plugin)plugin, (String)message);
        }
    }

    private void checkAndLogError(Plugin plugin, String message) {
        if (LoggingService.isOptionEnabled((Plugin)plugin, (String)OPTION_VTL_ERROR)) {
            LoggingService.logError((Plugin)plugin, (String)message);
        }
    }

    @Override
    public void init(RuntimeServices runtime) {
    }

    @Override
    public void logVelocityMessage(int level, String message) {
        String modifedMessage = VELOCITY_OUTPUT + message;
        BEAVelocityPlugin plugin = BEAVelocityPlugin.getDefault();
        switch (level) {
            case 0: {
                this.checkAndLogDebug(plugin, modifedMessage);
                break;
            }
            case 1: {
                this.checkAndLogInfo(plugin, modifedMessage);
                break;
            }
            case 2: {
                this.checkAndLogWarning(plugin, modifedMessage);
                break;
            }
            case 3: {
                this.checkAndLogError(plugin, modifedMessage);
                break;
            }
            default: {
                String unknownLevelMessage = _resourceLoader.resource("error.unknownVelocityLevel", new Object[]{VELOCITY_OUTPUT, level});
                this.checkAndLogWarning(plugin, unknownLevelMessage);
                this.checkAndLogWarning(plugin, modifedMessage);
            }
        }
    }
}

