/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.templating.template.core;

import com.bea.wlw.template.ITemplateBean;
import com.bea.wlw.template.exceptions.GenerationFailedException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.eclipse.tools.common.templating.template.core.TemplateServicePlugin;
import oracle.eclipse.tools.common.templating.template.core.internal.INoValidationTemplateBean;
import oracle.eclipse.tools.common.templating.velocity.engine.VelocityEngineFactory;
import oracle.eclipse.tools.common.util.ResourceLoader;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public class TemplateService {
    private static final ResourceLoader _resourceLoader = new ResourceLoader(TemplateService.class);
    public static final String TEMPLATE_SERVICE_EXTENSION_POINT_ID = "oracle.eclipse.tools.common.templating.CodeTemplate";
    public static final String ELEMENT_ENGINECONFIG = "engineconfig";
    public static final String ELEMENTATTR_ENGINECONFIG_ID = "id";
    public static final String ELEMENT_PCDATA = "pcdata";
    public static final String ELEMENTATTR_PCDATA_VALUE = "value";
    public static final String ELEMENT_TEMPLATE = "template";
    public static final String ELEMENTATTR_TEMPLATE_ENGINCONFIGID = "engineConfigID";
    public static final String ELEMENTATTR_TEMPLATE_FILE = "file";
    public static final String ELEMENTATTR_TEMPLATE_ID = "id";
    public static final String ELEMENTATTR_TEMPLATE_NAME = "name";
    public static final String ELEMENT_VARPROP = "varprop";
    public static final String ELEMENTATTR_VARPROP_NAME = "name";
    private static final String METHOD_NAME_IADAPTABLE_GETADAPTER = "getAdapter";
    private static final String METHOD_NAME_OBJECT_GETCLASS = "getClass";
    private static final String NEWLINE = "\n";
    private static final String[] PROPERTIES_TO_RESOLVE = new String[]{"file.resource.loader.path"};
    private static TemplateService _instance = null;
    private Map<String, VelocityEngine> _engineConfigurations;
    private Map<String, TemplateInstance> _templates = new HashMap<String, TemplateInstance>();

    private TemplateService() {
        String elementName;
        IConfigurationElement nextElement;
        IConfigurationElement[] contributions;
        this._engineConfigurations = new HashMap<String, VelocityEngine>();
        IExtensionRegistry extensionReg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = contributions = extensionReg.getConfigurationElementsFor(TEMPLATE_SERVICE_EXTENSION_POINT_ID);
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            nextElement = iConfigurationElementArray[n2];
            elementName = nextElement.getName();
            if (elementName.equals(ELEMENT_ENGINECONFIG)) {
                this.registerEngineConfig(nextElement);
            }
            ++n2;
        }
        iConfigurationElementArray = contributions;
        n = contributions.length;
        n2 = 0;
        while (n2 < n) {
            nextElement = iConfigurationElementArray[n2];
            elementName = nextElement.getName();
            if (elementName.equals(ELEMENT_TEMPLATE)) {
                this.registerTemplate(nextElement);
            }
            ++n2;
        }
    }

    private Properties buildEngineProperties(IConfigurationElement root, String propertyKey, Properties io_propertyDefs) {
        assert (root != null);
        String elementName = root.getName();
        if (elementName.equals(ELEMENT_PCDATA)) {
            io_propertyDefs.put(propertyKey, root.getAttribute(ELEMENTATTR_PCDATA_VALUE));
            return io_propertyDefs;
        }
        String rootKey = elementName;
        if (elementName.equals(ELEMENT_VARPROP)) {
            rootKey = root.getAttribute("name");
        } else if (elementName.equals(ELEMENT_ENGINECONFIG)) {
            rootKey = "";
        }
        String newKey = propertyKey;
        if (newKey.length() > 0) {
            newKey = String.valueOf(newKey) + ".";
        }
        newKey = String.valueOf(newKey) + rootKey;
        Properties updatedProps = io_propertyDefs;
        IConfigurationElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            updatedProps = this.buildEngineProperties(children[i], newKey, updatedProps);
            ++i;
        }
        return updatedProps;
    }

    public static String evaluate(String input, ITemplateBean objectDescriptor) throws GenerationFailedException {
        StringWriter writer = new StringWriter();
        StringReader reader = new StringReader(input);
        TemplateService.evaluate(reader, objectDescriptor, writer);
        return writer.toString();
    }

    public static void evaluate(Reader input, ITemplateBean objectDescriptor, Writer io_writer) throws GenerationFailedException {
        VelocityEngine engine = new VelocityEngine();
        VelocityContext context = new VelocityContext();
        context.put(objectDescriptor.getContextID(), objectDescriptor);
        try {
            engine.init();
            engine.evaluate((Context)context, io_writer, objectDescriptor.getContextID(), input);
        }
        catch (Exception e) {
            throw new GenerationFailedException(e);
        }
    }

    public static void generate(String templateID, ITemplateBean objectDescriptor, StringWriter io_writer) throws GenerationFailedException {
        TemplateInstance instance = TemplateService.get()._templates.get(templateID);
        if (instance == null) {
            String message = _resourceLoader.resource("exception.template.couldNotApplyTemplate", new Object[]{templateID});
            throw new GenerationFailedException(message);
        }
        instance.applyContext(objectDescriptor, io_writer);
    }

    public static void generate(String templateID, Collection<? extends ITemplateBean> objectDescriptorList, StringWriter io_writer) throws GenerationFailedException {
        TemplateInstance instance = TemplateService.get()._templates.get(templateID);
        if (instance == null) {
            String message = _resourceLoader.resource("exception.template.couldNotApplyTemplate", new Object[]{templateID});
            throw new GenerationFailedException(message);
        }
        instance.applyContext(objectDescriptorList, io_writer);
    }

    public static String generate(String templateID, ITemplateBean objectDescriptor) throws GenerationFailedException {
        StringWriter writer = new StringWriter();
        TemplateService.generate(templateID, objectDescriptor, writer);
        return writer.toString();
    }

    public static void generate(IPath templateFilePath, ITemplateBean objectDescriptor, StringWriter io_writer) throws GenerationFailedException {
        ArrayList<ITemplateBean> objectDescriptorList = new ArrayList<ITemplateBean>();
        if (objectDescriptor != null) {
            objectDescriptorList.add(objectDescriptor);
        }
        TemplateService.generate(templateFilePath, objectDescriptorList, io_writer);
    }

    public static String generate(IPath templateFilePath, ITemplateBean objectDescriptor) throws GenerationFailedException {
        StringWriter writer = new StringWriter();
        TemplateService.generate(templateFilePath, objectDescriptor, writer);
        return writer.toString();
    }

    public static void generate(IPath templateFilePath, Collection<? extends ITemplateBean> objectDescriptorList, StringWriter io_writer) throws GenerationFailedException {
        TemplateInstance instance = TemplateService.get().makeSingleInstance(templateFilePath);
        if (instance == null) {
            String message = _resourceLoader.resource("exception.template.couldNotApplyTemplate", new Object[]{templateFilePath.toString()});
            throw new GenerationFailedException(message);
        }
        instance.applyContext(objectDescriptorList, io_writer);
    }

    public static synchronized TemplateService get() {
        if (_instance == null) {
            _instance = new TemplateService();
        }
        return _instance;
    }

    private TemplateInstance makeSingleInstance(IPath fileTemplatePath) throws GenerationFailedException {
        IPath rootPath = fileTemplatePath.removeLastSegments(1);
        String templateName = fileTemplatePath.segment(fileTemplatePath.segmentCount() - 1);
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("file.resource.loader.path", rootPath.toString());
        try {
            engine.init();
        }
        catch (Exception e) {
            String message = _resourceLoader.resource("exception.template.initializationFailed", new Object[]{fileTemplatePath.toString()});
            LoggingService.logWarning((Plugin)TemplateServicePlugin.getDefault(), (String)message);
            throw new GenerationFailedException(e.getLocalizedMessage());
        }
        TemplateInstance instance = new TemplateInstance("id." + fileTemplatePath.toString(), templateName, engine);
        return instance;
    }

    private void registerEngineConfig(IConfigurationElement configElement) {
        String engineConfigID = configElement.getAttribute("id");
        VelocityEngine instance = this._engineConfigurations.get(engineConfigID);
        if (instance == null) {
            Properties configProps = this.buildEngineProperties(configElement, "", new Properties());
            IExtension caller = configElement.getDeclaringExtension();
            try {
                Properties resolvedProps = this.resolvePaths(configProps, caller);
                instance = VelocityEngineFactory.makeEngine(resolvedProps);
                this._engineConfigurations.put(engineConfigID, instance);
            }
            catch (MissingTemplateDirectoryException mtde) {
                LoggingService.logWarning((Plugin)TemplateServicePlugin.getDefault(), (String)mtde.getLocalizedMessage());
                assert (false) : mtde.getLocalizedMessage();
            }
            catch (Exception e) {
                String message = _resourceLoader.resource("exception.engine.initializationFailed", new Object[]{engineConfigID.toString()});
                LoggingService.logException((Plugin)TemplateServicePlugin.getDefault(), (Throwable)e, (String)message);
            }
        }
    }

    private void registerTemplate(IConfigurationElement templateElement) {
        TemplateInstance entry = new TemplateInstance(templateElement);
        this._templates.put(entry.getID(), entry);
    }

    private Properties resolvePaths(Properties io_rawProps, IExtension caller) throws MissingTemplateDirectoryException {
        String pluginID = caller.getNamespaceIdentifier();
        Bundle bundle = Platform.getBundle((String)pluginID);
        String[] stringArray = PROPERTIES_TO_RESOLVE;
        int n = PROPERTIES_TO_RESOLVE.length;
        int n2 = 0;
        while (n2 < n) {
            String nextProp = stringArray[n2];
            String nextPath = io_rawProps.getProperty(nextProp);
            if (nextPath != null) {
                Path rawPath = new Path(nextPath);
                URL templateDir = FileLocator.find((Bundle)bundle, (IPath)rawPath, null);
                if (templateDir == null) {
                    throw new MissingTemplateDirectoryException((IPath)rawPath, bundle);
                }
                try {
                    URL localURL = FileLocator.toFileURL((URL)templateDir);
                    io_rawProps.put(nextProp, localURL.getPath());
                }
                catch (IOException ioe) {
                    LoggingService.logException((Plugin)TemplateServicePlugin.getDefault(), (Throwable)ioe);
                }
            }
            ++n2;
        }
        return io_rawProps;
    }

    private static class CompoundClass {
        private Class _rawType;
        private Type[] _actualTypes;

        public <T> CompoundClass(Class<T> rawType, Type[] actualTypes) {
            assert (rawType != null) : "null rawType";
            this._rawType = rawType.isArray() ? rawType.getComponentType() : rawType;
            this._actualTypes = actualTypes != null && !(actualTypes.getClass().getComponentType() instanceof Class) ? null : actualTypes;
        }

        public Type[] getActualTypes() {
            return this._actualTypes;
        }

        public Class getRawType() {
            return this._rawType;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this._rawType);
            if (this._actualTypes != null && this._actualTypes.length > 0) {
                buf.append("<" + this._actualTypes[0]);
                int i = 1;
                while (i < this._actualTypes.length) {
                    buf.append(", " + this._actualTypes[i]);
                    ++i;
                }
                buf.append(">");
            }
            return buf.toString();
        }

        public boolean equals(Object o) {
            assert (o instanceof CompoundClass);
            CompoundClass cc = (CompoundClass)o;
            return this._rawType.getName().equals(cc.getRawType().getName()) && this.typeArraysAreEqual(this._actualTypes, cc.getActualTypes());
        }

        public int hashCode() {
            assert (false) : "hashCode NYI";
            return super.hashCode();
        }

        private boolean typeArraysAreEqual(Type[] t1, Type[] t2) {
            if (t1 == t2) {
                return true;
            }
            if (t1 == null && t2 != null || t1 != null && t2 == null) {
                return false;
            }
            if (t1.length != t2.length) {
                return false;
            }
            boolean equal = true;
            int i = 0;
            while (i < t1.length) {
                assert (t1[i] instanceof Class || t1[i] instanceof ParameterizedType) : "t1[" + i + "] is a " + t1[i].getClass();
                assert (t2[i] instanceof Class || t2[i] instanceof ParameterizedType) : "t2[" + i + "] is a " + t1[i].getClass();
                if (t1[i].getClass() != t2[i].getClass()) {
                    equal = false;
                } else if (t1[i] instanceof Class) {
                    if (!((Class)t1[i]).getName().equals(((Class)t2[i]).getName())) {
                        equal = false;
                    }
                } else if (t1[i] instanceof ParameterizedType && !((ParameterizedType)t1[i]).getRawType().equals(((ParameterizedType)t2[i]).getRawType())) {
                    equal = false;
                }
                ++i;
            }
            return equal;
        }
    }

    private class MissingTemplateDirectoryException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MissingTemplateDirectoryException(IPath rawPath, Bundle bundle) {
            super(_resourceLoader.resource("exception.engine.missingTemplateDirectory", new Object[]{rawPath.toPortableString(), bundle.getSymbolicName()}));
        }
    }

    private class TemplateInstance {
        private static final String JAVA_UTIL = "java.util.";
        private VelocityEngine _engine = null;
        private String _templatePath;
        private String _id;

        public TemplateInstance(String id, String path, VelocityEngine engine) {
            this._id = id;
            this._templatePath = path;
            this._engine = engine;
        }

        public TemplateInstance(IConfigurationElement templateElement) {
            this._id = templateElement.getAttribute("id");
            this._templatePath = templateElement.getAttribute(TemplateService.ELEMENTATTR_TEMPLATE_FILE);
            String engineConfigID = templateElement.getAttribute(TemplateService.ELEMENTATTR_TEMPLATE_ENGINCONFIGID);
            this._engine = (VelocityEngine)TemplateService.this._engineConfigurations.get(engineConfigID);
        }

        private void addCheckedType(List<CompoundClass> checkedTypes, CompoundClass clazz) {
            if (!checkedTypes.contains(clazz)) {
                checkedTypes.add(clazz);
            }
        }

        private void addIllegalType(List<CompoundClass> illegalTypes, CompoundClass clazz) {
            if (!illegalTypes.contains(clazz)) {
                illegalTypes.add(clazz);
            }
        }

        public void applyContext(ITemplateBean command, StringWriter io_writer) throws GenerationFailedException {
            ArrayList<ITemplateBean> contextBeans = new ArrayList<ITemplateBean>();
            if (command != null) {
                contextBeans.add(command);
            }
            this.applyContext(contextBeans, io_writer);
        }

        public void applyContext(Collection<? extends ITemplateBean> contextBeans, StringWriter io_writer) throws GenerationFailedException {
            if (this._engine == null) {
                String message = _resourceLoader.resource("exception.engine.notFound", new Object[]{this._templatePath});
                throw new GenerationFailedException(message);
            }
            StringBuffer validationMessage = new StringBuffer();
            for (ITemplateBean iTemplateBean : contextBeans) {
                if (this.isBeanValid(iTemplateBean, validationMessage)) continue;
                throw new GenerationFailedException(validationMessage.toString());
            }
            try {
                String string = (String)this._engine.getProperty("file.resource.loader.path");
                LoggingService.logDebug((Plugin)TemplateServicePlugin.getDefault(), (String)("File resource loader path for runtime engine: " + string));
                Template template = this._engine.getTemplate(this._templatePath);
                VelocityContext context = new VelocityContext();
                for (ITemplateBean iTemplateBean : contextBeans) {
                    String nextContextID = iTemplateBean.getContextID();
                    context.put(nextContextID, iTemplateBean);
                }
                template.merge(context, io_writer);
            }
            catch (Exception exception) {
                throw new GenerationFailedException(exception);
            }
        }

        private <T> boolean assertVerifyClass(Class<T> clazz) {
            StringBuffer msg = new StringBuffer("\n\n*** Bean : " + clazz + " : failed verification ***\n\n");
            String s = "\n*** Only ITemplateBeans, Strings, primitives, and primitive wrappers are allowed ***\n";
            ArrayList<CompoundClass> illegalTypes = new ArrayList<CompoundClass>();
            ArrayList<CompoundClass> checkedTypes = new ArrayList<CompoundClass>();
            this.verifyClass(clazz, illegalTypes, checkedTypes, msg);
            assert (illegalTypes.size() == 0) : msg.append(s);
            return true;
        }

        private Type[] getActualTypes(Field field) {
            Type t = field.getGenericType();
            return this.getActualTypes(t);
        }

        private Type[] getActualTypes(Method method) {
            Type t = method.getGenericReturnType();
            return this.getActualTypes(t);
        }

        private Type[] getActualTypes(Type type) {
            if (type instanceof ParameterizedType) {
                Type[] types = ((ParameterizedType)type).getActualTypeArguments();
                return types != null && types.length > 0 ? types : null;
            }
            return null;
        }

        public String getID() {
            return this._id;
        }

        private boolean isBeanValid(ITemplateBean templateBean, StringBuffer io_validationMessage) {
            if (templateBean == null) {
                return true;
            }
            if (!templateBean.isValid()) {
                templateBean.dump();
                io_validationMessage.append("Bean: " + templateBean.getClass() + "\nfailed validate() check");
                return false;
            }
            if (!(templateBean instanceof INoValidationTemplateBean)) assert (this.assertVerifyClass(templateBean.getClass()));
            return true;
        }

        private boolean isLegal(CompoundClass clazz, List<CompoundClass> illegalTypes, List<CompoundClass> checkedTypes, StringBuffer msg) {
            Class rawType = clazz.getRawType();
            if (Collection.class.isAssignableFrom(rawType) || Iterator.class.isAssignableFrom(rawType)) {
                Type[] actualTypes = clazz.getActualTypes();
                if (actualTypes == null) {
                    return false;
                }
                boolean allLegal = true;
                int i = 0;
                if (i < actualTypes.length) {
                    Type actualType = actualTypes[i];
                    if (actualType instanceof ParameterizedType) {
                        msg.append("\n\t\t--> illegal nested parameterized type: " + (ParameterizedType)actualType + TemplateService.NEWLINE);
                        return false;
                    }
                    assert (actualType instanceof Class) : " FAILURE WHILE VALIDATING BEAN - " + actualType.toString() + " not a class\nMSG UP TO THIS POINT IS:\n" + msg;
                    Class casted = (Class)Class.class.cast(actualType);
                    CompoundClass cc = new CompoundClass(casted, null);
                    if (!this.isLegal(cc, illegalTypes, checkedTypes, msg)) {
                        msg.append("\n\t\tIllegal parameterized type: " + actualType.getClass() + TemplateService.NEWLINE);
                        allLegal = false;
                        this.addIllegalType(illegalTypes, cc);
                        this.addCheckedType(checkedTypes, cc);
                    } else {
                        this.verifyClass(cc, illegalTypes, checkedTypes, msg);
                    }
                    return allLegal;
                }
            } else {
                if (ITemplateBean.class.isAssignableFrom(rawType)) {
                    return true;
                }
                if (IPath.class.isAssignableFrom(rawType)) {
                    return true;
                }
                return !this.shouldVerifyClass(rawType);
            }
            return true;
        }

        private boolean shouldVerifyClass(Class c) {
            if (c.isPrimitive() || c == Void.TYPE) {
                return false;
            }
            if (c == boolean[].class || c == char[].class || c == byte[].class || c == short[].class || c == int[].class || c == long[].class || c == float[].class || c == double[].class) {
                return false;
            }
            if (c == String.class || c == Boolean.class || c == Character.class || c == Byte.class || c == Short.class || c == Integer.class || c == Long.class || c == Float.class || c == Double.class) {
                return false;
            }
            if (c == String[].class || c == Boolean[].class || c == Character[].class || c == Byte[].class || c == Short[].class || c == Integer[].class || c == Long[].class || c == Float[].class || c == Double[].class) {
                return false;
            }
            return c != IPath.class;
        }

        private boolean startsWithJavaUtil(CompoundClass clazz) {
            return clazz.getRawType().getName().startsWith(JAVA_UTIL);
        }

        private <T> void verifyClass(Class<T> clazz, List<CompoundClass> illegalTypes, List<CompoundClass> checkedTypes, StringBuffer msg) {
            if (clazz.getTypeParameters().length > 0) {
                this.addIllegalType(illegalTypes, new CompoundClass(clazz, clazz.getTypeParameters()));
                msg.append("ITemplateBeans cannot be genericized.");
                return;
            }
            CompoundClass cc = new CompoundClass(clazz, null);
            this.verifyClass(cc, illegalTypes, checkedTypes, msg);
        }

        private void verifyClass(CompoundClass cc, List<CompoundClass> illegalTypes, List<CompoundClass> checkedTypes, StringBuffer msg) {
            if (checkedTypes.contains(cc)) {
                return;
            }
            if (this.shouldVerifyClass(cc.getRawType())) {
                msg.append("*** Verifying class: " + cc + " ***" + TemplateService.NEWLINE);
                this.addCheckedType(checkedTypes, cc);
                if (!this.isLegal(cc, illegalTypes, checkedTypes, msg)) {
                    msg.append("\n--> illegal class : " + cc + TemplateService.NEWLINE);
                    this.addIllegalType(illegalTypes, cc);
                } else if (!this.startsWithJavaUtil(cc)) {
                    this.verifyMethods(cc, illegalTypes, checkedTypes, msg);
                    this.verifyFields(cc, illegalTypes, checkedTypes, msg);
                }
            }
        }

        private void verifyFields(CompoundClass clazz, List<CompoundClass> illegalTypes, List<CompoundClass> checkedTypes, StringBuffer msg) {
            ArrayList<CompoundClass> typesToRecurse = new ArrayList<CompoundClass>();
            Field[] allFields = clazz.getRawType().getFields();
            int i = 0;
            while (i < allFields.length) {
                Field f;
                if (i == 0) {
                    msg.append("\tverifying fields on class: " + clazz + TemplateService.NEWLINE);
                }
                if (Modifier.isPublic((f = allFields[i]).getModifiers())) {
                    CompoundClass cc = new CompoundClass(f.getType(), this.getActualTypes(f));
                    if (!this.isLegal(cc, illegalTypes, checkedTypes, msg)) {
                        msg.append("\n\t\t--> illegal field: " + f + TemplateService.NEWLINE);
                        this.addIllegalType(illegalTypes, cc);
                        this.addCheckedType(checkedTypes, cc);
                    } else {
                        typesToRecurse.add(cc);
                    }
                }
                ++i;
            }
            for (CompoundClass cc : typesToRecurse) {
                this.verifyClass(cc, illegalTypes, checkedTypes, msg);
            }
        }

        private void verifyMethods(CompoundClass clazz, List<CompoundClass> illegalTypes, List<CompoundClass> checkedTypes, StringBuffer msg) {
            Method[] allMethods;
            ArrayList<CompoundClass> typesToRecurse = new ArrayList<CompoundClass>();
            Method[] methodArray = allMethods = clazz.getRawType().getMethods();
            int n = allMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method nextMethod = methodArray[n2];
                if (nextMethod == allMethods[0]) {
                    msg.append("\tverifying methods on class: " + clazz + TemplateService.NEWLINE);
                }
                if (!(nextMethod.getName().equals(TemplateService.METHOD_NAME_IADAPTABLE_GETADAPTER) || !Modifier.isPublic(nextMethod.getModifiers()) || nextMethod.getName().equals(TemplateService.METHOD_NAME_OBJECT_GETCLASS) && nextMethod.getReturnType().equals(Class.class) && nextMethod.getParameterTypes().length == 0 || Enum.class.isAssignableFrom(nextMethod.getReturnType()))) {
                    CompoundClass cc = new CompoundClass(nextMethod.getReturnType(), this.getActualTypes(nextMethod));
                    if (!this.isLegal(cc, illegalTypes, checkedTypes, msg)) {
                        msg.append("\n\t\t--> illegal method: " + nextMethod + TemplateService.NEWLINE);
                        this.addIllegalType(illegalTypes, cc);
                        this.addCheckedType(checkedTypes, cc);
                    } else {
                        typesToRecurse.add(cc);
                    }
                }
                ++n2;
            }
            for (CompoundClass cc : typesToRecurse) {
                this.verifyClass(cc, illegalTypes, checkedTypes, msg);
            }
        }
    }
}

