/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.templating.filetemplate;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateCorePlugin;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateGenerationFailedException;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateProcessor;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateProjectDescriptor;
import oracle.eclipse.tools.common.templating.filetemplate.IContextAdapter;
import oracle.eclipse.tools.common.templating.filetemplate.IFileTemplateBean;
import oracle.eclipse.tools.common.templating.filetemplate.TemplateProjectResourceTranslator;
import oracle.eclipse.tools.common.templating.filetemplate.templatedef.model.TemplateDocument;
import oracle.eclipse.tools.common.util.ResourceLoader;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class FileTemplateDescriptor {
    private static final ResourceLoader _resourceLoader = new ResourceLoader(FileTemplateDescriptor.class);
    private String _description;
    private ImageDescriptor _icon;
    private String _name;
    private TemplateDocument.Template _template;
    private FileTemplateProjectDescriptor _parent;
    private Bundle _bundle;
    private final Map<String, IContextAdapter> _adapterClasses;

    FileTemplateDescriptor(TemplateDocument.Template template, FileTemplateProjectDescriptor parent, Bundle bundle) {
        assert (template != null);
        assert (parent != null);
        this._template = template;
        this._parent = parent;
        this._bundle = bundle;
        this._adapterClasses = new HashMap<String, IContextAdapter>();
        String iconPath = this._template.getIcon();
        this._icon = parent.loadTemplateImageDescriptor(iconPath);
    }

    public List<IPath> generateUnformatted(IProject targetProject, Map<String, IFileTemplateBean> context, boolean force) throws FileTemplateGenerationFailedException, InterruptedException {
        HashMap<String, String> projectVariables = new HashMap<String, String>();
        return this.process(targetProject, context, projectVariables, false, force, false);
    }

    public List<IPath> generateUnformatted(IProject targetProject, Map<String, IFileTemplateBean> context, Map<String, String> projectVariables, boolean force) throws FileTemplateGenerationFailedException, InterruptedException {
        return this.process(targetProject, context, projectVariables, false, force, false);
    }

    public List<IPath> generate(IProject targetProject, Map<String, IFileTemplateBean> context, boolean force) throws FileTemplateGenerationFailedException, InterruptedException {
        HashMap<String, String> projectVariables = new HashMap<String, String>();
        return this.process(targetProject, context, projectVariables, false, force, true);
    }

    public List<IPath> generate(IProject targetProject, Map<String, IFileTemplateBean> context, Map<String, String> projectVariables, boolean force) throws FileTemplateGenerationFailedException, InterruptedException {
        return this.process(targetProject, context, projectVariables, false, force, true);
    }

    public String getDescription() {
        if (this._description == null) {
            this._description = this._template.getDescription();
            if (this._bundle != null) {
                this._description = TemplateProjectResourceTranslator.getResourceString(this._bundle, this._description);
            }
            if (this._description == null) {
                this._description = "";
            }
        }
        return this._description;
    }

    public ImageDescriptor getIcon() {
        return this._icon;
    }

    public String getID() {
        return this._template.getId();
    }

    public String getName() {
        if (this._name == null) {
            this._name = this._template.getName();
            if (this._bundle != null) {
                this._name = TemplateProjectResourceTranslator.getResourceString(this._bundle, this._name);
            }
            if (this._name == null) {
                this._name = "";
            }
        }
        return this._name;
    }

    public FileTemplateProjectDescriptor getParentProject() {
        return this._parent;
    }

    TemplateDocument.Template getTemplate() {
        return this._template;
    }

    IContextAdapter loadContextAdapter(String className) {
        IContextAdapter adapter = null;
        if (this._bundle != null && (adapter = this._adapterClasses.get(className)) == null) {
            try {
                Class declaredClass = this._bundle.loadClass(className);
                if (IContextAdapter.class.isAssignableFrom(declaredClass)) {
                    Class adapterClass = declaredClass;
                    adapter = (IContextAdapter)adapterClass.newInstance();
                } else {
                    String message = _resourceLoader.resource("warning.templateAdapterDoesNotExtendAdapter", new Object[]{className, IContextAdapter.class.getName()});
                    LoggingService.logWarning((Plugin)FileTemplateCorePlugin.getDefault(), (String)message);
                }
            }
            catch (Exception e) {
                assert (e instanceof ClassNotFoundException || e instanceof InstantiationException || e instanceof IllegalAccessException);
                LoggingService.logException((Plugin)FileTemplateCorePlugin.getDefault(), (Throwable)e);
            }
        }
        return adapter;
    }

    public List<IPath> preview(IProject targetProject, Map<String, IFileTemplateBean> context, Map<String, String> projectVariables) throws FileTemplateGenerationFailedException, InterruptedException {
        return this.process(targetProject, context, projectVariables, true, false, false);
    }

    private List<IPath> process(IProject targetProject, Map<String, IFileTemplateBean> context, Map<String, String> projectVariables, boolean isPreview, boolean force, boolean formatOutput) throws FileTemplateGenerationFailedException, InterruptedException {
        if (context == null) {
            context = new HashMap<String, IFileTemplateBean>();
        }
        ArrayList<IPath> results = new ArrayList<IPath>();
        FileTemplateProcessor px = new FileTemplateProcessor(this, force, formatOutput);
        try {
            List<IPath> templateFiles = px.processTemplate(targetProject, context, projectVariables, isPreview);
            results.addAll(templateFiles);
        }
        catch (InvocationTargetException ite) {
            LoggingService.logException((Plugin)FileTemplateCorePlugin.getDefault(), (Throwable)ite.getTargetException());
            String message = _resourceLoader.resource("error.fileTemplateGenerationFailed", new Object[]{ite.getTargetException().getLocalizedMessage()});
            throw new FileTemplateGenerationFailedException(message);
        }
        return results;
    }
}

