/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.templating.filetemplate;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateCorePlugin;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateDescriptor;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateProjectDescriptor;
import oracle.eclipse.tools.common.templating.filetemplate.IFileTemplateBean;
import oracle.eclipse.tools.common.templating.filetemplate.TemplateProjectCache;
import oracle.eclipse.tools.common.templating.filetemplate.templatedef.model.TemplateProjectDocument;
import oracle.eclipse.tools.common.util.ResourceLoader;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

class DeclaredTemplateProjectCache
extends TemplateProjectCache {
    private static final ResourceLoader _resourceLoader = new ResourceLoader(DeclaredTemplateProjectCache.class);
    public static final String FILE_TEMPLATE_CACHE_EXTENSION_POINT_ID = "oracle.eclipse.tools.common.templating.DeclarativeTemplateProject";
    public static final String ELEMENT_TEMPLATEPROJECT = "templateProject";
    public static final String ELEMENTATTR_TEMPLATEPROJECT_PROJECTLOCATION = "projectLocation";
    public static final String ELEMENTATTR_TEMPLATEPROJECT_PROJECTDESCRIPTION = "projectDescription";
    private Map<String, Collection<FileTemplateProjectDescriptor>> _typeProjectMap = new HashMap<String, Collection<FileTemplateProjectDescriptor>>();
    private Map<String, FileTemplateDescriptor> _idTemplateMap = new HashMap<String, FileTemplateDescriptor>();
    private static DeclaredTemplateProjectCache _instance;

    private DeclaredTemplateProjectCache() {
        IConfigurationElement[] contributions;
        IExtensionRegistry extensionReg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = contributions = extensionReg.getConfigurationElementsFor(FILE_TEMPLATE_CACHE_EXTENSION_POINT_ID);
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement nextElement = iConfigurationElementArray[n2];
            String elementName = nextElement.getName();
            if (elementName.equals(ELEMENT_TEMPLATEPROJECT)) {
                this.registerTemplateProject(nextElement);
            }
            ++n2;
        }
    }

    private static DeclaredTemplateProjectCache get() {
        if (_instance == null) {
            _instance = new DeclaredTemplateProjectCache();
        }
        return _instance;
    }

    public static Collection<FileTemplateProjectDescriptor> getDeclaredProjectsForType(Class<? extends IFileTemplateBean> type) {
        ArrayList<FileTemplateProjectDescriptor> descriptors = new ArrayList<FileTemplateProjectDescriptor>();
        Collection<FileTemplateProjectDescriptor> forType = DeclaredTemplateProjectCache.get()._typeProjectMap.get(type.getName());
        if (forType != null) {
            descriptors.addAll(forType);
        }
        return descriptors;
    }

    public static FileTemplateDescriptor getDeclaredTemplateByID(String id) {
        return DeclaredTemplateProjectCache.get()._idTemplateMap.get(id);
    }

    private static File getFileFromPlugin(IConfigurationElement element, String path) {
        assert (element != null);
        assert (path != null);
        File fileFound = null;
        Bundle bundle = Platform.getBundle((String)element.getNamespaceIdentifier());
        URL fileURL = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        if (fileURL != null) {
            try {
                URL localFileURL = FileLocator.toFileURL((URL)fileURL);
                fileFound = FileBuffers.getSystemFileAtLocation((IPath)new Path(localFileURL.getPath()));
            }
            catch (IOException ioe) {
                String message = _resourceLoader.resource("error.couldNotFindFileInPlugin", new Object[]{fileURL.toString(), element.getNamespaceIdentifier()});
                LoggingService.logException((Plugin)FileTemplateCorePlugin.getDefault(), (Throwable)ioe, (String)message);
            }
        }
        return fileFound;
    }

    private void registerTemplateProject(IConfigurationElement projectElement) {
        String templateProjectPath = projectElement.getAttribute(ELEMENTATTR_TEMPLATEPROJECT_PROJECTLOCATION);
        File file = DeclaredTemplateProjectCache.getFileFromPlugin(projectElement, templateProjectPath);
        assert (file != null) : "Template project was not found for path (" + templateProjectPath + ") in plugin: " + projectElement.getNamespaceIdentifier();
        TemplateProjectDocument.TemplateProject declaredProject = DeclaredTemplateProjectCache.parseTemplateProject(file);
        if (declaredProject != null) {
            Bundle pluginBundle = Platform.getBundle((String)projectElement.getNamespaceIdentifier());
            String templateProjectDescription = projectElement.getAttribute(ELEMENTATTR_TEMPLATEPROJECT_PROJECTDESCRIPTION);
            ResourceBundle resources = Platform.getResourceBundle((Bundle)pluginBundle);
            String translatedDescription = templateProjectDescription;
            if (resources != null && translatedDescription.length() > 0 && translatedDescription.charAt(0) == '%') {
                try {
                    translatedDescription = resources.getString(translatedDescription);
                }
                catch (MissingResourceException missingResourceException) {}
            }
            FileTemplateProjectDescriptor descriptor = FileTemplateProjectDescriptor.createFileTemplateProjectDesccriptor(declaredProject, (IPath)new Path(file.getPath()), translatedDescription, pluginBundle);
            List<FileTemplateDescriptor> projectDescriptors = descriptor.getTemplates();
            for (FileTemplateDescriptor nextTemplate : projectDescriptors) {
                this._idTemplateMap.put(nextTemplate.getID(), nextTemplate);
            }
            Set<String> projectTypes = descriptor.getTypes();
            for (String nextType : projectTypes) {
                Collection<FileTemplateProjectDescriptor> descriptors = this._typeProjectMap.get(nextType);
                if (descriptors == null) {
                    descriptors = new ArrayList<FileTemplateProjectDescriptor>();
                    this._typeProjectMap.put(nextType, descriptors);
                }
                descriptors.add(descriptor);
            }
        }
    }
}

