/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.e4.core.internal.services.ServicesActivator;
import org.eclipse.e4.core.services.translation.ResourceBundleProvider;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;

public class ResourceBundleHelper {
    private static final String PLATFORM_SCHEMA = "platform";
    private static final String BUNDLECLASS_SCHEMA = "bundleclass";
    private static final String PLUGIN_SEGMENT = "/plugin/";
    private static final String FRAGMENT_SEGMENT = "/fragment/";
    private static final String PATH_SEPARATOR = "/";
    private static HashSet<String> invalidLocalesLogged = new HashSet();

    public static ResourceBundle getResourceBundleForUri(String contributorURI, Locale locale, ResourceBundleProvider provider) {
        URI uri;
        if (contributorURI == null) {
            return null;
        }
        LogService logService = ServicesActivator.getDefault().getLogService();
        try {
            uri = new URI(contributorURI);
        }
        catch (URISyntaxException uRISyntaxException) {
            if (logService != null) {
                logService.log(1, "Invalid contributor URI: " + contributorURI);
            }
            return null;
        }
        String bundleName = null;
        Bundle bundle = null;
        String resourcePath = null;
        String classPath = null;
        if (PLATFORM_SCHEMA.equals(uri.getScheme())) {
            bundleName = uri.getPath();
            if (bundleName.startsWith(PLUGIN_SEGMENT)) {
                bundleName = bundleName.substring(PLUGIN_SEGMENT.length());
            } else if (bundleName.startsWith(FRAGMENT_SEGMENT)) {
                bundleName = bundleName.substring(FRAGMENT_SEGMENT.length());
            }
            resourcePath = "";
            if (bundleName.contains(PATH_SEPARATOR)) {
                resourcePath = bundleName.substring(bundleName.indexOf(PATH_SEPARATOR) + 1);
                bundleName = bundleName.substring(0, bundleName.indexOf(PATH_SEPARATOR));
            }
        } else if (BUNDLECLASS_SCHEMA.equals(uri.getScheme())) {
            if (uri.getAuthority() == null && logService != null) {
                logService.log(1, "Failed to get bundle for: " + contributorURI);
            }
            bundleName = uri.getAuthority();
            if (uri.getPath() != null && uri.getPath().length() > 0) {
                classPath = uri.getPath().substring(1);
            } else if (logService != null) {
                logService.log(1, "Called with invalid contributor URI: " + contributorURI);
            }
        }
        ResourceBundle result = null;
        if (bundleName != null && (bundle = ResourceBundleHelper.getBundleForName(bundleName)) != null) {
            if (resourcePath == null && classPath != null) {
                try {
                    Class resourceBundleClass = bundle.loadClass(classPath);
                    result = ResourceBundleHelper.getEquinoxResourceBundle(classPath, locale, resourceBundleClass.getClassLoader());
                }
                catch (Exception e) {
                    if (logService != null) {
                        logService.log(1, "Failed to load specified ResourceBundle: " + contributorURI, (Throwable)e);
                    }
                }
            } else {
                result = resourcePath != null && resourcePath.length() > 0 ? ResourceBundleHelper.getEquinoxResourceBundle(resourcePath.replace('.', '/'), locale, bundle) : provider.getResourceBundle(bundle, locale.toString());
            }
        }
        return result;
    }

    public static ResourceBundle getEquinoxResourceBundle(String baseName, Locale locale, ClassLoader loader) {
        ResourceBundle resourceBundle = null;
        String equinoxLocale = ResourceBundleHelper.getEquinoxRootLocale();
        if (equinoxLocale.length() > 0 && locale.toString().startsWith(equinoxLocale)) {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale, loader, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT));
            }
            catch (MissingResourceException missingResourceException) {}
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(baseName, Locale.getDefault(), loader, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT));
                }
                catch (MissingResourceException missingResourceException) {}
            }
        } else {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale, loader);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return resourceBundle;
    }

    public static ResourceBundle getEquinoxResourceBundle(String baseName, Locale locale, Bundle bundle) {
        return ResourceBundleHelper.getEquinoxResourceBundle(baseName, locale, new BundleResourceBundleControl(bundle, true), new BundleResourceBundleControl(bundle, false));
    }

    public static ResourceBundle getEquinoxResourceBundle(String baseName, Locale locale, ResourceBundle.Control withFallback, ResourceBundle.Control withoutFallback) {
        ResourceBundle resourceBundle = null;
        String equinoxLocale = ResourceBundleHelper.getEquinoxRootLocale();
        if (equinoxLocale.length() > 0 && locale.toString().startsWith(equinoxLocale)) {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale, withoutFallback);
            }
            catch (MissingResourceException missingResourceException) {}
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(baseName, Locale.getDefault(), withoutFallback);
                }
                catch (MissingResourceException missingResourceException) {}
            }
        } else {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale, withFallback);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return resourceBundle;
    }

    private static String getEquinoxRootLocale() {
        String root = System.getProperties().getProperty("equinox.root.locale");
        if (root == null) {
            root = "en";
        }
        return root;
    }

    public static Bundle getBundleForName(String bundleName) {
        PackageAdmin packageAdmin = ServicesActivator.getDefault().getPackageAdmin();
        Bundle[] bundles = packageAdmin.getBundles(bundleName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public static Locale toLocale(String str) {
        LogService logService = ServicesActivator.getDefault().getLogService();
        if (str == null) {
            if (logService != null) {
                logService.log(1, "Given locale String is null - Default Locale will be used instead.");
            }
            return Locale.getDefault();
        }
        String language = "";
        String country = "";
        String variant = "";
        String[] localeParts = str.split("_");
        if (localeParts.length == 0 || localeParts.length > 3 || localeParts.length == 1 && localeParts[0].length() == 0) {
            ResourceBundleHelper.logInvalidFormat(str, logService);
            return Locale.getDefault();
        }
        if (localeParts[0].length() == 1 || localeParts[0].length() > 2) {
            ResourceBundleHelper.logInvalidFormat(str, logService);
            return Locale.getDefault();
        }
        if (localeParts[0].length() == 2) {
            char ch0 = localeParts[0].charAt(0);
            char ch1 = localeParts[0].charAt(1);
            if (ch0 < 'a' || ch0 > 'z' || ch1 < 'a' || ch1 > 'z') {
                ResourceBundleHelper.logInvalidFormat(str, logService);
                return Locale.getDefault();
            }
        }
        language = localeParts[0];
        if (localeParts.length > 1) {
            if (localeParts[1].length() == 1 || localeParts[1].length() > 2) {
                if (logService != null) {
                    logService.log(1, "Invalid locale format: " + str + " - Only language part will be used to create the Locale.");
                }
                return new Locale(language);
            }
            if (localeParts[1].length() == 2) {
                char ch3 = localeParts[1].charAt(0);
                char ch4 = localeParts[1].charAt(1);
                if (ch3 < 'A' || ch3 > 'Z' || ch4 < 'A' || ch4 > 'Z') {
                    if (logService != null) {
                        logService.log(1, "Invalid locale format: " + str + " - Only language part will be used to create the Locale.");
                    }
                    return new Locale(language);
                }
            }
            country = localeParts[1];
        }
        if (localeParts.length == 3) {
            if (localeParts[0].length() == 0 && localeParts[1].length() == 0) {
                if (logService != null) {
                    logService.log(1, "Invalid locale format: " + str + " - Only language and country part will be used to create the Locale.");
                }
                return new Locale(language, country);
            }
            variant = localeParts[2];
        }
        return new Locale(language, country, variant);
    }

    static void logInvalidFormat(String str, LogService logService) {
        if (logService != null && !invalidLocalesLogged.contains(str)) {
            invalidLocalesLogged.add(str);
            logService.log(1, "Invalid locale format: " + str + " - Default Locale will be used instead.");
        }
    }

    static class BundleResourceBundleControl
    extends ResourceBundle.Control {
        private final boolean useFallback;
        private final Bundle osgiBundle;

        public BundleResourceBundleControl(Bundle osgiBundle, boolean useFallback) {
            this.osgiBundle = osgiBundle;
            this.useFallback = useFallback;
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            PropertyResourceBundle bundle = null;
            if (format.equals("java.properties")) {
                final String resourceName = this.toResourceName(bundleName, "properties");
                InputStream stream = null;
                try {
                    stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws IOException {
                            URLConnection connection;
                            InputStream is = null;
                            URL url = BundleResourceBundleControl.this.osgiBundle.getEntry(resourceName);
                            if (url != null && (connection = url.openConnection()) != null) {
                                connection.setUseCaches(false);
                                is = connection.getInputStream();
                            }
                            return is;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getException();
                }
                if (stream != null) {
                    try {
                        bundle = new PropertyResourceBundle(stream);
                    }
                    finally {
                        stream.close();
                    }
                }
            } else {
                throw new IllegalArgumentException("unknown format: " + format);
            }
            return bundle;
        }

        @Override
        public List<String> getFormats(String baseName) {
            return FORMAT_PROPERTIES;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            return this.useFallback ? super.getFallbackLocale(baseName, locale) : null;
        }
    }
}

