/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.common.ui.quickstart.wizard;

import java.util.List;
import oracle.eclipse.tools.adf.common.ui.Activator;
import oracle.eclipse.tools.adf.common.ui.quickstart.Messages;
import oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl.PresentationVariation;
import oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl.PresentationVariationComposite;
import oracle.eclipse.tools.adf.common.ui.quickstart.wizard.NewADFFileWizard;
import oracle.eclipse.tools.adf.dtrt.context.typed.IQuickPageLayoutContext;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class QuickLayaoutTemplateComposite
extends Composite {
    public static final String MASTER_DIALOGSETTING = "masterDialogSetting";
    public static final String THEME_DIALOGSETTING = "themeDialogSetting";
    private final Color _colorListBackground;
    private final Color _colorListSelection;
    private StackLayout stackLayout;
    private PresentationVariationComposite selectedLayoutType;
    private IQuickPageLayoutContext.ILayoutProvider layoutProvider;
    private boolean applyTheme;
    private Composite detailComposite;
    private IQuickPageLayoutContext context;
    private IQuickPageLayoutContext.ILayoutProvider oneLayoutProvider;
    private Composite onePanel;
    private IQuickPageLayoutContext.ILayoutProvider twoLayoutProvider;
    private Composite twoPanel;
    private IQuickPageLayoutContext.ILayoutProvider threeLayoutProvider;
    private Composite threePanel;
    private PresentationVariationComposite onePvComposite;
    private PresentationVariationComposite twoPvComposite;
    private PresentationVariationComposite threePvComposite;
    private IDialogSettings dialogSettings = this.getDialogSettings();

    public QuickLayaoutTemplateComposite(Composite parent, int style) {
        super(parent, style);
        this._colorListBackground = parent.getDisplay().getSystemColor(25);
        this._colorListSelection = parent.getDisplay().getSystemColor(26);
        this.setLayout((Layout)new GridLayout(1, false));
        Composite root = new Composite((Composite)this, 0);
        root.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        root.setLayout((Layout)new GridLayout(2, false));
        Label lblLayout = new Label(root, 0);
        lblLayout.setText(Messages.QuickLayaoutTemplateComposite_layout);
        Label lblDescription = new Label(root, 0);
        lblDescription.setText(Messages.QS_TYPES);
        Composite masterComposite = new Composite(root, 0);
        GridLayout gl_masterComposite = new GridLayout(1, false);
        gl_masterComposite.horizontalSpacing = 0;
        gl_masterComposite.marginWidth = 0;
        masterComposite.setLayout((Layout)gl_masterComposite);
        masterComposite.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        Composite innerComposite = new Composite(masterComposite, 2048);
        innerComposite.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        innerComposite.setBackground(this._colorListBackground);
        innerComposite.setLayout((Layout)new GridLayout(1, false));
        this.onePvComposite = this.createPvComposite(innerComposite, Messages.QuickLayaoutTemplateComposite_one_column_layout, "images/onecolumn/onecolumn_meta.png");
        this.onePvComposite.setLayoutData(new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.twoPvComposite = this.createPvComposite(innerComposite, Messages.QuickLayaoutTemplateComposite_two_column_layout, "images/twocolumn/twocolumn_meta.png");
        this.threePvComposite = this.createPvComposite(innerComposite, Messages.QuickLayaoutTemplateComposite_three_column_layout, "images/threecolumn/threecolumn_meta.png");
        this.detailComposite = new Composite(root, 0);
        this.stackLayout = new StackLayout();
        this.detailComposite.setLayout((Layout)this.stackLayout);
        this.detailComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Button chkTheme = new Button(root, 32);
        chkTheme.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        chkTheme.setText(Messages.QuickLayaoutTemplateComposite_apply_theme);
        chkTheme.setSelection(this.dialogSettings.getBoolean(THEME_DIALOGSETTING));
        chkTheme.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickLayaoutTemplateComposite.this.applyTheme = ((Button)e.widget).getSelection();
                QuickLayaoutTemplateComposite.this.dialogSettings.put(QuickLayaoutTemplateComposite.THEME_DIALOGSETTING, QuickLayaoutTemplateComposite.this.applyTheme);
            }
        });
        this.applyTheme = this.dialogSettings.getBoolean(THEME_DIALOGSETTING);
        this.updateContext();
        new Label(root, 0);
        new Label(root, 0);
        this.onePvComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickLayaoutTemplateComposite.this.updateSelection(QuickLayaoutTemplateComposite.this.onePvComposite, QuickLayaoutTemplateComposite.this.onePanel, QuickLayaoutTemplateComposite.this.oneLayoutProvider);
                QuickLayaoutTemplateComposite.this.saveMasterSelection(MasterSelection.OneColumn);
            }
        });
        this.twoPvComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickLayaoutTemplateComposite.this.updateSelection(QuickLayaoutTemplateComposite.this.twoPvComposite, QuickLayaoutTemplateComposite.this.twoPanel, QuickLayaoutTemplateComposite.this.twoLayoutProvider);
                QuickLayaoutTemplateComposite.this.saveMasterSelection(MasterSelection.TwoColumn);
            }
        });
        this.threePvComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickLayaoutTemplateComposite.this.updateSelection(QuickLayaoutTemplateComposite.this.threePvComposite, QuickLayaoutTemplateComposite.this.threePanel, QuickLayaoutTemplateComposite.this.threeLayoutProvider);
                QuickLayaoutTemplateComposite.this.saveMasterSelection(MasterSelection.ThreeColumn);
            }
        });
        this.updateDialogSettings();
    }

    protected void updateDialogSettings() {
        String masterSetting = this.dialogSettings.get(MASTER_DIALOGSETTING);
        if (masterSetting != null) {
            if (masterSetting.equals(MasterSelection.OneColumn.toString())) {
                this.updateSelection(this.onePvComposite, this.onePanel, this.oneLayoutProvider);
            } else if (masterSetting.equals(MasterSelection.TwoColumn.toString())) {
                this.updateSelection(this.twoPvComposite, this.twoPanel, this.twoLayoutProvider);
            } else if (masterSetting.equals(MasterSelection.ThreeColumn.toString())) {
                this.updateSelection(this.threePvComposite, this.threePanel, this.threeLayoutProvider);
            }
        } else {
            this.updateSelection(this.onePvComposite, this.onePanel, this.oneLayoutProvider);
        }
    }

    protected void updateContext() {
        List providers;
        if (this.getContext() != null && (providers = this.getContext().getLayoutProviders()).size() == 3) {
            this.oneLayoutProvider = (IQuickPageLayoutContext.ILayoutProvider)providers.get(0);
            this.onePanel = (Composite)this.oneLayoutProvider.getSelectionPanel((Object)this.detailComposite);
            this.twoLayoutProvider = (IQuickPageLayoutContext.ILayoutProvider)providers.get(1);
            this.twoPanel = (Composite)this.twoLayoutProvider.getSelectionPanel((Object)this.detailComposite);
            this.threeLayoutProvider = (IQuickPageLayoutContext.ILayoutProvider)providers.get(2);
            this.threePanel = (Composite)this.threeLayoutProvider.getSelectionPanel((Object)this.detailComposite);
            this.updateDialogSettings();
        }
    }

    private void saveMasterSelection(MasterSelection selection) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        dialogSettings.put(MASTER_DIALOGSETTING, selection.name());
    }

    public void updateSelection(PresentationVariationComposite pvComposite, Composite panel, IQuickPageLayoutContext.ILayoutProvider provider) {
        this.stackLayout.topControl = panel;
        this.layoutProvider = provider;
        if (this.selectedLayoutType != null) {
            this.selectedLayoutType.setBackground(this._colorListBackground);
        }
        this.selectedLayoutType = pvComposite;
        this.selectedLayoutType.setBackground(this._colorListSelection);
        this.detailComposite.layout();
        this.layout();
    }

    public IDialogSettings getDialogSettings() {
        String name = NewADFFileWizard.class.getName();
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings wizardDialogSettings = dialogSettings.getSection(name);
        if (wizardDialogSettings == null) {
            wizardDialogSettings = dialogSettings.addNewSection(name);
        }
        return wizardDialogSettings;
    }

    private PresentationVariationComposite createPvComposite(Composite parent, String name, String path) {
        PresentationVariation pv = new PresentationVariation(name, name, name, path, null, null);
        return new PresentationVariationComposite(parent, 0, pv, false);
    }

    public IQuickPageLayoutContext.ILayout getQuickLayout() {
        return this.layoutProvider.getCurrentLayout();
    }

    public boolean isApplyTheme() {
        return this.applyTheme;
    }

    protected void checkSubclass() {
    }

    public IQuickPageLayoutContext getContext() {
        return this.context;
    }

    public void setContext(IQuickPageLayoutContext context) {
        if (this.context == null || !this.context.equals(context)) {
            this.context = context;
            this.updateContext();
        }
    }

    public static enum MasterSelection {
        OneColumn,
        TwoColumn,
        ThreeColumn;

    }
}

