/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.common.ui.quickstart.wizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import oracle.eclipse.tools.adf.common.ui.quickstart.Messages;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jst.jsp.ui.StructuredTextViewerConfigurationJSP;
import org.eclipse.jst.jsp.ui.internal.preferences.JSPUIPreferenceNames;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public class NewJSPTemplatesComposite
extends Composite {
    private static final String CTYPE_JSPSOURCE = "org.eclipse.jst.jsp.core.jspsource";
    private static final String DEFAULT_TEMPLATE_ID = "oracle.adf.web.new_jsp_page_xhtml";
    private static final String DEFAULT_FRAGMENT_TEMPLATE_ID = "oracle.adf.web.new_jsp_page_fragment_xhtml";
    private static final String DEFAULT_FACELET_TEMPLATE_ID = "oracle.adf.web.adf_new_facelet_page_xhtml";
    private static final String DEFAULT_FACELET_FRAGMENT_TEMPLATE_ID = "oracle.adf.web.adf_new_facelet_fragment_xhtml";
    private String fLastSelectedTemplateName;
    private SourceViewer fPatternViewer;
    private TableViewer fTableViewer;
    private ADFTemplateStore fTemplateStore;
    private ContextTypeRegistry fContextTypeRegistry;
    private ScopedPreferenceStore fJSPPreferenceStore;
    private FontMetrics fontMetrics;
    private boolean _useFragments;
    private boolean _isFacelet;

    public NewJSPTemplatesComposite(Composite ancestor, int style, boolean useFragments, boolean isFacelet) {
        super(ancestor, style);
        this._useFragments = useFragments;
        this._isFacelet = isFacelet;
        Composite parent = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        innerParent.setLayoutData((Object)gd);
        Label label = new Label(innerParent, 0);
        label.setText(Messages.NewJSPTemplatesWizardPage_label_templates);
        GridData data = new GridData(4, 4, true, false, 2, 1);
        label.setLayoutData((Object)data);
        Table table = new Table(innerParent, 67584);
        this.initializeDialogUnits((Control)table);
        data = new GridData(768);
        data.heightHint = 150;
        data.horizontalSpan = 2;
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.NewJSPTemplatesWizardPage_column_name);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.NewJSPTemplatesWizardPage_column_desc);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new TemplateContentProvider());
        this.fTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof Template && object2 instanceof Template) {
                    Template left = (Template)object1;
                    Template right = (Template)object2;
                    int result = left.getName().compareToIgnoreCase(right.getName());
                    if (result != 0) {
                        return result;
                    }
                    return left.getDescription().compareToIgnoreCase(right.getDescription());
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                NewJSPTemplatesComposite.this.updateViewerInput();
            }
        });
        this.fPatternViewer = this.doCreateViewer(innerParent);
        this.fTemplateStore = this.getFilteredTemplates();
        this.fTableViewer.setInput((Object)this.fTemplateStore);
        this.configureTableResizing(innerParent, table, column1, column2);
        this.loadLastSavedPreferences();
        Link link = new Link(parent, 0);
        link.setText(Messages.NewJSPTemplatesWizardPage_link);
        data = new GridData(0x1000008, 4, true, false, 2, 1);
        link.setLayoutData((Object)data);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewJSPTemplatesComposite.this.linkClicked();
            }
        });
        Dialog.applyDialogFont((Control)parent);
        this.enableTemplates();
    }

    public void updateTemplates(boolean useFragments, boolean isFacelet) {
        this._useFragments = useFragments;
        this._isFacelet = isFacelet;
        this.fTemplateStore = this.getFilteredTemplates();
        this.fTableViewer.setInput((Object)this.fTemplateStore);
        this.enableTemplates();
    }

    protected void initializeDialogUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    protected void checkSubclass() {
    }

    private void configureTableResizing(final Composite parent, final Table table, final TableColumn column1, final TableColumn column2) {
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = parent.getClientArea();
                Point preferredSize = table.computeSize(-1, -1);
                int width = area.width - 2 * table.getBorderWidth();
                if (preferredSize.y > area.height) {
                    Point vBarSize = table.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = table.getSize();
                if (oldSize.x > width) {
                    column1.setWidth(width / 2);
                    column2.setWidth(width / 2);
                    table.setSize(width, area.height);
                } else {
                    table.setSize(width, area.height);
                    column1.setWidth(width / 2);
                    column2.setWidth(width / 2);
                }
            }
        });
    }

    private SourceViewer createViewer(Composite parent) {
        StructuredTextViewerConfiguration sourceViewerConfiguration = new StructuredTextViewerConfiguration(){
            StructuredTextViewerConfiguration baseConfiguration = new StructuredTextViewerConfigurationJSP();

            public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
                return this.baseConfiguration.getConfiguredContentTypes(sourceViewer);
            }

            public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
                return this.baseConfiguration.getLineStyleProviders(sourceViewer, partitionType);
            }
        };
        StructuredTextViewer viewer = new StructuredTextViewer(parent, null, null, false, 2816);
        viewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
        IStructuredModel scratchModel = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(CTYPE_JSPSOURCE);
        IStructuredDocument document = scratchModel.getStructuredDocument();
        viewer.configure((SourceViewerConfiguration)sourceViewerConfiguration);
        viewer.setDocument((IDocument)document);
        return viewer;
    }

    private SourceViewer doCreateViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.NewJSPTemplatesWizardPage_label_preview);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        SourceViewer viewer = this.createViewer(parent);
        viewer.setEditable(false);
        Control control = viewer.getControl();
        data = new GridData(1808);
        data.horizontalSpan = 2;
        control.setLayoutData((Object)data);
        return viewer;
    }

    void enableTemplates() {
        boolean enabled = true;
        if (!enabled) {
            Template template = this.getSelectedTemplate();
            this.fLastSelectedTemplateName = template != null ? template.getName() : "";
            this.fTableViewer.setSelection(null);
        } else {
            this.setSelectedTemplate(this.fLastSelectedTemplateName);
        }
        this.fTableViewer.getControl().setEnabled(enabled);
        this.fPatternViewer.getControl().setEnabled(enabled);
    }

    private String getPreferencePageId() {
        return "oracle.eclipse.tools.adf.view.ui.templatesPage";
    }

    private Template getSelectedTemplate() {
        Template template = null;
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection.size() == 1) {
            template = (Template)selection.getFirstElement();
        }
        return template;
    }

    String getTemplateString() {
        String templateString = null;
        Template template = this.getSelectedTemplate();
        if (template == null) {
            template = this.getDefaultTemplate();
        }
        if (template != null) {
            TemplateContextType contextType = this.getTemplateContextRegistry().getContextType(template.getContextTypeId());
            Document document = new Document();
            DocumentTemplateContext context = new DocumentTemplateContext(contextType, (IDocument)document, 0, 0);
            try {
                TemplateBuffer buffer = context.evaluate(template);
                templateString = buffer.getString();
            }
            catch (Exception te) {
                LoggingService.logException((String)"oracle.eclipse.tools.adf.common.ui", (Throwable)te, (String)("Could not create new jsp content from template: " + template.getName()));
            }
        }
        return templateString;
    }

    Template getDefaultTemplate() {
        if (this.fTemplateStore != null) {
            if (this._useFragments) {
                if (this._isFacelet) {
                    return this.fTemplateStore.findTemplateById(DEFAULT_FACELET_FRAGMENT_TEMPLATE_ID);
                }
                return this.fTemplateStore.findTemplateById(DEFAULT_FRAGMENT_TEMPLATE_ID);
            }
            if (this._isFacelet) {
                return this.fTemplateStore.findTemplateById(DEFAULT_FACELET_TEMPLATE_ID);
            }
            return this.fTemplateStore.findTemplateById(DEFAULT_TEMPLATE_ID);
        }
        return null;
    }

    void linkClicked() {
        String pageId = this.getPreferencePageId();
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)pageId, (String[])new String[]{pageId}, null);
        dialog.open();
        this.fTemplateStore = this.getFilteredTemplates();
        this.fTableViewer.setInput((Object)this.fTemplateStore);
        this.fTableViewer.refresh();
    }

    private void loadLastSavedPreferences() {
        this.fLastSelectedTemplateName = "";
        String templateName = this.getPreferenceStore().getString("newFileTemplateName");
        if (templateName == null) {
            Template template;
            templateName = this.getPreferenceStore().getString("newFileTemplateId");
            if (templateName != null && templateName.length() > 0 && (template = this.fTemplateStore.findTemplateById(templateName)) != null) {
                this.fLastSelectedTemplateName = template.getName();
            }
        } else {
            this.fLastSelectedTemplateName = templateName;
            if (templateName.length() > 0) {
                // empty if block
            }
        }
        this.enableTemplates();
    }

    void saveLastSavedPreferences() {
        String templateName = "";
        Template template = this.getSelectedTemplate();
        if (template != null) {
            templateName = template.getName();
        }
        ScopedPreferenceStore prefStore = this.getPreferenceStore();
        prefStore.setValue("newFileTemplateName", templateName);
        try {
            prefStore.save();
        }
        catch (IOException ioe) {
            LoggingService.logException((String)"oracle.eclipse.tools.adf.common.ui", (Throwable)ioe, (String)"Could not save the template name.");
        }
    }

    private void setSelectedTemplate(String templateName) {
        Object template = null;
        if (template == null) {
            template = this.fTableViewer.getElementAt(0);
        }
        if (template != null) {
            StructuredSelection selection = new StructuredSelection(template);
            this.fTableViewer.setSelection((ISelection)selection, true);
        }
    }

    void updateViewerInput() {
        Template template = this.getSelectedTemplate();
        if (template != null) {
            this.fPatternViewer.getDocument().set(template.getPattern());
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    private ADFTemplateStore getFilteredTemplates() {
        ADFTemplateStore filteredTemplates = new ADFTemplateStore();
        TemplateStore templateStore = this.getTemplateStore();
        if (templateStore == null) {
            return filteredTemplates;
        }
        List<TemplatePersistenceData> templateDataList = Arrays.asList(templateStore.getTemplateData(false));
        for (TemplatePersistenceData templateData : templateDataList) {
            Template template = templateData.getTemplate();
            if (template == null || !template.getContextTypeId().startsWith("adf_new_")) continue;
            String tempId = template.getContextTypeId();
            boolean isFragment = tempId.endsWith("_fragment");
            boolean isFacelet = tempId.startsWith("adf_new_facelet_");
            if (this._isFacelet && isFacelet) {
                if (this._useFragments && isFragment) {
                    filteredTemplates.add(templateData);
                    continue;
                }
                if (this._useFragments || isFragment) continue;
                filteredTemplates.add(templateData);
                continue;
            }
            if (this._isFacelet || isFacelet) continue;
            if (this._useFragments && isFragment) {
                filteredTemplates.add(templateData);
                continue;
            }
            if (this._useFragments || isFragment) continue;
            filteredTemplates.add(templateData);
        }
        return filteredTemplates;
    }

    private TemplateStore getTemplateStore() {
        ContributionTemplateStore templateStore = new ContributionTemplateStore(this.getTemplateContextRegistry(), (IPreferenceStore)this.getPreferenceStore(), JSPUIPreferenceNames.TEMPLATES_KEY);
        try {
            templateStore.load();
        }
        catch (IOException ioe) {
            LoggingService.logException((String)"oracle.eclipse.tools.adf.common.ui", (Throwable)ioe);
        }
        return templateStore;
    }

    private ContextTypeRegistry getTemplateContextRegistry() {
        if (this.fContextTypeRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            registry.addContextType("adf_new_page");
            registry.addContextType("adf_new_fragment");
            registry.addContextType("adf_new_facelet_page");
            registry.addContextType("adf_new_facelet_fragment");
            this.fContextTypeRegistry = registry;
        }
        return this.fContextTypeRegistry;
    }

    private ScopedPreferenceStore getPreferenceStore() {
        if (this.fJSPPreferenceStore == null) {
            this.fJSPPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.jst.jsp.ui");
        }
        return this.fJSPPreferenceStore;
    }

    private static class ADFTemplateStore {
        private final HashSet<TemplatePersistenceData> templateDataSet = new HashSet();

        private ADFTemplateStore() {
        }

        void add(TemplatePersistenceData templateData) {
            if (templateData != null) {
                this.templateDataSet.add(templateData);
            }
        }

        Template[] getTemplates() {
            ArrayList<Template> templates = new ArrayList<Template>();
            for (TemplatePersistenceData data : this.templateDataSet) {
                if (!data.isEnabled() || data.isDeleted()) continue;
                templates.add(data.getTemplate());
            }
            return templates.toArray(new Template[templates.size()]);
        }

        Template findTemplate(String name) {
            if (name != null && name.length() > 0) {
                for (TemplatePersistenceData data : this.templateDataSet) {
                    Template template = data.getTemplate();
                    if (!name.equals(template.getName())) continue;
                    return template;
                }
            }
            return null;
        }

        public Template findTemplateById(String id) {
            if (id != null && id.length() > 0) {
                for (TemplatePersistenceData data : this.templateDataSet) {
                    if (!id.equals(data.getId())) continue;
                    return data.getTemplate();
                }
            }
            return null;
        }
    }

    private class TemplateContentProvider
    implements IStructuredContentProvider {
        private ADFTemplateStore fStore;

        private TemplateContentProvider() {
        }

        public void dispose() {
            this.fStore = null;
        }

        public Object[] getElements(Object input) {
            if (this.fStore == null) {
                return new ArrayList().toArray();
            }
            return this.fStore.getTemplates();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fStore = (ADFTemplateStore)newInput;
        }
    }

    private class TemplateLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TemplateLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Template template = (Template)element;
            switch (columnIndex) {
                case 0: {
                    return template.getName();
                }
                case 1: {
                    return template.getDescription();
                }
            }
            return "";
        }
    }
}

