/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.common.ui.quickstart.wizard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import oracle.eclipse.tools.adf.common.ui.Activator;
import oracle.eclipse.tools.adf.common.ui.quickstart.Messages;
import oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl.QuickStartLayout;
import oracle.eclipse.tools.adf.common.ui.quickstart.wizard.NewADFFileWizardPage;
import oracle.eclipse.tools.adf.common.ui.quickstart.wizard.NewADFTemplatePage;
import oracle.eclipse.tools.application.common.services.appservices.IWebRootResolver;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.ui.wizards.NewFileWizard;
import oracle.eclipse.tools.common.ui.wizards.NewFileWizardPage;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.utils.TagIDUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.jsp.ui.internal.editor.JSPEditorPluginImageHelper;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;

public class NewADFFileWizard
extends NewFileWizard {
    private static final String FACELETS_FRAGMENT_START = "<?xml version='1.0' encoding='UTF-8'?>\n<ui:composition xmlns:ui=\"http://java.sun.com/jsf/facelets\" xmlns:af=\"http://xmlns.oracle.com/adf/faces/rich\"\n    xmlns:f=\"http://java.sun.com/jsf/core\">\n";
    private static final String FACELETS_FRAGMENT_END = "</ui:composition>";
    private static final String FACELETS_PAGE_START = "<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE html>\n<f:view xmlns:f=\"http://java.sun.com/jsf/core\" xmlns:af=\"http://xmlns.oracle.com/adf/faces/rich\">\n<af:document title=\"page title\" id=\"d1\">\n<af:form id=\"f1\">\n";
    private static final String FACELETS_PAGE_END = "</af:form>\n</af:document>\n</f:view>";
    private static final String JSPXML_PAGE_START = "<?xml version='1.0' encoding='UTF-8'?>\n<jsp:root xmlns:jsp=\"http://java.sun.com/JSP/Page\"\nversion=\"2.1\" xmlns:f=\"http://java.sun.com/jsf/core\"\nxmlns:af=\"http://xmlns.oracle.com/adf/faces/rich\">\n<jsp:directive.page contentType=\"text/html;charset=UTF-8\"/>\n<f:view>\n<af:document title=\"page title\" id=\"d1\">\n<af:form id=\"f1\">\n";
    private static final String JSPXML_PAGE_END = "\n</af:form>\n</af:document>\n</f:view>\n</jsp:root>";
    private static final String JSPXML_FRAGMENT_START = "<?xml version='1.0' encoding='UTF-8'?>\n<jsp:root xmlns:jsp=\"http://java.sun.com/JSP/Page\"\nversion=\"2.1\" xmlns:f=\"http://java.sun.com/jsf/core\"\nxmlns:af=\"http://xmlns.oracle.com/adf/faces/rich\">\n";
    private static final String JSPXML_FRAGMENT_END = "\n</jsp:root>";
    private boolean _useFragments;
    private Boolean _isBoundTaskFlow = null;
    private String _initialFileName;
    private IProject _taskflowProject;
    private NewADFTemplatePage _adfTemplatesPage;

    public NewADFFileWizard() {
        this(false);
    }

    public NewADFFileWizard(boolean useFragments) {
        this(useFragments, null);
    }

    public NewADFFileWizard(boolean useFragments, Boolean isBoundTaskFlow) {
        this.setNeedsProgressMonitor(true);
        this._useFragments = useFragments;
        this._isBoundTaskFlow = isBoundTaskFlow;
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings wizardDialogSettings = dialogSettings.getSection(((Object)((Object)this)).getClass().getName());
        if (wizardDialogSettings == null) {
            wizardDialogSettings = dialogSettings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        this.setDialogSettings(wizardDialogSettings);
    }

    public void setUseFragments(boolean useFragments) {
        this._useFragments = useFragments;
    }

    public void setInitialFileName(String fileName) {
        this._initialFileName = fileName;
    }

    public void setTaskflowProject(IProject project) {
        this._taskflowProject = project;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(Messages.NewJSPFileWizard_title);
        ImageDescriptor descriptor = JSPEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/wizban/newjspfile_wiz.png");
        this.setDefaultPageImageDescriptor(descriptor);
    }

    public void addPages() {
        super.addPages();
        this._adfTemplatesPage = new NewADFTemplatePage(this._useFragments, this.isFacelet());
        this.addPage((IWizardPage)this._adfTemplatesPage);
    }

    protected NewFileWizardPage createFilePage() {
        NewADFFileWizardPage filePage = new NewADFFileWizardPage("ControllerJSPWizardNewFileCreationPage", this.getSelection(), this._useFragments, this._isBoundTaskFlow);
        filePage.setTaskflowProject(this._taskflowProject);
        filePage.setPreValidate(true);
        if (this._initialFileName != null) {
            filePage.setFileName(this._initialFileName);
        }
        return filePage;
    }

    public boolean performFinish() {
        String start;
        String string = this.isFacelet() ? (this.isFragment() ? FACELETS_FRAGMENT_START : FACELETS_PAGE_START) : (start = this.isFragment() ? JSPXML_FRAGMENT_START : JSPXML_PAGE_START);
        String end = this.isFacelet() ? (this.isFragment() ? FACELETS_FRAGMENT_END : FACELETS_PAGE_END) : (this.isFragment() ? JSPXML_FRAGMENT_END : JSPXML_PAGE_END);
        this._file = this.getFilePage().createNewFile();
        if (this._file == null) {
            return false;
        }
        if (this._adfTemplatesPage.isTemplateSelected()) {
            ScopedPreferenceStore preferenceStore;
            String charSet;
            this._adfTemplatesPage.saveLastSavedPreferences();
            String templateString = this._adfTemplatesPage.getTemplateString();
            if (templateString != null && templateString.length() > 0 && !this.createFileContents(templateString = this.applyLineDelimiter(this._file, templateString), charSet = (preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.jst.jsp.core")).getString("outputCodeset"))) {
                return false;
            }
        } else if (this._adfTemplatesPage.isQuickStartSelected()) {
            QuickStartLayout layout = (QuickStartLayout)this._adfTemplatesPage.getLayout();
            layout.setApplyTheme(this._adfTemplatesPage.isApplyTheme());
            String template = layout.create();
            if (!this.createFileContents(String.valueOf(start) + template + end, null)) {
                return false;
            }
        } else if (!this.createFileContents(String.valueOf(start) + end, null)) {
            return false;
        }
        TagIDUtils.fixFragmentIdsForFile((IFile)this._file);
        try {
            new FormatProcessorXML().formatFile(this._file);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        NewADFFileWizard.openEditor((Shell)this.getShell(), (IFile[])new IFile[]{this._file});
        this.updatePerspective();
        this.updateDialogSettings();
        return true;
    }

    private void updateDialogSettings() {
        IContainer webRoot = this.getWebContentFolderIResource(this._file.getProject());
        if (webRoot != null) {
            IPath rootPath = webRoot.getProjectRelativePath();
            IPath parentPath = this._file.getParent().getProjectRelativePath();
            Path relativeToRoot = new Path("/");
            if (!rootPath.equals((Object)parentPath) && rootPath.isPrefixOf(parentPath)) {
                relativeToRoot = parentPath.removeFirstSegments(rootPath.segmentCount());
            }
            this.getDialogSettings().put("containerSetting", relativeToRoot.toString());
        }
        NewADFFileWizardPage page = (NewADFFileWizardPage)this.getFilePage();
        this.getDialogSettings().put("pageOrFragmentSetting", page.isFragment());
        this.getDialogSettings().put("isFaceletSetting", page.isFacelet());
    }

    public IContainer getWebContentFolderIResource(IProject project) {
        IWebRootResolver appService;
        if (project == null) {
            return null;
        }
        Project oepeProject = (Project)project.getAdapter(Project.class);
        if (oepeProject != null && (appService = (IWebRootResolver)oepeProject.getAppService(IWebRootResolver.class)) != null) {
            return (IContainer)appService.getResourceForPath("/");
        }
        return null;
    }

    private boolean isFacelet() {
        NewADFFileWizardPage filePage = (NewADFFileWizardPage)this.getFilePage();
        return filePage.isFacelet();
    }

    private boolean isFragment() {
        NewADFFileWizardPage filePage = (NewADFFileWizardPage)this.getFilePage();
        return filePage.isFragment();
    }

    /*
     * Loose catch block
     */
    private boolean createFileContents(String templateString, String charSet) {
        OutputStreamWriter outputStreamWriter = null;
        ByteArrayInputStream inputStream = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStreamWriter = charSet == null || charSet.trim().equals("") ? new OutputStreamWriter((OutputStream)outputStream, Charset.defaultCharset()) : new OutputStreamWriter((OutputStream)outputStream, charSet);
        outputStreamWriter.write(templateString);
        outputStreamWriter.flush();
        outputStreamWriter.close();
        outputStreamWriter = null;
        inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        this._file.setContents((InputStream)inputStream, true, false, null);
        try {
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
        return true;
        catch (IOException ioe) {
            LoggingService.logException((String)"oracle.eclipse.tools.adf.common.ui", (Throwable)ioe);
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            return false;
        }
        catch (CoreException ce) {
            LoggingService.logException((String)"oracle.eclipse.tools.adf.common.ui", (CoreException)ce);
            {
                catch (Throwable throwable) {
                    try {
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            return false;
        }
    }

    private String applyLineDelimiter(IFile file, String text) {
        String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", System.getProperty("line.separator"), new IScopeContext[]{new ProjectScope(file.getProject()), InstanceScope.INSTANCE});
        String convertedText = StringUtils.replace((String)text, (String)"\r\n", (String)"\n");
        convertedText = StringUtils.replace((String)convertedText, (String)"\r", (String)"\n");
        convertedText = StringUtils.replace((String)convertedText, (String)"\n", (String)lineDelimiter);
        return convertedText;
    }
}

