/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl;

import groovy.lang.Writable;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.util.HashMap;
import oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl.QuickStartLayoutProvider;
import oracle.eclipse.tools.adf.dtrt.context.typed.IQuickPageLayoutContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QuickStartLayout
implements IQuickPageLayoutContext.ILayout {
    private boolean applyTheme;
    private final String _id;
    private final String _displayText;
    private final String _graphic;
    private final String _pattern;

    public boolean isApplyTheme() {
        return this.applyTheme;
    }

    public void setApplyTheme(boolean applyTheme) {
        this.applyTheme = applyTheme;
    }

    QuickStartLayout(ClassLoader classLoader, Element qslElem, QuickStartLayoutProvider qslProvider) {
        this._id = qslElem.getAttributeNS(null, "id");
        if (this._id == null || "".equals(this._id)) {
            throw new IllegalStateException("Layout has missing or empty id");
        }
        String displayText = null;
        displayText = qslElem.getAttributeNS(null, "displayText");
        if (displayText == null || "".equals(displayText)) {
            displayText = qslProvider.__getResource(this._id);
        }
        if (displayText == null || "".equals(displayText)) {
            throw new IllegalStateException("Layout has missing or empty displayText");
        }
        this._displayText = displayText;
        this._graphic = qslElem.getAttributeNS(null, "graphic");
        if (this._graphic == null || "".equals(this._graphic)) {
            throw new IllegalStateException(String.format("Layout '%s' has missing or empty graphic", this._displayText));
        }
        String pattern = null;
        Node child = qslElem.getFirstChild();
        while (child != null) {
            String localName;
            if (1 == child.getNodeType() && "http://xmlns.oracle.com/jdeveloper/webapp/quickstart/layouts".equals(child.getNamespaceURI()) && !"description".equals(localName = child.getLocalName()) && "pattern".equals(localName)) {
                pattern = this._getPatternData(child);
            }
            child = child.getNextSibling();
        }
        this._pattern = pattern;
        if (this._pattern == null || "".equals(this._pattern)) {
            throw new IllegalStateException(String.format("Layout '%s' has missing or empty pattern", this._pattern));
        }
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this.getDisplayText();
    }

    public String getDisplayText() {
        return this._displayText;
    }

    public String getDescription() {
        return this.getDisplayText();
    }

    public String getGraphic() {
        return this._graphic;
    }

    public String create() {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("applyThemes", this.applyTheme);
        String template = null;
        try {
            SimpleTemplateEngine groovyTemplateEngine = new SimpleTemplateEngine();
            Template groovyTemplate = groovyTemplateEngine.createTemplate(this._pattern);
            Writable groovyOut = groovyTemplate.make(options);
            String groovyText = groovyOut.toString();
            template = groovyText = groovyText != null ? groovyText.trim() : groovyText;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return template;
    }

    private String _getPatternData(Node patternNode) {
        Node child = patternNode.getFirstChild();
        while (child != null) {
            if (4 == child.getNodeType()) {
                return child.getNodeValue().trim();
            }
            child = child.getNextSibling();
        }
        return null;
    }
}

