/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl.QuickStartLayout;
import oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl.QuickStartLayoutProvider;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QuickStartCategory {
    private final String _id;
    private final String _displayText;
    private final String _graphic;
    private final ArrayList<QuickStartLayout> _layouts;
    private final ClassLoader _classLoader;

    QuickStartCategory(ClassLoader classLoader, Element qsElem, QuickStartLayoutProvider qslProvider) {
        this._classLoader = classLoader;
        this._id = qsElem.getAttributeNS(null, "id");
        if (this._id == null || "".equals(this._id)) {
            throw new IllegalStateException("Layout has missing or empty id");
        }
        String displayText = null;
        displayText = qsElem.getAttributeNS(null, "displayText");
        if (displayText == null || "".equals(displayText)) {
            displayText = qslProvider.__getResource(this._id);
        }
        if (displayText == null || "".equals(displayText)) {
            throw new IllegalStateException("Layout has missing or empty displayText");
        }
        this._displayText = displayText;
        this._graphic = qsElem.getAttributeNS(null, "graphic");
        if (this._graphic == null || "".equals(this._graphic)) {
            throw new IllegalStateException(String.format("Category '%s' has missing or empty graphic", this._displayText));
        }
        this._layouts = new ArrayList();
        Node child = qsElem.getFirstChild();
        while (child != null) {
            if (1 == child.getNodeType()) {
                Element qslElem = (Element)child;
                QuickStartLayoutProvider.__checkQuickstartElement("layout", qslElem);
                QuickStartLayout qsl = new QuickStartLayout(this._classLoader, qslElem, qslProvider);
                this._layouts.add(qsl);
            }
            child = child.getNextSibling();
        }
    }

    public String getDisplayText() {
        return this._displayText;
    }

    public String getGraphic() {
        return this._graphic;
    }

    public List<QuickStartLayout> getLayouts() {
        return this._layouts;
    }
}

