/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.common.ui.Activator;
import oracle.eclipse.tools.adf.common.ui.quickstart.layout.impl.IPresentationVariation;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PresentationVariationComposite
extends Composite {
    private final List<SelectionListener> _selectionListeners = new ArrayList<SelectionListener>();
    private final IPresentationVariation _pv;
    private final boolean _isChildVariation;
    private Composite _detailsComposite;

    public PresentationVariationComposite(Composite parent, int style, IPresentationVariation pv, boolean isChildVariation) {
        super(parent, style);
        this._pv = pv;
        this._isChildVariation = isChildVariation;
        this.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        this.setLayout((Layout)layout);
        this.setBackgroundMode(2);
        this.setBackground(parent.getBackground());
        String imagePath = this.getPresentationVariation().getImagePath();
        Label imgLabel = new Label((Composite)this, 16384);
        Image image = this.getImage(imagePath);
        imgLabel.setImage(image);
        GridData data = new GridData(4, 4, true, true);
        imgLabel.setLayoutData((Object)data);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
            }

            public void mouseUp(MouseEvent event) {
                PresentationVariationComposite.this.sendSelectionEvent();
            }
        };
        MouseTrackAdapter mouseTrackListener = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent event) {
            }

            public void mouseExit(MouseEvent event) {
            }
        };
        imgLabel.addMouseListener((MouseListener)mouseListener);
        imgLabel.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
        imgLabel.setDragDetect(false);
        if (!this._isChildVariation) {
            String desc = this.getPresentationVariation().getDescription();
            Label descLabel = new Label((Composite)this, 64);
            descLabel.setText(desc);
            data = new GridData(0x1000000, 128, false, false);
            data.widthHint = image.getBounds().width;
            descLabel.setLayoutData((Object)data);
            descLabel.addMouseListener((MouseListener)mouseListener);
            descLabel.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
            descLabel.setDragDetect(false);
        }
    }

    public void dispose() {
        this._detailsComposite = null;
    }

    public void setDetailsComposite(Composite detailsComposite) {
        this._detailsComposite = detailsComposite;
    }

    public Composite getDetailsComposite() {
        return this._detailsComposite;
    }

    public IPresentationVariation getPresentationVariation() {
        return this._pv;
    }

    private void sendSelectionEvent() {
        Event event = new Event();
        event.type = 13;
        event.widget = this;
        SelectionEvent selectionEvent = new SelectionEvent(event);
        for (SelectionListener listener : this._selectionListeners) {
            listener.widgetSelected(selectionEvent);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this._selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this._selectionListeners.remove(listener);
    }

    private Image getImage(String imagePath) {
        return Activator.getDefault().getImage(imagePath);
    }

    public static byte[] read(URL url) throws IOException {
        if (url != null) {
            try (InputStream stream = url.openStream();){
                byte[] byArray = PresentationVariationComposite.read(stream);
                return byArray;
            }
        }
        return null;
    }

    public static byte[] read(InputStream stream) throws IOException {
        if (stream != null) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            int count = stream.read(bytes);
            while (count != -1) {
                buf.write(bytes, 0, count);
                count = stream.read(bytes);
            }
            return buf.toByteArray();
        }
        return null;
    }
}

