/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Iterator;
import oracle.eclipse.tools.common.ui.wizards.ContainerContentProvider;
import oracle.eclipse.tools.common.ui.wizards.ResourceAndContainerGroup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.CreateLinkedResourceGroup;

public class WizardNewFileCreationPage
extends WizardPage
implements Listener {
    private static final int SIZING_CONTAINER_GROUP_HEIGHT = 250;
    private IStructuredSelection _currentSelection;
    protected IFile _newFile;
    private URI _linkTargetPath;
    protected ResourceAndContainerGroup _resourceGroup;
    private Button _advancedButton;
    private CreateLinkedResourceGroup _linkedResourceGroup;
    private Composite _linkedResourceParent;
    private Composite _linkedResourceComposite;
    private boolean preValidate = false;
    private String _initialFileName;
    protected IPath _initialContainerFullPath;
    private int _linkedResourceGroupHeight = -1;
    private boolean _firstLinkCheck = true;
    protected ITreeContentProvider _provider = null;
    private final String _helpContextID;

    public WizardNewFileCreationPage(String pageName, IStructuredSelection selection) {
        this(pageName, selection, "org.eclipse.ui.ide.new_file_wizard_page_context");
    }

    protected WizardNewFileCreationPage(String pageName, IStructuredSelection selection, String helpContextID) {
        super(pageName);
        this.setPageComplete(false);
        this._currentSelection = selection;
        this._helpContextID = helpContextID;
    }

    protected void createAdvancedControls(Composite parent) {
        if (this.allowLinking()) {
            this._linkedResourceParent = new Composite(parent, 0);
            this._linkedResourceParent.setFont(parent.getFont());
            this._linkedResourceParent.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this._linkedResourceParent.setLayout((Layout)layout);
            this._advancedButton = new Button(this._linkedResourceParent, 8);
            this._advancedButton.setFont(this._linkedResourceParent.getFont());
            this._advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
            GridData data = this.setButtonLayoutData(this._advancedButton);
            data.horizontalAlignment = 1;
            this._advancedButton.setLayoutData((Object)data);
            this._advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WizardNewFileCreationPage.this.handleAdvancedButtonSelect();
                }
            });
        }
        this._linkedResourceGroup = new CreateLinkedResourceGroup(1, new Listener(){

            public void handleEvent(Event e) {
                WizardNewFileCreationPage.this.setPageComplete(WizardNewFileCreationPage.this.validatePage());
                WizardNewFileCreationPage.this._firstLinkCheck = false;
            }
        }, null);
    }

    protected boolean allowLinking() {
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        return !preferences.getBoolean("description.disableLinking");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(parent.getFont());
        if (this._helpContextID != null) {
            IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
            help.setHelp((Control)parent, this._helpContextID);
        }
        this._provider = this.createContainerContentProvider();
        this._resourceGroup = this.createContainerGroup(topLevel, this, this.getNewFileLabel(), IDEWorkbenchMessages.WizardNewFileCreationPage_file, this._provider, 250);
        this._resourceGroup.setAllowExistingResources(this.shouldAllowExistingResoures());
        this.initialPopulateContainerNameField();
        this.createAdvancedControls(topLevel);
        if (this._initialFileName != null) {
            this._resourceGroup.setResource(this._initialFileName);
        }
        this.validatePage();
        if (!this.preValidate) {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
        this.setControl((Control)topLevel);
    }

    protected String getHelpContextID() {
        return this._helpContextID;
    }

    protected ResourceAndContainerGroup createContainerGroup(Composite parent, Listener client, String resourceFieldLabel, String resourceType, ITreeContentProvider containerContentProvider, int heightHint) {
        return new ResourceAndContainerGroup(parent, client, resourceFieldLabel, resourceType, containerContentProvider, heightHint);
    }

    public boolean shouldAllowExistingResoures() {
        return false;
    }

    protected void createFile(IFile fileHandle, InputStream contents, IProgressMonitor monitor) throws CoreException {
        if (contents == null) {
            contents = new ByteArrayInputStream(new byte[0]);
        }
        try {
            if (this._linkTargetPath != null) {
                fileHandle.createLink(this._linkTargetPath, 16, monitor);
            } else {
                fileHandle.create(contents, false, monitor);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IFile createFileHandle(IPath filePath) {
        return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getFile(filePath);
    }

    protected void createLinkTarget() {
        this._linkTargetPath = this._linkedResourceGroup.getLinkTargetURI();
    }

    public IFile createNewFile() {
        if (this._newFile != null) {
            return this._newFile;
        }
        final IPath containerPath = this._resourceGroup.getContainerFullPath();
        IPath newFilePath = containerPath.append(this.getFileName());
        final IFile newFileHandle = this.createFileHandle(newFilePath);
        final InputStream initialContents = this.getInitialContents();
        this.createLinkTarget();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask(IDEWorkbenchMessages.bind((String)"WizardNewFileCreationPage.progress", (Object[])new Object[0]), 2000);
                    ContainerGenerator generator = new ContainerGenerator(containerPath);
                    generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    WizardNewFileCreationPage.this.createFile(newFileHandle, initialContents, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_errorTitle, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), (String)"createNewFile()", (Throwable)e.getTargetException());
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)"");
            }
            return null;
        }
        this._newFile = newFileHandle;
        return this._newFile;
    }

    public IPath getContainerFullPath() {
        return this._resourceGroup.getContainerFullPath();
    }

    public boolean isContentProviderEmpty() {
        return this._provider == null ? true : this._provider.getChildren((Object)ResourcesPlugin.getWorkspace()).length == 0;
    }

    public String getFileName() {
        if (this._resourceGroup == null) {
            return this._initialFileName;
        }
        return this._resourceGroup.getResource();
    }

    protected String getInitialFileName() {
        return this._initialFileName;
    }

    protected InputStream getInitialContents() {
        return null;
    }

    protected String getNewFileLabel() {
        return IDEWorkbenchMessages.WizardNewFileCreationPage_fileLabel;
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getControl();
        if (this._linkedResourceComposite != null) {
            this._linkedResourceComposite.dispose();
            this._linkedResourceComposite = null;
            composite.layout();
            shell.setSize(shellSize.x, shellSize.y - this._linkedResourceGroupHeight);
            this._advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
        } else {
            this._linkedResourceComposite = this._linkedResourceGroup.createContents(this._linkedResourceParent);
            if (this._linkedResourceGroupHeight == -1) {
                Point groupSize = this._linkedResourceComposite.computeSize(-1, -1, true);
                this._linkedResourceGroupHeight = groupSize.y;
            }
            shell.setSize(shellSize.x, shellSize.y + this._linkedResourceGroupHeight);
            composite.layout();
            this._advancedButton.setText(IDEWorkbenchMessages.hideAdvanced);
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    protected void initialPopulateContainerNameField() {
        if (this._initialContainerFullPath != null) {
            this._resourceGroup.setContainerFullPath(this._initialContainerFullPath);
        } else {
            Iterator it = this._currentSelection.iterator();
            if (it.hasNext()) {
                Object object = it.next();
                IResource selectedResource = null;
                if (object instanceof IResource) {
                    selectedResource = (IResource)object;
                } else if (object instanceof IAdaptable) {
                    selectedResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
                }
                if (selectedResource != null) {
                    if (selectedResource.getType() == 1) {
                        selectedResource = selectedResource.getParent();
                    }
                    if (selectedResource.isAccessible()) {
                        this._resourceGroup.setContainerFullPath(selectedResource.getFullPath());
                    }
                }
            }
        }
    }

    public void setContainerFullPath(IPath path) {
        if (this._resourceGroup == null) {
            this._initialContainerFullPath = path;
        } else {
            this._resourceGroup.setContainerFullPath(path);
        }
    }

    public void setFileName(String value) {
        if (this._resourceGroup == null) {
            this._initialFileName = value;
        } else {
            this._resourceGroup.setResource(value);
        }
    }

    protected IStatus validateLinkedResource() {
        IPath containerPath = this._resourceGroup.getContainerFullPath();
        IPath newFilePath = containerPath.append(this._resourceGroup.getResource());
        IFile newFileHandle = this.createFileHandle(newFilePath);
        IStatus status = this._linkedResourceGroup.validateLinkLocation((IResource)newFileHandle);
        if (status.getSeverity() == 4) {
            if (this._firstLinkCheck) {
                this.setMessage(status.getMessage());
            } else {
                this.setErrorMessage(status.getMessage());
            }
        } else if (status.getSeverity() == 2) {
            this.setMessage(status.getMessage(), 2);
            this.setErrorMessage(null);
        }
        return status;
    }

    protected boolean validatePage() {
        boolean valid = true;
        if (!this._resourceGroup.areAllValuesValid()) {
            this.setErrorMessage(this._resourceGroup.getProblemMessage());
            valid = false;
        }
        IStatus linkedResourceStatus = null;
        if (valid && (linkedResourceStatus = this.validateLinkedResource()).getSeverity() == 4) {
            valid = false;
        }
        if (valid && (linkedResourceStatus == null || linkedResourceStatus.isOK())) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return valid;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this._resourceGroup.setFocus();
        }
    }

    protected ITreeContentProvider createContainerContentProvider() {
        return new ContainerContentProvider(){

            @Override
            protected boolean isValidProject(IProject project) {
                return true;
            }
        };
    }

    public void setPreValidate(boolean validate) {
        this.preValidate = validate;
    }

    public boolean getPreValidate() {
        return this.preValidate;
    }
}

