/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.eclipse.tools.common.ui.wizards.AbstractContainerSelectionGroup;
import oracle.eclipse.tools.common.ui.wizards.ContainerSelectionGroup;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class ResourceAndContainerGroup
implements Listener {
    private static final String _WIDGET_NAME = "name";
    private static final String _WIDGET = String.valueOf(ResourceAndContainerGroup.class.getName()) + ".";
    public static final String WIDGET_RESOURCE_NAME = String.valueOf(_WIDGET) + "resourceName";
    public static final int PROBLEM_NONE = 0;
    public static final int PROBLEM_RESOURCE_EMPTY = 1;
    public static final int PROBLEM_RESOURCE_EXIST = 2;
    public static final int PROBLEM_RESOURCE_CONTAINS_SEPARATOR = 3;
    public static final int PROBLEM_PATH_INVALID = 4;
    public static final int PROBLEM_CONTAINER_EMPTY = 5;
    public static final int PROBLEM_PROJECT_DOES_NOT_EXIST = 6;
    public static final int PROBLEM_NAME_INVALID = 7;
    private Listener _client;
    private boolean _allowExistingResources = false;
    private String resourceType = IDEWorkbenchMessages.ResourceGroup_resource;
    private IContentProvider _containerContentProvider;
    private String _problemMessage = "";
    private int _problemType = 0;
    private AbstractContainerSelectionGroup _containerGroup;
    private Text _resourceNameField;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public ResourceAndContainerGroup(Composite parent, Listener client, String resourceFieldLabel, String resourceType, ITreeContentProvider containerContentProvider) {
        this(parent, client, resourceFieldLabel, resourceType, containerContentProvider, -1);
    }

    public ResourceAndContainerGroup(Composite parent, Listener client, String resourceFieldLabel, String resourceType, ITreeContentProvider containerContentProvider, int heightHint) {
        this.resourceType = resourceType;
        this._containerContentProvider = containerContentProvider;
        this.createContents(parent, resourceFieldLabel, heightHint);
        this._client = client;
    }

    public boolean areAllValuesValid() {
        return this._problemType == 0;
    }

    protected void createContents(Composite parent, String resourceLabelString, int heightHint) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFont(font);
        this._containerGroup = this.createContainerGroup(composite, heightHint);
        this._containerGroup.getModel().addPropertyChangeListener("CONTAINER_PROPERTY", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Event changeEvent = new Event();
                changeEvent.type = 13;
                changeEvent.widget = ResourceAndContainerGroup.this._containerGroup;
                ResourceAndContainerGroup.this.handleEvent(changeEvent);
            }
        });
        Composite nameGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        nameGroup.setLayout((Layout)layout);
        nameGroup.setLayoutData((Object)new GridData(768));
        nameGroup.setFont(font);
        this.createResourceNameLabel(nameGroup, 0, resourceLabelString, font);
        this._resourceNameField = this.createResourceNameField(nameGroup, 2048, font);
        this._resourceNameField.setData(_WIDGET_NAME, (Object)WIDGET_RESOURCE_NAME);
        this._resourceNameField.addListener(24, (Listener)this);
        this.validateControls();
    }

    protected Label createResourceNameLabel(Composite parent, int style, String labelText, Font font) {
        Label label = new Label(parent, style);
        label.setText(labelText);
        label.setFont(font);
        return label;
    }

    protected Text createResourceNameField(Composite parent, int style, Font font) {
        Text text = new Text(parent, style);
        GridData data = new GridData(768);
        data.widthHint = 250;
        text.setLayoutData((Object)data);
        text.setFont(font);
        return text;
    }

    protected AbstractContainerSelectionGroup createContainerGroup(Composite composite, int heightHint) {
        ContainerSelectionGroup group = heightHint == -1 ? new ContainerSelectionGroup(composite, true, null, this._containerContentProvider) : new ContainerSelectionGroup(composite, true, null, this._containerContentProvider, heightHint);
        group.addContainerNameModifyListener(this);
        return group;
    }

    public IPath getContainerFullPath() {
        return this._containerGroup.getContainerFullPath();
    }

    public String getProblemMessage() {
        return this._problemMessage;
    }

    public int getProblemType() {
        return this._problemType;
    }

    public String getResource() {
        return this._resourceNameField.getText();
    }

    public void handleEvent(Event e) {
        this.validateControls();
        if (this._client != null) {
            this._client.handleEvent(e);
        }
    }

    public void setAllowExistingResources(boolean value) {
        this._allowExistingResources = value;
    }

    public void setContainerFullPath(IPath path) {
        IResource initial = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (initial != null) {
            if (!(initial instanceof IContainer)) {
                initial = initial.getParent();
            }
            this._containerGroup.setSelectedContainer((IContainer)initial);
        }
        this.validateControls();
    }

    public void setFocus() {
        String name = this._resourceNameField.getText();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            index = name.length();
        }
        this._resourceNameField.setSelection(0, index);
        this._resourceNameField.setFocus();
    }

    public void setResource(String value) {
        this._resourceNameField.setText(value);
        this.validateControls();
    }

    protected boolean validateContainer() {
        IPath path = this._containerGroup.getContainerFullPath();
        if (path == null) {
            this._problemType = 5;
            this._problemMessage = IDEWorkbenchMessages.ResourceGroup_folderEmpty;
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectName = path.segment(0);
        if (projectName == null || !workspace.getRoot().getProject(projectName).exists()) {
            this._problemType = 6;
            this._problemMessage = IDEWorkbenchMessages.ResourceGroup_noProject;
            return false;
        }
        return true;
    }

    protected boolean validateControls() {
        if (this._containerGroup == null) {
            return false;
        }
        this._problemType = 0;
        this._problemMessage = "";
        if (!this.validateContainer() || !this.validateResourceName()) {
            return false;
        }
        IPath path = this._containerGroup.getContainerFullPath().append(this._resourceNameField.getText());
        return this.validateFullResourcePath(path);
    }

    protected boolean validateFullResourcePath(IPath resourcePath) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validatePath(resourcePath.toString(), 2);
        if (!result.isOK()) {
            this._problemType = 4;
            this._problemMessage = result.getMessage();
            return false;
        }
        if (!this._allowExistingResources && (workspace.getRoot().getFolder(resourcePath).exists() || workspace.getRoot().getFile(resourcePath).exists())) {
            this._problemType = 2;
            this._problemMessage = NLS.bind((String)IDEWorkbenchMessages.ResourceGroup_nameExists, (Object)this.getResource());
            return false;
        }
        return true;
    }

    protected boolean validateResourceName() {
        String resourceName = this._resourceNameField.getText();
        if (resourceName.equals("")) {
            this._problemType = 1;
            this._problemMessage = NLS.bind((String)IDEWorkbenchMessages.ResourceGroup_emptyName, (Object)this.resourceType);
            return false;
        }
        if (!new Path("").isValidSegment(resourceName)) {
            this._problemType = 7;
            this._problemMessage = NLS.bind((String)IDEWorkbenchMessages.ResourceGroup_invalidFilename, (Object)resourceName);
            return false;
        }
        return true;
    }
}

