/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.wizards;

import java.io.InputStream;
import oracle.eclipse.tools.common.ui.wizards.WizardNewFileCreationPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class NewFileWizardPage
extends WizardNewFileCreationPage {
    protected NewFileWizardPage(String pageName, IStructuredSelection selection) {
        this(pageName, selection, null);
    }

    protected NewFileWizardPage(String pageName, IStructuredSelection selection, String helpContextID) {
        super(pageName, selection, helpContextID);
        this.setFileName(this.getDefaultFileName());
    }

    protected abstract boolean validateFile(IFile var1);

    protected String getDefaultFileName() {
        return "";
    }

    protected String getDefaultFileExtension() {
        return "xml";
    }

    @Override
    public String getFileName() {
        String result = super.getFileName();
        if (result.indexOf(46) < 0) {
            result = String.valueOf(result) + "." + this.getDefaultFileExtension();
        }
        return result;
    }

    public IFile getFile() {
        IPath containerFilePath = this.getContainerFullPath();
        if (containerFilePath == null) {
            return null;
        }
        IPath filePath = containerFilePath.append(this.getFileName());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        return file;
    }

    protected InputStream getInitialContents(IFile file) {
        return null;
    }

    @Override
    protected InputStream getInitialContents() {
        return this.getInitialContents(this.getFile());
    }

    @Override
    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        IFile file = this.getFile();
        if (!this._resourceGroup.validateFullResourcePath(file.getFullPath()) && !super.validatePage()) {
            return false;
        }
        if (!this.validateFile(file)) {
            return false;
        }
        this.setMessage(null);
        this.setErrorMessage(null);
        return true;
    }

    protected boolean hasValidExtension(IFile file) {
        String fileExtension = file.getFileExtension();
        if (fileExtension == null) {
            return true;
        }
        return fileExtension.equals(this.getDefaultFileExtension());
    }
}

