/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.wizards;

import oracle.eclipse.tools.common.ui.wizards.NewFileWizardPage;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public abstract class NewFileWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private NewFileWizardPage _filePage;
    private IStructuredSelection _selection;
    protected IFile _file;
    private IPath _initialPath;
    private IConfigurationElement _configurationElement;

    public NewFileWizardPage getFilePage() {
        return this._filePage;
    }

    public IStructuredSelection getSelection() {
        return this._selection;
    }

    public IFile getFile() {
        return this._file;
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection aSelection) {
        this._selection = aSelection;
    }

    public void addPages() {
        this._filePage = this.createFilePage();
        if (this._initialPath != null) {
            this._filePage.setContainerFullPath(this._initialPath);
        }
        this.addPage((IWizardPage)this._filePage);
    }

    public boolean performFinish() {
        this._file = this._filePage.createNewFile();
        if (this._file == null) {
            return false;
        }
        NewFileWizard.openEditor(this.getShell(), this._file);
        this.updatePerspective();
        return true;
    }

    protected static void openEditor(Shell shell, final IFile ... files) {
        assert (files != null);
        if (shell != null && shell.getDisplay() != null) {
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IFile[] iFileArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFile file = iFileArray[n2];
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                            ++n2;
                        }
                    }
                    catch (PartInitException e) {
                        LoggingService.logException((String)"oracle.eclipse.tools.common.ui", (CoreException)((Object)e));
                    }
                }
            });
        }
    }

    protected NewFileWizardPage createFilePage() {
        return new NewFileWizardPage("FilePage", this.getSelection()){

            @Override
            protected boolean validateFile(IFile file) {
                return true;
            }

            @Override
            protected String getDefaultFileName() {
                return "";
            }
        };
    }

    public void setInitialContainerFullPath(IPath path) {
        this._initialPath = path;
        if (this._filePage != null) {
            this._filePage.setContainerFullPath(path);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this._configurationElement = config;
    }

    protected void updatePerspective() {
        if (this._configurationElement != null) {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this._configurationElement);
        }
    }
}

