/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.wizards;

import oracle.eclipse.tools.common.ui.wizards.ContainerContentProvider;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public abstract class ContainerContentProviderForJava
extends ContainerContentProvider {
    @Override
    protected boolean isValidContainer(IContainer container) {
        return this.containsPackages(container);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containsPackages(IContainer container) {
        if (!container.isDerived() && JavaUtil.isJavaPackage((IContainer)container)) {
            return true;
        }
        try {
            IResource[] children;
            IResource[] iResourceArray = children = container.members();
            int n = children.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource child = iResourceArray[n2];
                if (!child.isDerived() && child instanceof IContainer && this.containsPackages((IContainer)child)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.ui", (CoreException)e);
        }
        return false;
    }
}

