/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.widgets;

import oracle.eclipse.tools.common.ui.util.ThreadUtil;
import oracle.eclipse.tools.common.ui.widgets.IToolTipProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ToolTipTableViewer
extends TableViewer {
    private static final String TOOLTIP_ITEM_LINK = "_TABLEITEM";
    private static final String NAME = "name";
    public static final String WIDGET_NAME_TOOLTIPSHELL = "ToolTipTableViewer.ToolTipShell";
    private final TableListener _tableListener;
    private IToolTipProvider _provider;

    public ToolTipTableViewer(Table table, IToolTipProvider provider) {
        super(table);
        assert (provider != null);
        this._provider = provider;
        table.setToolTipText("");
        this._tableListener = new TableListener();
        table.addListener(12, (Listener)this._tableListener);
        table.addListener(1, (Listener)this._tableListener);
        table.addListener(5, (Listener)this._tableListener);
        table.addListener(32, (Listener)this._tableListener);
    }

    public void closeToolTipShell() {
        ThreadUtil.ensureRunOnUIThread(new Runnable(){

            @Override
            public void run() {
                ToolTipTableViewer.this._tableListener.closeShell();
            }
        });
    }

    private class LabelListener
    implements Listener {
        private LabelListener() {
        }

        public void handleEvent(Event event) {
            Label label = (Label)event.widget;
            Shell shell = label.getShell();
            Table table = ToolTipTableViewer.this.getTable();
            switch (event.type) {
                case 3: {
                    Event e = new Event();
                    e.item = (TableItem)label.getData(ToolTipTableViewer.TOOLTIP_ITEM_LINK);
                    table.setSelection(new TableItem[]{(TableItem)e.item});
                    table.notifyListeners(13, e);
                }
                case 7: {
                    shell.dispose();
                }
            }
        }
    }

    private class TableListener
    implements Listener {
        private Shell _toolTipShell = null;
        private Label _toolTipLabel = null;
        private TableItem _currentItem = null;

        private TableListener() {
        }

        private void closeShell() {
            if (this._toolTipShell != null) {
                this._toolTipShell.dispose();
                this._toolTipShell = null;
                this._toolTipLabel = null;
                this._currentItem = null;
            }
        }

        public void handleEvent(Event event) {
            Table table = ToolTipTableViewer.this.getTable();
            switch (event.type) {
                case 5: {
                    if (this._toolTipShell == null || this._toolTipShell.isDisposed()) break;
                    if (this._currentItem == null || this._currentItem.isDisposed()) {
                        this.closeShell();
                        break;
                    }
                    Rectangle rect = this._currentItem.getBounds(0);
                    if (rect.contains(event.x, event.y)) break;
                    this.closeShell();
                    break;
                }
                case 1: 
                case 3: 
                case 12: {
                    if (this._toolTipShell == null) break;
                    this.closeShell();
                    break;
                }
                case 32: {
                    this._currentItem = table.getItem(new Point(event.x, event.y));
                    if (this._currentItem == null) break;
                    if (this._toolTipShell != null && !this._toolTipShell.isDisposed()) {
                        this._toolTipShell.dispose();
                    }
                    this._toolTipShell = new Shell(table.getDisplay(), 16388);
                    this._toolTipShell.setLayout((Layout)new FillLayout());
                    this._toolTipShell.setData(ToolTipTableViewer.NAME, (Object)ToolTipTableViewer.WIDGET_NAME_TOOLTIPSHELL);
                    Display tableDisplay = table.getDisplay();
                    this._toolTipLabel = new Label((Composite)this._toolTipShell, 0);
                    Color infoForeground = tableDisplay.getSystemColor(28);
                    this._toolTipLabel.setForeground(infoForeground);
                    Color infoBackground = tableDisplay.getSystemColor(29);
                    this._toolTipLabel.setBackground(infoBackground);
                    this._toolTipLabel.setData(ToolTipTableViewer.TOOLTIP_ITEM_LINK, (Object)this._currentItem);
                    Rectangle rect = table.getBounds();
                    ScrollBar hBar = table.getHorizontalBar();
                    int hOffset = hBar.getSelection();
                    int tableRelativeX = event.x - rect.x + hOffset;
                    int columnNumber = 0;
                    int nextMin = rect.x;
                    TableColumn[] tableColumnArray = table.getColumns();
                    int n = tableColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn nextCol = tableColumnArray[n2];
                        int nextMax = nextMin + nextCol.getWidth();
                        if (nextMax >= tableRelativeX) break;
                        nextMin = nextMax;
                        ++columnNumber;
                        ++n2;
                    }
                    Object data = this._currentItem.getData();
                    String toolTipText = ToolTipTableViewer.this._provider.getToolTipText(data, columnNumber);
                    this._toolTipLabel.setText(toolTipText);
                    LabelListener labelListener = new LabelListener();
                    this._toolTipLabel.addListener(7, (Listener)labelListener);
                    this._toolTipLabel.addListener(3, (Listener)labelListener);
                    Point size = this._toolTipShell.computeSize(-1, -1);
                    Point pt = table.toDisplay(event.x, event.y);
                    this._toolTipShell.setBounds(pt.x + 14, pt.y + 14, size.x, size.y);
                    this._toolTipShell.setVisible(true);
                }
            }
        }
    }
}

