/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class PropertyTable
extends Composite {
    private TableViewer table;
    private IMessageDisplay msgdisplay = null;
    private MessageResetter msgresetter = null;
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private Map<String, String> nonModifiableMsgs = new HashMap<String, String>();
    private List<ModifyListener> listeners = new ArrayList<ModifyListener>();

    public PropertyTable(Composite parent) {
        super(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.table = new TableViewer((Composite)this, 67584);
        this.table.getTable().setLayoutData((Object)SwtUtil.gdfill());
        this.table.getTable().setHeaderVisible(false);
        this.table.getTable().setLinesVisible(true);
        this.table.setColumnProperties(new String[]{"key", "value"});
        this.table.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.table.getTable()), new TextCellEditor((Composite)this.table.getTable())});
        this.table.setCellModifier((ICellModifier)new CellModifier());
        TableColumn column = new TableColumn(this.table.getTable(), 16384);
        column.setWidth(150);
        column.setResizable(false);
        column = new TableColumn(this.table.getTable(), 16384);
        column.setWidth(200);
        IStructuredContentProvider tableContentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object element) {
                Map props = PropertyTable.this.properties;
                return props.entrySet().toArray(new Map.Entry[props.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
            }
        };
        this.table.setContentProvider((IContentProvider)tableContentProvider);
        ITableLabelProvider tableLabelProvider = new ITableLabelProvider(){

            public String getColumnText(Object element, int col) {
                Map.Entry entry = (Map.Entry)element;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                switch (col) {
                    case 0: {
                        return key;
                    }
                    case 1: {
                        return value;
                    }
                }
                throw new IllegalStateException();
            }

            public Image getColumnImage(Object element, int col) {
                return null;
            }

            public boolean isLabelProperty(Object obj, String s) {
                return false;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }
        };
        this.table.setLabelProvider((IBaseLabelProvider)tableLabelProvider);
        this.table.setInput((Object)new Integer(5));
    }

    public void defineProperty(String name) {
        this.properties.put(name, "");
        this.table.refresh();
    }

    public String getProperty(String name) {
        String value = this.properties.get(name).trim();
        if (value.length() == 0) {
            return null;
        }
        return value;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value == null ? "" : value);
        this.table.refresh();
    }

    public void setModifiable(String property, boolean modifiable, String nonModifiableMsg) {
        if (modifiable) {
            this.nonModifiableMsgs.remove(property);
        } else {
            this.nonModifiableMsgs.put(property, nonModifiableMsg);
        }
    }

    public void setMessageDisplay(IMessageDisplay msgdisplay) {
        if (this.msgdisplay != null) {
            throw new IllegalStateException();
        }
        this.msgdisplay = msgdisplay;
        this.msgresetter = new MessageResetter();
    }

    public void addModifyListener(ModifyListener listener) {
        this.listeners.add(listener);
    }

    public void clearSelection() {
        this.table.setSelection((ISelection)new StructuredSelection());
    }

    private void notifyListeners() {
        for (ModifyListener listener : this.listeners) {
            listener.modifyText(null);
        }
    }

    protected void finalize() {
        if (this.msgresetter != null) {
            this.msgresetter.dispose();
        }
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (PropertyTable.this.msgdisplay != null) {
                PropertyTable.this.msgdisplay.clearMessage();
            }
            if (property.equals("value")) {
                Map.Entry entry = (Map.Entry)element;
                String msg = (String)PropertyTable.this.nonModifiableMsgs.get(entry.getKey());
                if (msg == null) {
                    return true;
                }
                if (PropertyTable.this.msgdisplay != null) {
                    PropertyTable.this.msgdisplay.displayMessage(msg);
                    PropertyTable.this.msgresetter.schedule(3000);
                }
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            if (property.equals("value")) {
                Map.Entry entry = (Map.Entry)element;
                return entry.getValue();
            }
            throw new IllegalStateException();
        }

        public void modify(Object element, String property, Object value) {
            if (!property.equals("value")) {
                throw new IllegalStateException();
            }
            Map.Entry entry = (Map.Entry)((TableItem)element).getData();
            String key = (String)entry.getKey();
            PropertyTable.this.properties.put(key, (String)value);
            PropertyTable.this.table.refresh();
            PropertyTable.this.notifyListeners();
        }
    }

    public static interface IMessageDisplay {
        public void displayMessage(String var1);

        public void clearMessage();
    }

    private final class MessageResetter
    extends Thread {
        private boolean running = true;
        private int delay = 0;

        public MessageResetter() {
            this.start();
        }

        public synchronized void schedule(int delay) {
            this.delay = delay;
            this.interrupt();
        }

        public void dispose() {
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            r = new Runnable(){

                @Override
                public void run() {
                    PropertyTable.this.msgdisplay.clearMessage();
                }
            };
            while (this.running) {
                var2_2 = this;
                synchronized (var2_2) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException v0) {}
                    if (true) ** GOTO lbl27
                }
                do {
                    var3_4 = this;
                    synchronized (var3_4) {
                        d = this.delay;
                        this.delay = 0;
                    }
                    try {
                        Thread.sleep(d);
                    }
                    catch (InterruptedException v3) {}
lbl27:
                    // 3 sources

                } while (this.delay != 0);
                Display.getDefault().asyncExec(r);
            }
        }
    }
}

