/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.common.ui.widgets.AbstractComposite;
import oracle.eclipse.tools.common.ui.widgets.IModelBindingWidget;
import oracle.eclipse.tools.common.util.IModel;
import oracle.eclipse.tools.common.util.ProjectUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public final class ProjectsSelectionPanel
extends AbstractComposite
implements IModelBindingWidget {
    private final ContentProvider contentProvider;
    private final CheckboxTreeViewer projectsTree;
    private final Button selectAllButton;
    private final Button deselectAllButton;
    private final Button showReferencesCheckbox;
    private final Set<IListener> listeners = new HashSet<IListener>();

    public ProjectsSelectionPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.projectsTree = new CheckboxTreeViewer((Composite)this);
        this.projectsTree.getTree().setLayoutData((Object)SwtUtil.gdfill());
        this.contentProvider = new ContentProvider();
        this.projectsTree.setContentProvider((IContentProvider)this.contentProvider);
        this.projectsTree.setLabelProvider((IBaseLabelProvider)new LabelProvider(this.contentProvider));
        this.projectsTree.setSorter((ViewerSorter)new Sorter());
        this.projectsTree.setInput((Object)ResourcesPlugin.getWorkspace());
        this.projectsTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectsSelectionPanel.this.handleCheckStateChangedEvent(event);
            }
        });
        Composite buttons = new Composite((Composite)this, 0);
        buttons.setLayoutData((Object)SwtUtil.valign(new GridData(), 128));
        GridLayout buttonsCompositeLayout = new GridLayout(1, false);
        buttonsCompositeLayout.marginHeight = 0;
        buttonsCompositeLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonsCompositeLayout);
        this.selectAllButton = new Button(buttons, 8);
        this.selectAllButton.setText(Resources.selectAllLabel);
        this.setButtonLayoutData(this.selectAllButton);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProjectsSelectionPanel.this.handleSelectAllPressed();
            }
        });
        this.deselectAllButton = new Button(buttons, 8);
        this.deselectAllButton.setText(Resources.deselectAllLabel);
        this.setButtonLayoutData(this.deselectAllButton);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProjectsSelectionPanel.this.handleDeselectAllPressed();
            }
        });
        this.showReferencesCheckbox = new Button((Composite)this, 32);
        this.showReferencesCheckbox.setLayoutData((Object)SwtUtil.vspan(SwtUtil.gd(), 2));
        this.showReferencesCheckbox.setText(Resources.showReferencesCheckboxLabel);
        this.showReferencesCheckbox.setSelection(false);
        this.showReferencesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProjectsSelectionPanel.this.handleShowReferencesCheckbox();
            }
        });
    }

    public Set<IProject> getSelectedProjects() {
        HashSet<IProject> projects = new HashSet<IProject>();
        Object[] objectArray = this.projectsTree.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            projects.add((IProject)ProjectsSelectionPanel.toProjectNode(obj).getElement());
            ++n2;
        }
        return projects;
    }

    public void setSelectedProjects(Set<IProject> projects) {
        ArrayList<ProjectUtil.Node<IProject>> nodes = new ArrayList<ProjectUtil.Node<IProject>>();
        for (IProject project : projects) {
            nodes.addAll(this.contentProvider.getNodesForProject(project));
        }
        this.projectsTree.setCheckedElements(nodes.toArray());
        this.refreshGrayedState();
    }

    public void addSelectedProjectsListener(IListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectedProjectsListener(IListener listener) {
        this.listeners.remove(listener);
    }

    private void notifySelectedProjectsListeners() {
        for (IListener listener : this.listeners) {
            listener.handleEvent();
        }
    }

    @Override
    public void bind(final IModel model, final String property) {
        final Object monitor = new Object();
        final boolean[] settingSelectedProjects = new boolean[1];
        final IModel.IListener modelListener = new IModel.IListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChanged(String prop, Object oldValue, Object newValue) {
                if (prop.equals(property)) {
                    Object object = monitor;
                    synchronized (object) {
                        if (!settingSelectedProjects[0]) {
                            ProjectsSelectionPanel.this.setSelectedProjects((Set)newValue);
                        }
                    }
                }
            }
        };
        model.addListener(modelListener, new String[0]);
        this.addSelectedProjectsListener(new IListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent() {
                Object object = monitor;
                synchronized (object) {
                    settingSelectedProjects[0] = true;
                    model.setProperty(property, ProjectsSelectionPanel.this.getSelectedProjects());
                    settingSelectedProjects[0] = false;
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                model.removeListener(modelListener);
            }
        });
        this.setSelectedProjects((Set)model.getProperty(property));
    }

    private void handleCheckStateChangedEvent(CheckStateChangedEvent event) {
        ProjectUtil.Node<IProject> node = ProjectsSelectionPanel.toProjectNode(event.getElement());
        ArrayList<IProject> projects = new ArrayList<IProject>();
        projects.add((IProject)node.getElement());
        for (ProjectUtil.Node n : node.getAllChildren()) {
            projects.add((IProject)n.getElement());
        }
        ArrayList<ProjectUtil.Node<IProject>> nodes = new ArrayList<ProjectUtil.Node<IProject>>();
        for (IProject iProject : projects) {
            nodes.addAll(this.contentProvider.getNodesForProject(iProject));
        }
        for (ProjectUtil.Node node2 : nodes) {
            this.projectsTree.setChecked((Object)node2, event.getChecked());
        }
        this.refreshGrayedState();
        this.notifySelectedProjectsListeners();
    }

    private void handleSelectAllPressed() {
        this.projectsTree.setAllChecked(true);
        this.refreshGrayedState();
        this.notifySelectedProjectsListeners();
    }

    private void handleDeselectAllPressed() {
        this.projectsTree.setAllChecked(false);
        this.refreshGrayedState();
        this.notifySelectedProjectsListeners();
    }

    private void handleShowReferencesCheckbox() {
        Set<IProject> selectedProjects = this.getSelectedProjects();
        boolean showReferences = this.showReferencesCheckbox.getSelection();
        boolean success = this.contentProvider.setShowProjectReferenceHierarchy(showReferences);
        if (showReferences && !success) {
            this.showReferencesCheckbox.setSelection(false);
        }
        this.projectsTree.refresh();
        this.setSelectedProjects(selectedProjects);
        Object[] objectArray = this.projectsTree.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.projectsTree.reveal(element);
            ++n2;
        }
    }

    private void refreshGrayedState() {
        ArrayList<ProjectUtil.Node<IProject>> nodesToBeGrayed = new ArrayList<ProjectUtil.Node<IProject>>();
        Object[] objectArray = this.contentProvider.getElements(null);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            this.refreshGrayedState(ProjectsSelectionPanel.toProjectNode(node), nodesToBeGrayed);
            ++n2;
        }
        this.projectsTree.setGrayedElements(nodesToBeGrayed.toArray());
    }

    private boolean refreshGrayedState(ProjectUtil.Node<IProject> node, List<ProjectUtil.Node<IProject>> nodesToBeGrayed) {
        boolean allChildrenChecked = true;
        for (ProjectUtil.Node n : node.getChildren()) {
            if (this.refreshGrayedState((ProjectUtil.Node<IProject>)n, nodesToBeGrayed)) continue;
            allChildrenChecked = false;
        }
        boolean isThisNodeChecked = this.projectsTree.getChecked(node);
        if (isThisNodeChecked && !allChildrenChecked) {
            nodesToBeGrayed.add(node);
        }
        return isThisNodeChecked && allChildrenChecked;
    }

    private static ProjectUtil.Node<IProject> toProjectNode(Object object) {
        return (ProjectUtil.Node)object;
    }

    private static final class ContentProvider
    implements ITreeContentProvider {
        private IWorkspace ws = null;
        private boolean showReferences = false;
        private List<ProjectUtil.Node<IProject>> model = null;
        private Map<ProjectUtil.Node<IProject>, ProjectUtil.Node<IProject>> childToParentMap = null;

        private ContentProvider() {
        }

        public synchronized boolean setShowProjectReferenceHierarchy(boolean showReferences) {
            this.showReferences = showReferences;
            return this.rebuildModel();
        }

        public synchronized Object[] getElements(Object input) {
            return this.model.toArray();
        }

        public synchronized Object[] getChildren(Object parent) {
            return ((ProjectUtil.Node)parent).getChildren().toArray();
        }

        public synchronized Object getParent(Object element) {
            return this.childToParentMap.get(element);
        }

        public synchronized boolean hasChildren(Object element) {
            return ((ProjectUtil.Node)element).hasChildren();
        }

        public synchronized void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.ws = (IWorkspace)newInput;
            this.rebuildModel();
        }

        public void dispose() {
        }

        public synchronized Set<ProjectUtil.Node<IProject>> getNodesForProject(IProject project) {
            HashSet<ProjectUtil.Node<IProject>> nodes = new HashSet<ProjectUtil.Node<IProject>>();
            this.getNodesForProject(project, this.model, nodes);
            return nodes;
        }

        private synchronized void getNodesForProject(IProject project, List<ProjectUtil.Node<IProject>> graph, Set<ProjectUtil.Node<IProject>> result) {
            for (ProjectUtil.Node<IProject> node : graph) {
                if (((IProject)node.getElement()).equals((Object)project)) {
                    result.add(node);
                }
                this.getNodesForProject(project, node.getChildren(), result);
            }
        }

        private boolean rebuildModel() {
            if (this.ws == null) {
                return true;
            }
            try {
                if (this.showReferences) {
                    List graph = ProjectUtil.getProjectReferenceGraph();
                    ProjectUtil.Node root = new ProjectUtil.Node();
                    root.setChildren(graph);
                    root = root.convertDagToTree();
                    this.model = root.getChildren();
                } else {
                    this.model = new ArrayList<ProjectUtil.Node<IProject>>();
                    IProject[] iProjectArray = this.ws.getRoot().getProjects();
                    int n = iProjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        if (project.isAccessible()) {
                            ProjectUtil.Node node = new ProjectUtil.Node();
                            node.setElement((Object)project);
                            this.model.add((ProjectUtil.Node<IProject>)node);
                        }
                        ++n2;
                    }
                }
            }
            catch (ProjectUtil.CircularReferencesException circularReferencesException) {
                DialogService.showErrorDialog(Resources.circularReferencesMessage);
                this.setShowProjectReferenceHierarchy(false);
                return false;
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.ui", (CoreException)e);
                this.model = Collections.emptyList();
            }
            this.childToParentMap = new HashMap<ProjectUtil.Node<IProject>, ProjectUtil.Node<IProject>>();
            for (ProjectUtil.Node<IProject> node : this.model) {
                this.rebuildChildToParentMap(node);
            }
            return true;
        }

        private void rebuildChildToParentMap(ProjectUtil.Node<IProject> node) {
            for (ProjectUtil.Node child : node.getChildren()) {
                this.childToParentMap.put((ProjectUtil.Node<IProject>)child, node);
                this.rebuildChildToParentMap((ProjectUtil.Node<IProject>)child);
            }
        }
    }

    public static interface IListener {
        public void handleEvent();
    }

    private static final class LabelProvider
    extends DecoratingLabelProvider {
        private final ContentProvider contentProvider;
        private final Map<ILabelProviderListener, ILabelProviderListener> listenerToAdapterMap;

        public LabelProvider(ContentProvider contentProvider) {
            super((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
            this.contentProvider = contentProvider;
            this.listenerToAdapterMap = new HashMap<ILabelProviderListener, ILabelProviderListener>();
        }

        public ContentProvider getContentProvider() {
            return this.contentProvider;
        }

        public void addListener(final ILabelProviderListener listener) {
            ILabelProviderListener adapter = new ILabelProviderListener(){

                public void labelProviderChanged(LabelProviderChangedEvent event) {
                    Object[] elements = event.getElements();
                    if (elements == null) {
                        listener.labelProviderChanged(event);
                        return;
                    }
                    ArrayList<ProjectUtil.Node<IProject>> nodes = new ArrayList<ProjectUtil.Node<IProject>>();
                    Object[] objectArray = event.getElements();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        IProject pj = null;
                        if (element instanceof IProject) {
                            pj = (IProject)element;
                        } else if (element instanceof IAdaptable) {
                            pj = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                        }
                        if (pj != null) {
                            nodes.addAll(LabelProvider.this.getContentProvider().getNodesForProject(pj));
                        }
                        ++n2;
                    }
                    LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), nodes.toArray());
                    listener.labelProviderChanged(newEvent);
                }
            };
            super.addListener(adapter);
            this.listenerToAdapterMap.put(listener, adapter);
        }

        public void removeListener(ILabelProviderListener listener) {
            super.removeListener(this.listenerToAdapterMap.remove(listener));
        }

        public Image getImage(Object element) {
            return super.getImage((Object)LabelProvider.adapt(element));
        }

        public String getText(Object element) {
            return super.getText((Object)LabelProvider.adapt(element));
        }

        public boolean isLabelProperty(Object element, String property) {
            return super.isLabelProperty((Object)LabelProvider.adapt(element), property);
        }

        public void updateLabel(ViewerLabel settings, Object element) {
            super.updateLabel(settings, (Object)LabelProvider.adapt(element));
        }

        public Color getBackground(Object element) {
            return super.getBackground((Object)LabelProvider.adapt(element));
        }

        public Font getFont(Object element) {
            return super.getFont((Object)LabelProvider.adapt(element));
        }

        public Color getForeground(Object element) {
            return super.getForeground((Object)LabelProvider.adapt(element));
        }

        public void updateLabel(ViewerLabel settings, TreePath elementPath) {
            Object[] newSegments = new Object[elementPath.getSegmentCount()];
            int i = 0;
            int n = elementPath.getSegmentCount();
            while (i < n) {
                newSegments[i] = LabelProvider.adapt(elementPath.getSegment(i));
                ++i;
            }
            super.updateLabel(settings, new TreePath(newSegments));
        }

        private static IProject adapt(Object obj) {
            if (obj instanceof IProject) {
                return (IProject)obj;
            }
            return (IProject)ProjectsSelectionPanel.toProjectNode(obj).getElement();
        }
    }

    private static final class Resources
    extends NLS {
        public static String selectAllLabel;
        public static String deselectAllLabel;
        public static String showReferencesCheckboxLabel;
        public static String circularReferencesMessage;

        static {
            Resources.initializeMessages((String)ProjectsSelectionPanel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private static final class Sorter
    extends ViewerSorter {
        private Sorter() {
        }

        public int compare(Viewer viewer, Object a, Object b) {
            String aName = ((IProject)ProjectsSelectionPanel.toProjectNode(a).getElement()).getName();
            String bName = ((IProject)ProjectsSelectionPanel.toProjectNode(b).getElement()).getName();
            return aName.compareTo(bName);
        }
    }
}

