/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.widgets;

import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.common.ui.widgets.EnhancedComposite;
import oracle.eclipse.tools.common.ui.widgets.IModelBindingWidget;
import oracle.eclipse.tools.common.util.IModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class ModelBindingText
extends EnhancedComposite
implements IModelBindingWidget {
    private final Text textBox;

    public ModelBindingText(Composite parent, int style) {
        super(parent, 0);
        this.setLayout((Layout)SwtUtil.glayout(1, 0, 0));
        this.textBox = new Text((Composite)this, style);
        this.textBox.setLayoutData((Object)SwtUtil.gdhfill());
    }

    public Text getTextWidget() {
        return this.textBox;
    }

    public String getText() {
        return this.textBox.getText();
    }

    public void setText(String text) {
        this.textBox.setText(text);
    }

    public void setForeground(Color color) {
        this.textBox.setForeground(color);
    }

    @Override
    public void bind(IModel model, String property) {
        ModelBindingText.bind(this.textBox, model, property);
    }

    public static void bind(final Text textBox, final IModel model, final String property) {
        final IModel.IListener modelListener = new IModel.IListener(){

            public void propertyChanged(String prop, Object oldValue, Object newValue) {
                if (prop.equals(property)) {
                    String val = ModelBindingText.toString(newValue);
                    if (!textBox.getText().equals(val)) {
                        textBox.setText(val);
                    }
                }
            }
        };
        model.addListener(modelListener, new String[0]);
        textBox.setText(ModelBindingText.toString(model.getProperty(property)));
        if ((textBox.getStyle() & 8) == 0) {
            textBox.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    model.setProperty(property, (Object)textBox.getText());
                }
            });
        }
        textBox.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                model.removeListener(modelListener);
            }
        });
    }

    public void addModifyListener(ModifyListener listener) {
        this.textBox.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.textBox.removeModifyListener(listener);
    }

    private static final String toString(Object object) {
        return object == null ? "" : object.toString();
    }
}

