/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.util.otn;

import java.io.IOException;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.common.ui.util.otn.BrowserLauncher;
import oracle.eclipse.tools.common.ui.util.otn.Resources;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class OTNLoginWizardPage
extends WizardPage {
    boolean isLicenseAccepted = false;
    private Text userText;
    private Text passwordText;
    private Button savePasswdCheckbox;
    private Button acceptLicense;
    private static final String OTN_SIGNUP_URL = "https://myprofile.oracle.com/EndUser/faces/profile/createUser.jspx";

    public OTNLoginWizardPage() {
        super("OTN Login Page");
        this.setTitle(Resources.OTN);
        this.setDescription(Resources.loginPromptText);
        this.setImageDescriptor(CommonImages.DESC_WIZBAN_ORACLE);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 10;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        Browser otnLicensePage = new Browser(composite, 2048);
        otnLicensePage.setUrl("http://www.oracle.com/technetwork/licenses/standard-license-152015.html");
        GridData gd = new GridData(1, 1, true, false, 2, 1);
        gd.widthHint = 800;
        gd.heightHint = 300;
        otnLicensePage.setLayoutData((Object)gd);
        Composite radioGrp = new Composite(composite, 0);
        radioGrp.setLayout((Layout)SwtUtil.glayout(2));
        gd = SwtUtil.gdhfill();
        gd.horizontalSpan = 2;
        radioGrp.setLayoutData((Object)gd);
        this.acceptLicense = new Button(radioGrp, 16);
        this.acceptLicense.setText("&Accept");
        this.acceptLicense.setSelection(false);
        Button declineLicense = new Button(radioGrp, 16);
        declineLicense.setText("&Decline");
        Label sep = new Label(composite, 0);
        gd = SwtUtil.gdhfill();
        gd.horizontalSpan = 2;
        sep.setLayoutData((Object)gd);
        Label userLabel = new Label(composite, 0);
        userLabel.setText(Resources.userName);
        userLabel.setLayoutData((Object)new GridData());
        this.userText = new Text(composite, 2048);
        gd = new GridData(4, 2, true, false);
        gd.widthHint = 200;
        this.userText.setLayoutData((Object)gd);
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setText(Resources.password);
        passwordLabel.setLayoutData((Object)new GridData());
        this.passwordText = new Text(composite, 0x400800);
        gd = new GridData(4, 2, true, false);
        this.passwordText.setLayoutData((Object)gd);
        Label space = new Label(composite, 0);
        space.setLayoutData((Object)new GridData());
        this.savePasswdCheckbox = new Button(composite, 32);
        this.savePasswdCheckbox.setText(Resources.saveLoginInfo);
        gd = new GridData(1, 1, true, false, 1, 1);
        this.savePasswdCheckbox.setLayoutData((Object)gd);
        this.savePasswdCheckbox.setSelection(true);
        space = new Label(composite, 0);
        space.setLayoutData((Object)new GridData());
        String signUpLink = Resources.signUpLink;
        Hyperlink signUpPrompt = new Hyperlink(composite, 64);
        signUpPrompt.setText(signUpLink);
        signUpPrompt.setForeground(SwtUtil.color(9));
        signUpPrompt.setUnderlined(true);
        gd = new GridData(4, 2, true, false);
        gd.widthHint = 300;
        signUpPrompt.setLayoutData((Object)gd);
        signUpPrompt.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent arg0) {
            }

            public void linkEntered(HyperlinkEvent arg0) {
            }

            public void linkActivated(HyperlinkEvent arg0) {
                try {
                    BrowserLauncher.displayURL(OTNLoginWizardPage.OTN_SIGNUP_URL);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.retrieveSavedLoginInfo();
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OTNLoginWizardPage.this.getWizard().getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.acceptLicense.addSelectionListener(listener);
        declineLicense.addSelectionListener(listener);
        this.userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OTNLoginWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OTNLoginWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.setControl((Control)composite);
    }

    public String getUserName() {
        String userName = this.userText.getText();
        return userName;
    }

    public String getPassword() {
        String password = this.passwordText.getText();
        return password;
    }

    public boolean validate() {
        boolean valid = this.userText.getText().trim().length() > 0 && this.passwordText.getText().trim().length() > 0 && this.acceptLicense.getSelection();
        return valid;
    }

    public boolean isSaveLoginInfo() {
        return this.savePasswdCheckbox.getSelection();
    }

    private void retrieveSavedLoginInfo() {
        try {
            ISecurePreferences root = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = root.node("/oracle/eclipse/tools/oepe/otn");
            if (node != null) {
                String name = node.get("username", null);
                String passwd = node.get("password", null);
                if (name != null && passwd != null) {
                    this.userText.setText(name);
                    this.passwordText.setText(passwd);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            OTNLoginWizardPage.this.validate();
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void persistLoginInfo() {
        if (this.isSaveLoginInfo()) {
            this.saveLoginInfo(this.getUserName(), this.getPassword());
        } else {
            OTNLoginWizardPage.clearSavedLoginInfo();
        }
    }

    void saveLoginInfo(String userName, String password) {
        try {
            ISecurePreferences root = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = root.node("/oracle/eclipse/tools/oepe/otn");
            node.put("username", userName, true);
            node.put("password", password, true);
            root.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void clearSavedLoginInfo() {
        try {
            ISecurePreferences root = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = root.node("/oracle/eclipse/tools/oepe/otn");
            if (node != null) {
                node.removeNode();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

