/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.util;

public class ValidationMarker {
    private final boolean _isValid;
    private final String _message;
    private final MarkerType _type;

    public ValidationMarker(boolean isValid, String message, MarkerType type) {
        assert (type == MarkerType.ERROR_TYPE && !isValid || type != MarkerType.ERROR_TYPE);
        this._isValid = isValid;
        this._message = message;
        this._type = type;
    }

    public String getMessage() {
        return this._message;
    }

    public boolean isMessage() {
        return this._type == MarkerType.MESSAGE_TYPE;
    }

    public boolean isError() {
        return this._type == MarkerType.ERROR_TYPE;
    }

    public boolean isValid() {
        return this._isValid;
    }

    public boolean isWarning() {
        return this._type == MarkerType.WARNING_TYPE;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this._type.name());
        buffer.append(":");
        buffer.append(this._message);
        return buffer.toString();
    }

    public static enum MarkerType {
        MESSAGE_TYPE,
        ERROR_TYPE,
        WARNING_TYPE;

    }
}

