/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.util;

import oracle.eclipse.tools.common.util.MutableReference;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class SwtUtil {
    public static final GridLayout glayout(int columns) {
        return new GridLayout(columns, false);
    }

    public static final GridLayout glayout(int columns, int marginWidth, int marginHeight) {
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginWidth;
        layout.marginHeight = marginHeight;
        return layout;
    }

    public static final GridLayout glayout(int columns, int leftMargin, int rightMargin, int topMargin, int bottomMargin) {
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginLeft = leftMargin;
        layout.marginRight = rightMargin;
        layout.marginTop = topMargin;
        layout.marginBottom = bottomMargin;
        return layout;
    }

    public static final GridLayout glspacing(GridLayout layout, int spacing) {
        return SwtUtil.glspacing(layout, spacing, spacing);
    }

    public static final GridLayout glspacing(GridLayout layout, int horizonal, int vertical) {
        layout.horizontalSpacing = horizonal;
        layout.verticalSpacing = vertical;
        return layout;
    }

    public static final GridData gd() {
        return new GridData();
    }

    public static final GridData gdfill() {
        return new GridData(4, 4, true, true);
    }

    public static final GridData gdhfill() {
        return new GridData(768);
    }

    public static final GridData gdvfill() {
        return new GridData(1040);
    }

    public static final GridData gdhhint(GridData gd, int heightHint) {
        gd.heightHint = heightHint;
        return gd;
    }

    public static final GridData gdwhint(GridData gd, int widthHint) {
        gd.widthHint = widthHint;
        return gd;
    }

    public static final GridData gdhindent(GridData gd, int horizontalIndent) {
        gd.horizontalIndent = horizontalIndent;
        return gd;
    }

    public static final GridData gdvindent(GridData gd, int verticalIndent) {
        gd.verticalIndent = verticalIndent;
        return gd;
    }

    public static final GridData hspan(GridData gd, int span) {
        gd.horizontalSpan = span;
        return gd;
    }

    public static final GridData vspan(GridData gd, int span) {
        gd.verticalSpan = span;
        return gd;
    }

    public static final GridData halign(GridData gd, int alignment) {
        gd.horizontalAlignment = alignment;
        return gd;
    }

    public static final GridData valign(GridData gd, int alignment) {
        gd.verticalAlignment = alignment;
        return gd;
    }

    public static Color color(int id) {
        return Display.getCurrent().getSystemColor(id);
    }

    public static final int getPreferredWidth(Control control) {
        return control.computeSize((int)-1, (int)-1).x;
    }

    public static Shell getActiveShell() {
        if (PlatformUI.isWorkbenchRunning()) {
            final IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            final Shell[] result = new Shell[1];
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                    result[0] = window != null ? window.getShell() : null;
                }
            });
            return result[0];
        }
        return null;
    }

    public static boolean hasModalShell(final Display display) {
        if (display.isDisposed()) {
            return false;
        }
        final MutableReference result = new MutableReference();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                result.set((Object)Boolean.FALSE);
                Shell[] shellArray = display.getShells();
                int n = shellArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell shell = shellArray[n2];
                    if (!shell.isDisposed() && shell.isVisible() && (shell.getStyle() & 0x10000) != 0) {
                        result.set((Object)Boolean.TRUE);
                        break;
                    }
                    ++n2;
                }
            }
        });
        return (Boolean)result.get();
    }

    public static void waitOnModalShells() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        while (SwtUtil.hasModalShell(display)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void setEnabledOnChildren(Composite composite, boolean enabled) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setEnabled(enabled);
            ++n2;
        }
    }

    public static void runOnDisplayThread(Display display, Runnable runnable) {
        if (display.getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            display.asyncExec(runnable);
        }
    }

    public static TreeItem getTreeItem(Tree tree, int x, int y) {
        return SwtUtil.getTreeItem(tree.getItems(), x, y);
    }

    private static TreeItem getTreeItem(TreeItem[] items, int x, int y) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Rectangle bounds = item.getBounds();
            bounds.add(new Rectangle(bounds.x - 25, bounds.y, 25, bounds.height));
            if (bounds.contains(x, y)) {
                return item;
            }
            TreeItem res = SwtUtil.getTreeItem(item.getItems(), x, y);
            if (res != null) {
                return res;
            }
            ++n2;
        }
        return null;
    }
}

