/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.util;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.common.ui.util.ProblemOverlayImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public final class ImageCache {
    public static final int STYLE_NONE = 0;
    public static final int STYLE_ERROR = 1;
    public static final int STYLE_WARNING = 2;
    private final Map<ImageDescriptor, Map<Integer, Image>> cache = new HashMap<ImageDescriptor, Map<Integer, Image>>();

    public Image getImage(ImageDescriptor imageDescriptor) {
        return this.getImage(imageDescriptor, 0);
    }

    public Image getImage(ImageDescriptor imageDescriptor, int style) {
        Image image;
        Map<Integer, Image> derivativeImages = this.cache.get(imageDescriptor);
        if (derivativeImages == null) {
            derivativeImages = new HashMap<Integer, Image>();
            this.cache.put(imageDescriptor, derivativeImages);
        }
        if ((image = derivativeImages.get(style)) == null) {
            Object desc = imageDescriptor;
            if ((style & 1) != 0) {
                desc = new ProblemOverlayImageDescriptor((ImageDescriptor)desc, 4);
            }
            if ((style & 2) != 0) {
                desc = new ProblemOverlayImageDescriptor((ImageDescriptor)desc, 2);
            }
            image = desc.createImage();
            derivativeImages.put(style, image);
        }
        return image;
    }

    public static int getStyle(int statusSeverity) {
        switch (statusSeverity) {
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public void dispose() {
        for (Map<Integer, Image> derivativeImages : this.cache.values()) {
            for (Image image : derivativeImages.values()) {
                image.dispose();
            }
        }
        this.cache.clear();
    }
}

