/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.preferences;

import oracle.eclipse.tools.common.ui.preferences.IProjectPropertyHandler;
import oracle.eclipse.tools.common.util.ResourceLoader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public abstract class ProjectPropertyAndPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private static final ResourceLoader _resourceLoader = new ResourceLoader(ProjectPropertyAndPreferencesPage.class);
    private ControlEnableState _blockEnableState;
    private Hyperlink _changeWorkspaceSettingsLink;
    private Control _configurationBlockControl;
    private IProject _project;
    private Button _useProjectSettings;
    private boolean _workspaceSettingsOverridable = true;
    private final String _preferencePageID;
    private final IProjectPropertyHandler _projectPropertyReader;
    private static final String NO_LINK_DATA = "nolink";
    public static final String DATA_NAME = "name";
    public static final String WIDGET_NAME_SELECTION_BUTTON = "ProjectPropertyAndPreferencesPage.OverrideWorkspaceSettings.";
    public static final String WIDGET_NAME_PREFERENCES_LINK = "ProjectPropertyAndPreferencesPage.ConfigureWorkspaceSettings.";

    public ProjectPropertyAndPreferencesPage(String preferencePageID, IProjectPropertyHandler reader) {
        super(1);
        this._projectPropertyReader = reader;
        this._preferencePageID = preferencePageID;
    }

    public void applyData(Object data) {
        if (this._changeWorkspaceSettingsLink != null) {
            this.updateLinkVisibility();
        }
    }

    protected abstract void buildFieldEditors();

    protected Label createDescriptionLabel(Composite parent) {
        if (this.isProjectPreferencePage() && this.isWorkspaceSettingsOverridable()) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            GridData gd = new GridData(4, 0x1000000, true, false);
            composite.setLayoutData((Object)gd);
            this._useProjectSettings = new Button(composite, 32);
            String useLabel = _resourceLoader.resource("preferencesPage.label.useProjectSettings", new Object[0]);
            this._useProjectSettings.setText(useLabel);
            this._useProjectSettings.setData(DATA_NAME, (Object)(WIDGET_NAME_SELECTION_BUTTON + this._preferencePageID));
            gd = new GridData();
            gd.horizontalSpan = 1;
            gd.horizontalAlignment = 4;
            this._useProjectSettings.setLayoutData((Object)gd);
            SelectionListener listener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ProjectPropertyAndPreferencesPage.this.doProjectWorkspaceStateChanged();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    ProjectPropertyAndPreferencesPage.this.doProjectWorkspaceStateChanged();
                }
            };
            this._useProjectSettings.addSelectionListener(listener);
            this._changeWorkspaceSettingsLink = this.createLink(composite);
            String configLabel = _resourceLoader.resource("preferencesPage.label.configureWorkspaceSettings", new Object[0]);
            this._changeWorkspaceSettingsLink.setText(configLabel);
            gd = new GridData(0x1000008, 0x1000000, false, false);
            this._changeWorkspaceSettingsLink.setLayoutData((Object)gd);
            this._changeWorkspaceSettingsLink.setData(DATA_NAME, (Object)(WIDGET_NAME_PREFERENCES_LINK + this._preferencePageID));
            Label horizontalLine = new Label(composite, 258);
            gd = new GridData(4, 4, true, false, 2, 1);
            horizontalLine.setLayoutData((Object)gd);
        }
        return super.createDescriptionLabel(parent);
    }

    public final void createFieldEditors() {
        this._configurationBlockControl = this.getFieldEditorParent();
        Composite parent = this.getFieldEditorParent();
        String helpContextID = this.getHelpContextID();
        if (helpContextID != null) {
            IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
            help.setHelp((Control)parent, helpContextID);
        }
        this.buildFieldEditors();
    }

    private Hyperlink createLink(Composite composite) {
        Hyperlink link = new Hyperlink(composite, 0);
        link.setUnderlined(true);
        link.setForeground(JFaceResources.getColorRegistry().get("HYPERLINK_COLOR"));
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ProjectPropertyAndPreferencesPage.this.doLinkActivated((Hyperlink)e.widget);
            }

            public void linkEntered(HyperlinkEvent e) {
                ((Hyperlink)e.widget).setForeground(JFaceResources.getColorRegistry().get("ACTIVE_HYPERLINK_COLOR"));
            }

            public void linkExited(HyperlinkEvent e) {
                ((Hyperlink)e.widget).setForeground(JFaceResources.getColorRegistry().get("HYPERLINK_COLOR"));
            }
        });
        return link;
    }

    private final void doLinkActivated(Hyperlink link) {
        if (this.isProjectPreferencePage() && this.isWorkspaceSettingsOverridable()) {
            PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)this._preferencePageID, (String[])new String[]{this._preferencePageID}, (Object)NO_LINK_DATA).open();
        }
    }

    private void doProjectWorkspaceStateChanged() {
        this.enablePreferenceContent(this.useProjectSettings());
        this.updateLinkVisibility();
    }

    private void enablePreferenceContent(boolean enable) {
        if (enable) {
            if (this._blockEnableState != null) {
                this._blockEnableState.restore();
                this._blockEnableState = null;
            }
        } else if (this._blockEnableState == null) {
            this._blockEnableState = ControlEnableState.disable((Control)this._configurationBlockControl);
        }
    }

    public IAdaptable getElement() {
        return this._project;
    }

    protected String getHelpContextID() {
        return null;
    }

    protected IProject getProject() {
        return this._project;
    }

    public final void init(IWorkbench workbench) {
    }

    protected void initialize() {
        boolean useProjectSettings = false;
        if (this.isProjectPreferencePage()) {
            IProject project = this.getProject();
            useProjectSettings = this._projectPropertyReader.usesProjectProperties(project);
            this.initializeProjectSettings();
            if (this._useProjectSettings != null) {
                this._useProjectSettings.setSelection(useProjectSettings);
            }
            this.doProjectWorkspaceStateChanged();
        } else {
            super.initialize();
        }
    }

    protected abstract void initializeProjectSettings();

    protected boolean isProjectPreferencePage() {
        return this._project != null;
    }

    protected boolean isWorkspaceSettingsOverridable() {
        return this._workspaceSettingsOverridable;
    }

    protected void setWorkspaceSettingsOverridable(boolean b) {
        this._workspaceSettingsOverridable = b;
    }

    public void performDefaults() {
        if (this.isProjectPreferencePage() && this.isWorkspaceSettingsOverridable()) {
            this._useProjectSettings.setSelection(false);
            this.doProjectWorkspaceStateChanged();
        } else {
            super.performDefaults();
        }
    }

    public void setElement(IAdaptable element) {
        this._project = (IProject)element.getAdapter(IResource.class);
    }

    protected void updateLinkVisibility() {
        if (this._changeWorkspaceSettingsLink == null || this._changeWorkspaceSettingsLink.isDisposed()) {
            return;
        }
        if (this.isProjectPreferencePage() && this.isWorkspaceSettingsOverridable()) {
            this._changeWorkspaceSettingsLink.setVisible(!this.useProjectSettings());
        }
    }

    protected boolean useProjectSettings() {
        return this._useProjectSettings == null || this.isProjectPreferencePage() && this._useProjectSettings.getSelection();
    }

    protected boolean writeProperties(IProject project, Boolean useProjectSettings) {
        return this._projectPropertyReader.setUseProjectSettings(project, useProjectSettings);
    }
}

