/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class CommonUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "oracle.eclipse.tools.common.ui";
    private static CommonUiPlugin _plugin;
    public static final String DIAGRAM_ICON_DIR = "images/diagram/";
    public static final String HEADER_BKGND_CENTER_NAME = "images/diagram/header_mid_bg.png";
    public static final String HEADER_BKGND_LEFT_NAME = "images/diagram/header_left_bg.png";
    public static final String HEADER_BKGND_RIGHT_NAME = "images/diagram/header_right_bg.png";
    public static final String LINK_CURVED_NAME = "images/diagram/links-curved.png";
    public static final String LINK_CURVED_HOVER_NAME = "images/diagram/links-curved-hover.png";
    public static final String LINK_CURVED_ON_NAME = "images/diagram/links-curved-on.png";
    public static final String LINK_ORTHOGONAL_NAME = "images/diagram/links-orthogonal.png";
    public static final String LINK_ORTHOGONAL_HOVER_NAME = "images/diagram/links-orthogonal-hover.png";
    public static final String LINK_ORTHOGONAL_ON_NAME = "images/diagram/links-orthogonal-on.png";
    public static final String LINK_STRAIGHT_NAME = "images/diagram/links-straight.png";
    public static final String LINK_STRAIGHT_HOVER_NAME = "images/diagram/links-straight-hover.png";
    public static final String LINK_STRAIGHT_ON_NAME = "images/diagram/links-straight-on.png";
    public static final String EXPORT_NAME = "images/diagram/export-as-img.png";
    public static final String EXPORT_HOVER_NAME = "images/diagram/export-as-img-hover.png";
    public static final String PRINT_NAME = "images/diagram/print.png";
    public static final String PRINT_HOVER_NAME = "images/diagram/print-hover.png";
    public static final String REFRESH_NAME = "images/diagram/refresh.png";
    public static final String REFRESH_HOVER_NAME = "images/diagram/refresh-hover.png";
    public static final String TOOLBAR_BG_NAME = "images/diagram/toolbar_bg.png";
    public static final String SHADOW_BOTTOM_NAME = "images/diagram/shadow-bottom.png";
    public static final String SHADOW_SIDE_NAME = "images/diagram/shadow-side.png";
    public static final String SHADOW_LOWER_LEFT_NAME = "images/diagram/shadow-lower-left.png";
    public static final String SHADOW_LOWER_RIGHT_NAME = "images/diagram/shadow-lower-right.png";
    public static final String SHADOW_UPPER_RIGHT_NAME = "images/diagram/shadow-upper-right.png";
    private static final Bundle bundle;
    private static final ILog platformLog;

    static {
        bundle = Platform.getBundle((String)PLUGIN_ID);
        platformLog = Platform.getLog((Bundle)bundle);
    }

    public CommonUiPlugin() {
        _plugin = this;
    }

    public static CommonUiPlugin getDefault() {
        return _plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        Images[] imagesArray = Images.values();
        int n = imagesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Images img = imagesArray[n2];
            img.init(reg);
            ++n2;
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.savePluginPreferences();
        _plugin = null;
    }

    public static void log(Exception e) {
        String message = String.valueOf(e.getMessage());
        CommonUiPlugin.log(CommonUiPlugin.createErrorStatus(message, e));
    }

    public static void log(IStatus status) {
        platformLog.log(status);
    }

    public static void logError(String message) {
        CommonUiPlugin.log(CommonUiPlugin.createErrorStatus(message));
    }

    public static IStatus createErrorStatus(String msg) {
        return CommonUiPlugin.createErrorStatus(msg, null);
    }

    public static IStatus createErrorStatus(Throwable e) {
        return CommonUiPlugin.createErrorStatus(null, e);
    }

    public static IStatus createErrorStatus(String msg, Throwable e) {
        String message = msg;
        if (msg == null && e != null) {
            message = e.getMessage();
        }
        return new Status(4, PLUGIN_ID, 0, message, e);
    }

    public static CoreException createCoreException(String msg) {
        return CommonUiPlugin.createCoreException(msg, null);
    }

    public static CoreException createCoreException(String msg, Throwable e) {
        return new CoreException(CommonUiPlugin.createErrorStatus(msg, e));
    }

    public static enum Images {
        HEADER_BKGND_CENTER_IMAGE("images/diagram/header_mid_bg.png"),
        HEADER_BKGND_LEFT_IMAGE("images/diagram/header_left_bg.png"),
        HEADER_BKGND_RIGHT_IMAGE("images/diagram/header_right_bg.png"),
        LINK_CURVED_IMAGE("images/diagram/links-curved.png"),
        LINK_CURVED_HOVER_IMAGE("images/diagram/links-curved-hover.png"),
        LINK_CURVED_ON_IMAGE("images/diagram/links-curved-on.png"),
        LINK_STRAIGHT_IMAGE("images/diagram/links-straight.png"),
        LINK_STRAIGHT_HOVER_IMAGE("images/diagram/links-straight-hover.png"),
        LINK_STRAIGHT_ON_IMAGE("images/diagram/links-straight-on.png"),
        LINK_ORTHOGONAL_IMAGE("images/diagram/links-orthogonal.png"),
        LINK_ORTHOGONAL_HOVER_IMAGE("images/diagram/links-orthogonal-hover.png"),
        LINK_ORTHOGONAL_ON_IMAGE("images/diagram/links-orthogonal-on.png"),
        EXPORT_IMAGE("images/diagram/export-as-img.png"),
        EXPORT_HOVER_IMAGE("images/diagram/export-as-img-hover.png"),
        PRINT_IMAGE("images/diagram/print.png"),
        PRINT_HOVER_IMAGE("images/diagram/print-hover.png"),
        REFRESH_IMAGE("images/diagram/refresh.png"),
        REFRESH_HOVER_IMAGE("images/diagram/refresh-hover.png"),
        TOOLBAR_BG_IMAGE("images/diagram/toolbar_bg.png"),
        SHADOW_BOTTOM_IMAGE("images/diagram/shadow-bottom.png"),
        SHADOW_SIDE_IMAGE("images/diagram/shadow-side.png"),
        SHADOW_LOWER_RIGHT_IMAGE("images/diagram/shadow-lower-right.png"),
        SHADOW_LOWER_LEFT_IMAGE("images/diagram/shadow-lower-left.png"),
        SHADOW_UPPER_RIGHT_IMAGE("images/diagram/shadow-upper-right.png");

        private String _key;

        private Images(String path) {
            this._key = path;
        }

        private void init(ImageRegistry reg) {
            ImageDescriptor desc = CommonUiPlugin.imageDescriptorFromPlugin((String)CommonUiPlugin.PLUGIN_ID, (String)this._key);
            reg.put(this._key, desc);
        }

        public Image getImage() {
            return CommonUiPlugin.getDefault().getImageRegistry().get(this._key);
        }

        public ImageDescriptor getImageDescriptor() {
            return CommonUiPlugin.getDefault().getImageRegistry().getDescriptor(this._key);
        }
    }
}

